/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.fasta;

import java.io.PrintStream;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RefWalker;
import org.broadinstitute.sting.utils.BaseUtils;

public class FastaStatsWalker
extends RefWalker<Byte, FastaStats> {
    @Output
    PrintStream out;

    @Override
    public Byte map(RefMetaDataTracker rodData, ReferenceContext ref, AlignmentContext context) {
        return ref.getBase();
    }

    @Override
    public FastaStats reduceInit() {
        return new FastaStats();
    }

    @Override
    public FastaStats reduce(Byte base, FastaStats stats) {
        ++stats.nBases;
        if (BaseUtils.isRegularBase((byte)base)) {
            ++stats.nRegBases;
        }
        return stats;
    }

    @Override
    public void onTraversalDone(FastaStats sum) {
        this.out.printf("Total bases   %d%n", sum.nBases);
        this.out.printf("Regular bases %d%n", sum.nRegBases);
    }

    protected class FastaStats {
        long nBases = 0L;
        long nRegBases = 0L;

        protected FastaStats() {
        }
    }
}

