/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.fasta;

import java.io.PrintStream;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RefWalker;
import org.broadinstitute.sting.gatk.walkers.WalkerName;
import org.broadinstitute.sting.gatk.walkers.fasta.FastaSequence;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.collections.Pair;

@WalkerName(value="FastaReferenceMaker")
public class FastaReferenceWalker
extends RefWalker<Pair<GenomeLoc, String>, GenomeLoc> {
    @Output
    PrintStream out;
    @Argument(fullName="lineWidth", shortName="lw", doc="Maximum length of sequence to write per line", required=false)
    public int fastaLineWidth = 60;
    @Argument(fullName="rawOnelineSeq", shortName="raw", doc="Print sequences with no FASTA header lines, one line per interval (i.e. lineWidth = infinity)", required=false)
    public boolean fastaRawSeqs = false;
    protected FastaSequence fasta;

    @Override
    public void initialize() {
        if (this.fastaRawSeqs) {
            this.fastaLineWidth = Integer.MAX_VALUE;
        }
        this.fasta = new FastaSequence(this.out, this.fastaLineWidth, this.fastaRawSeqs);
    }

    @Override
    public Pair<GenomeLoc, String> map(RefMetaDataTracker rodData, ReferenceContext ref, AlignmentContext context) {
        return new Pair((Object)context.getLocation(), (Object)String.valueOf((char)ref.getBase()));
    }

    @Override
    public GenomeLoc reduceInit() {
        return null;
    }

    @Override
    public GenomeLoc reduce(Pair<GenomeLoc, String> value, GenomeLoc sum) {
        if (value == null) {
            return sum;
        }
        if (sum == null) {
            sum = (GenomeLoc)value.first;
            this.fasta.append((String)value.second);
        } else if (((GenomeLoc)value.first).getStart() != sum.getStop() + 1) {
            this.fasta.flush();
            sum = (GenomeLoc)value.first;
            this.fasta.append((String)value.second);
        } else {
            sum = this.getToolkit().getGenomeLocParser().setStop(sum, ((GenomeLoc)value.first).getStop());
            this.fasta.append((String)value.second);
        }
        return sum;
    }

    @Override
    public void onTraversalDone(GenomeLoc sum) {
        this.fasta.flush();
    }
}

