/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.util.HashSet;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.CallableStatus;

public class LocusStatistics {
    final int coverage;
    final int rawCoverage;

    public LocusStatistics() {
        this.coverage = 0;
        this.rawCoverage = 0;
    }

    public LocusStatistics(int coverage, int rawCoverage) {
        this.coverage = coverage;
        this.rawCoverage = rawCoverage;
    }

    public int getCoverage() {
        return this.coverage;
    }

    public int getRawCoverage() {
        return this.rawCoverage;
    }

    public Set<CallableStatus> callableStatuses(int minimumCoverageThreshold, int maximumCoverageThreshold) {
        HashSet<CallableStatus> output = new HashSet<CallableStatus>();
        if (this.getCoverage() > maximumCoverageThreshold) {
            output.add(CallableStatus.EXCESSIVE_COVERAGE);
        }
        if (this.getCoverage() < minimumCoverageThreshold) {
            if (this.getRawCoverage() >= minimumCoverageThreshold) {
                output.add(CallableStatus.POOR_QUALITY);
            } else if (this.getRawCoverage() > 0) {
                output.add(CallableStatus.LOW_COVERAGE);
            } else {
                output.add(CallableStatus.NO_COVERAGE);
            }
        }
        return output;
    }
}

