/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.util.Random;
import org.broadinstitute.sting.gatk.walkers.bqsr.Datum;
import org.broadinstitute.sting.utils.MathUtils;

public class RecalDatum
extends Datum {
    private double estimatedQReported;
    private double empiricalQuality;

    public RecalDatum() {
        this.numObservations = 0L;
        this.numMismatches = 0L;
        this.estimatedQReported = 0.0;
        this.empiricalQuality = -1.0;
    }

    public RecalDatum(long _numObservations, long _numMismatches, double _estimatedQReported, double _empiricalQuality) {
        this.numObservations = _numObservations;
        this.numMismatches = _numMismatches;
        this.estimatedQReported = _estimatedQReported;
        this.empiricalQuality = _empiricalQuality;
    }

    public RecalDatum(RecalDatum copy) {
        this.numObservations = copy.numObservations;
        this.numMismatches = copy.numMismatches;
        this.estimatedQReported = copy.estimatedQReported;
        this.empiricalQuality = copy.empiricalQuality;
    }

    public void combine(RecalDatum other) {
        double sumErrors = this.calcExpectedErrors() + other.calcExpectedErrors();
        this.increment(other.numObservations, other.numMismatches);
        this.estimatedQReported = -10.0 * Math.log10(sumErrors / (double)this.numObservations);
        this.empiricalQuality = -1.0;
    }

    public final void calcCombinedEmpiricalQuality() {
        this.empiricalQuality = this.empiricalQualDouble();
    }

    public final void calcEstimatedReportedQuality() {
        this.estimatedQReported = -10.0 * Math.log10(this.calcExpectedErrors() / (double)this.numObservations);
    }

    public final double getEstimatedQReported() {
        return this.estimatedQReported;
    }

    public final double getEmpiricalQuality() {
        if (this.empiricalQuality < 0.0) {
            this.calcCombinedEmpiricalQuality();
        }
        return this.empiricalQuality;
    }

    public RecalDatum copy() {
        return new RecalDatum(this.numObservations, this.numMismatches, this.estimatedQReported, this.empiricalQuality);
    }

    @Override
    public String toString() {
        return String.format("%d,%d,%d", this.numObservations, this.numMismatches, (byte)Math.floor(this.getEmpiricalQuality()));
    }

    public String stringForCSV() {
        return String.format("%s,%d,%.2f", this.toString(), (byte)Math.floor(this.getEstimatedQReported()), this.getEmpiricalQuality() - this.getEstimatedQReported());
    }

    private double calcExpectedErrors() {
        return (double)this.numObservations * this.qualToErrorProb(this.estimatedQReported);
    }

    private double qualToErrorProb(double qual) {
        return Math.pow(10.0, qual / -10.0);
    }

    public static RecalDatum createRandomRecalDatum(int maxObservations, int maxErrors) {
        Random random = new Random();
        int nObservations = random.nextInt(maxObservations);
        int nErrors = random.nextInt(maxErrors);
        Datum datum = new Datum(nObservations, nErrors);
        double empiricalQuality = datum.empiricalQualDouble();
        double estimatedQReported = empiricalQuality + (10.0 * random.nextDouble() - 5.0);
        return new RecalDatum(nObservations, nErrors, estimatedQReported, empiricalQuality);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RecalDatum)) {
            return false;
        }
        RecalDatum other = (RecalDatum)o;
        return super.equals(o) && MathUtils.compareDoubles((double)this.empiricalQuality, (double)other.empiricalQuality, (double)0.001) == 0;
    }
}

