/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.beagle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.beagle.BeagleFeature;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class BeagleOutputToVCFWalker
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Input(fullName="comp", shortName="comp", doc="Comparison VCF file", required=false)
    public RodBinding<VariantContext> comp;
    @Input(fullName="beagleR2", shortName="beagleR2", doc="Beagle-produced .r2 file containing R^2 values for all markers", required=true)
    public RodBinding<BeagleFeature> beagleR2;
    @Input(fullName="beagleProbs", shortName="beagleProbs", doc="Beagle-produced .probs file containing posterior genotype probabilities", required=true)
    public RodBinding<BeagleFeature> beagleProbs;
    @Input(fullName="beaglePhased", shortName="beaglePhased", doc="Beagle-produced .phased file containing phased genotypes", required=true)
    public RodBinding<BeagleFeature> beaglePhased;
    @Output(doc="VCF File to which variants should be written", required=true)
    protected VCFWriter vcfWriter = null;
    @Argument(fullName="dont_mark_monomorphic_sites_as_filtered", shortName="keep_monomorphic", doc="If provided, we won't filter sites that beagle tags as monomorphic.  Useful for imputing a sample's genotypes from a reference panel", required=false)
    public boolean DONT_FILTER_MONOMORPHIC_SITES = false;
    @Argument(fullName="nocall_threshold", shortName="ncthr", doc="Threshold of confidence at which a genotype won't be called", required=false)
    private double noCallThreshold = 0.0;
    protected static String line = null;
    private final double MIN_PROB_ERROR = 1.0E-6;
    private final double MAX_GENOTYPE_QUALITY = -6.0;

    @Override
    public void initialize() {
        HashSet<Object> hInfo = new HashSet<Object>();
        hInfo.addAll(VCFUtils.getHeaderFields((GenomeAnalysisEngine)this.getToolkit()));
        hInfo.add(new VCFFormatHeaderLine("OG", 1, VCFHeaderLineType.String, "Original Genotype input to Beagle"));
        hInfo.add(new VCFInfoHeaderLine("R2", 1, VCFHeaderLineType.Float, "r2 Value reported by Beagle on each site"));
        hInfo.add(new VCFInfoHeaderLine("NumGenotypesChanged", 1, VCFHeaderLineType.Integer, "The number of genotypes changed by Beagle"));
        hInfo.add(new VCFFilterHeaderLine("BGL_RM_WAS_A", "This 'A' site was set to monomorphic by Beagle"));
        hInfo.add(new VCFFilterHeaderLine("BGL_RM_WAS_C", "This 'C' site was set to monomorphic by Beagle"));
        hInfo.add(new VCFFilterHeaderLine("BGL_RM_WAS_G", "This 'G' site was set to monomorphic by Beagle"));
        hInfo.add(new VCFFilterHeaderLine("BGL_RM_WAS_T", "This 'T' site was set to monomorphic by Beagle"));
        List<ReferenceOrderedDataSource> dataSources = this.getToolkit().getRodDataSources();
        if (this.comp.isBound()) {
            hInfo.add(new VCFInfoHeaderLine("ACH", 1, VCFHeaderLineType.Integer, "Allele Count from Comparison ROD at this site"));
            hInfo.add(new VCFInfoHeaderLine("ANH", 1, VCFHeaderLineType.Integer, "Allele Frequency from Comparison ROD at this site"));
            hInfo.add(new VCFInfoHeaderLine("AFH", 1, VCFHeaderLineType.Float, "Allele Number from Comparison ROD at this site"));
        }
        Set samples = SampleUtils.getSampleListWithVCFHeader((GenomeAnalysisEngine)this.getToolkit(), Arrays.asList(this.variantCollection.variants.getName()));
        VCFHeader vcfHeader = new VCFHeader(hInfo, samples);
        this.vcfWriter.writeHeader(vcfHeader);
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        GenomeLoc loc = context.getLocation();
        VariantContext vc_input = tracker.getFirstValue(this.variantCollection.variants, loc);
        VariantContext vc_comp = tracker.getFirstValue(this.comp, loc);
        if (vc_input == null) {
            return 0;
        }
        if (vc_input.isFiltered()) {
            this.vcfWriter.add(vc_input);
            return 1;
        }
        BeagleFeature beagleR2Feature = tracker.getFirstValue(this.beagleR2);
        BeagleFeature beagleProbsFeature = tracker.getFirstValue(this.beagleProbs);
        BeagleFeature beaglePhasedFeature = tracker.getFirstValue(this.beaglePhased);
        if (beagleR2Feature == null || beagleProbsFeature == null || beaglePhasedFeature == null) {
            this.vcfWriter.add(vc_input);
            return 1;
        }
        byte refByte = ref.getBase();
        GenotypesContext genotypes = GenotypesContext.create((int)vc_input.getGenotypes().size());
        int numGenotypesChangedByBeagle = 0;
        Integer alleleCountH = 0;
        Integer chrCountH = 0;
        Double alleleFrequencyH = 0.0;
        int beagleVarCounts = 0;
        GenotypesContext hapmapGenotypes = null;
        if (vc_comp != null) {
            hapmapGenotypes = vc_comp.getGenotypes();
        }
        for (Genotype g : vc_input.getGenotypes()) {
            Genotype hapmapGenotype;
            LinkedHashSet filters = new LinkedHashSet(g.getFilters());
            boolean genotypeIsPhased = true;
            String sample = g.getSampleName();
            if (vc_comp != null && vc_input.getGenotypes().containsSample(sample) && hapmapGenotypes.containsSample(sample) && (hapmapGenotype = hapmapGenotypes.get(sample)).isCalled()) {
                chrCountH = chrCountH + 2;
                if (hapmapGenotype.isHet()) {
                    alleleCountH = alleleCountH + 1;
                } else if (hapmapGenotype.isHomVar()) {
                    alleleCountH = alleleCountH + 2;
                }
            }
            ArrayList beagleProbabilities = (ArrayList)beagleProbsFeature.getProbLikelihoods().get(sample);
            ArrayList beagleGenotypePairs = (ArrayList)beaglePhasedFeature.getGenotypes().get(sample);
            Allele originalAlleleA = g.getAllele(0);
            Allele originalAlleleB = g.getAlleles().size() == 2 ? g.getAllele(1) : g.getAllele(0);
            ArrayList<Allele> alleles = new ArrayList<Allele>();
            String alleleA = (String)beagleGenotypePairs.get(0);
            String alleleB = (String)beagleGenotypePairs.get(1);
            if (alleleA.equals("null") || alleleB.equals("null")) {
                logger.warn((Object)("Beagle produced 'null' alleles at location " + ref.getLocus().toString() + ". Ignoring."));
                return 0;
            }
            String refString = vc_input.getReference().getDisplayString();
            if (refString.length() == 0) {
                refString = "-";
            }
            Allele bglAlleleA = alleleA.matches(refString) ? Allele.create((String)alleleA, (boolean)true) : Allele.create((String)alleleA, (boolean)false);
            Allele bglAlleleB = alleleB.matches(refString) ? Allele.create((String)alleleB, (boolean)true) : Allele.create((String)alleleB, (boolean)false);
            alleles.add(bglAlleleA);
            alleles.add(bglAlleleB);
            Double homRefProbability = Double.valueOf((String)beagleProbabilities.get(0));
            Double hetProbability = Double.valueOf((String)beagleProbabilities.get(1));
            Double homVarProbability = Double.valueOf((String)beagleProbabilities.get(2));
            Double probWrongGenotype = bglAlleleA.isReference() && bglAlleleB.isReference() ? Double.valueOf(hetProbability + homVarProbability) : (bglAlleleB.isReference() && bglAlleleA.isNonReference() || bglAlleleA.isReference() && bglAlleleB.isNonReference() ? Double.valueOf(homRefProbability + homVarProbability) : Double.valueOf(hetProbability + homRefProbability));
            if (probWrongGenotype > 0.999999) {
                probWrongGenotype = 0.999999;
            }
            if (1.0 - probWrongGenotype < this.noCallThreshold) {
                alleles.clear();
                alleles.add(originalAlleleA);
                alleles.add(originalAlleleB);
                genotypeIsPhased = false;
            }
            Double genotypeQuality = probWrongGenotype < 1.0E-6 ? Double.valueOf(-6.0) : Double.valueOf(Math.log10(probWrongGenotype));
            HashMap<String, String> originalAttributes = new HashMap<String, String>(g.getAttributes());
            String a1 = originalAlleleA.isNoCall() ? "." : (originalAlleleA.isReference() ? "0" : "1");
            String a2 = originalAlleleB.isNoCall() ? "." : (originalAlleleB.isReference() ? "0" : "1");
            String og = a1 + "/" + a2;
            if (!originalAlleleA.equals((Object)Allele.NO_CALL) && this.beagleSwitchedGenotypes(bglAlleleA, originalAlleleA, bglAlleleB, originalAlleleB)) {
                originalAttributes.put("OG", og);
                ++numGenotypesChangedByBeagle;
            } else {
                originalAttributes.put("OG", ".");
            }
            Genotype imputedGenotype = new Genotype(g.getSampleName(), alleles, genotypeQuality.doubleValue(), filters, originalAttributes, genotypeIsPhased);
            if (imputedGenotype.isHet() || imputedGenotype.isHomVar()) {
                ++beagleVarCounts;
            }
            genotypes.add(imputedGenotype);
        }
        VariantContextBuilder builder = new VariantContextBuilder(vc_input).source("outputvcf").genotypes(genotypes);
        if (beagleVarCounts <= 0 && !this.DONT_FILTER_MONOMORPHIC_SITES) {
            HashSet<String> removedFilters = vc_input.filtersWereApplied() ? new HashSet<String>(vc_input.getFilters()) : new HashSet(1);
            removedFilters.add(String.format("BGL_RM_WAS_%s", vc_input.getAlternateAllele(0)));
            builder.alleles(new HashSet<Allele>(Arrays.asList(vc_input.getReference()))).filters(removedFilters);
        }
        VariantContextUtils.calculateChromosomeCounts((VariantContextBuilder)builder, (boolean)false);
        if (vc_comp != null) {
            builder.attribute("ACH", (Object)alleleCountH.toString());
            builder.attribute("ANH", (Object)chrCountH.toString());
            builder.attribute("AFH", (Object)String.format("%4.2f", (double)alleleCountH.intValue() / (double)chrCountH.intValue()));
        }
        builder.attribute("NumGenotypesChanged", (Object)numGenotypesChangedByBeagle);
        if (!beagleR2Feature.getR2value().equals(Double.NaN)) {
            builder.attribute("R2", (Object)beagleR2Feature.getR2value().toString());
        }
        this.vcfWriter.add(builder.make());
        return 1;
    }

    private boolean beagleSwitchedGenotypes(Allele bglAlleleA, Allele originalAlleleA, Allele bglAlleleB, Allele originalAlleleB) {
        return !(bglAlleleA.equals((Object)originalAlleleA) && bglAlleleB.equals((Object)originalAlleleB) || bglAlleleA.equals((Object)originalAlleleB) && bglAlleleB.equals((Object)originalAlleleA));
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
        System.out.printf("Processed %d loci.\n", result);
    }
}

