/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.utils.MannWhitneyU;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public abstract class RankSumTest
extends InfoFieldAnnotation
implements StandardAnnotation,
ActiveRegionBasedAnnotation {
    static final double INDEL_LIKELIHOOD_THRESH = 0.1;
    static final boolean DEBUG = false;

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.size() == 0) {
            return null;
        }
        ArrayList<Double> refQuals = new ArrayList<Double>();
        ArrayList<Double> altQuals = new ArrayList<Double>();
        if (vc.isSNP()) {
            ArrayList<Byte> altAlleles = new ArrayList<Byte>();
            for (Allele a : vc.getAlternateAlleles()) {
                altAlleles.add(a.getBases()[0]);
            }
            for (Genotype genotype : genotypes.iterateInSampleNameOrder()) {
                AlignmentContext context = stratifiedContexts.get(genotype.getSampleName());
                if (context == null) continue;
                this.fillQualsFromPileup(ref.getBase(), altAlleles, context.getBasePileup(), refQuals, altQuals);
            }
        } else if (vc.isIndel() || vc.isMixed()) {
            for (Genotype genotype : genotypes.iterateInSampleNameOrder()) {
                ReadBackedPileup pileup;
                AlignmentContext context = stratifiedContexts.get(genotype.getSampleName());
                if (context == null || !context.hasBasePileup() || (pileup = context.getBasePileup()) == null) continue;
                if (IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap() == null || IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap().size() == 0) {
                    return null;
                }
                this.fillIndelQualsFromPileup(pileup, refQuals, altQuals);
            }
        } else {
            return null;
        }
        MannWhitneyU mannWhitneyU = new MannWhitneyU();
        for (Double qual : altQuals) {
            mannWhitneyU.add((Number)qual, MannWhitneyU.USet.SET1);
        }
        for (Double qual : refQuals) {
            mannWhitneyU.add((Number)qual, MannWhitneyU.USet.SET2);
        }
        Pair testResults = mannWhitneyU.runOneSidedTest(MannWhitneyU.USet.SET1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!Double.isNaN((Double)testResults.first)) {
            map.put(this.getKeyNames().get(0), String.format("%.3f", testResults.first));
        }
        return map;
    }

    @Override
    public Map<String, Object> annotate(Map<String, Map<Allele, List<GATKSAMRecord>>> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.size() == 0) {
            return null;
        }
        ArrayList<Double> refQuals = new ArrayList<Double>();
        ArrayList<Double> altQuals = new ArrayList<Double>();
        for (Genotype genotype : genotypes.iterateInSampleNameOrder()) {
            Map<Allele, List<GATKSAMRecord>> context = stratifiedContexts.get(genotype.getSampleName());
            if (context == null) continue;
            this.fillQualsFromPileup(vc.getReference(), vc.getAlternateAlleles(), vc.getStart(), context, refQuals, altQuals);
        }
        if (refQuals.size() == 0 || altQuals.size() == 0) {
            return null;
        }
        MannWhitneyU mannWhitneyU = new MannWhitneyU();
        for (Double qual : altQuals) {
            mannWhitneyU.add((Number)qual, MannWhitneyU.USet.SET1);
        }
        for (Double qual : refQuals) {
            mannWhitneyU.add((Number)qual, MannWhitneyU.USet.SET2);
        }
        Pair testResults = mannWhitneyU.runOneSidedTest(MannWhitneyU.USet.SET1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!Double.isNaN((Double)testResults.first)) {
            map.put(this.getKeyNames().get(0), String.format("%.3f", testResults.first));
        }
        return map;
    }

    protected abstract void fillQualsFromPileup(Allele var1, List<Allele> var2, int var3, Map<Allele, List<GATKSAMRecord>> var4, List<Double> var5, List<Double> var6);

    protected abstract void fillQualsFromPileup(byte var1, List<Byte> var2, ReadBackedPileup var3, List<Double> var4, List<Double> var5);

    protected abstract void fillIndelQualsFromPileup(ReadBackedPileup var1, List<Double> var2, List<Double> var3);

    protected static boolean isUsableBase(PileupElement p) {
        return !p.isInsertionAtBeginningOfRead() && !p.isDeletion() && p.getMappingQual() != 0 && p.getMappingQual() != 255 && p.getQual() >= 6;
    }
}

