/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import cern.jet.math.Arithmetic;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class FisherStrand
extends InfoFieldAnnotation
implements StandardAnnotation,
ActiveRegionBasedAnnotation {
    private static final String FS = "FS";
    private static final double MIN_PVALUE = 1.0E-320;

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        int[][] table;
        if (!vc.isVariant()) {
            return null;
        }
        if (vc.isSNP()) {
            table = FisherStrand.getSNPContingencyTable(stratifiedContexts, vc.getReference(), vc.getAltAlleleWithHighestAlleleCount());
        } else if (vc.isIndel() || vc.isMixed()) {
            table = FisherStrand.getIndelContingencyTable(stratifiedContexts);
            if (table == null) {
                return null;
            }
        } else {
            return null;
        }
        Double pvalue = Math.max(this.pValueForContingencyTable(table), 1.0E-320);
        if (pvalue == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FS, String.format("%.3f", QualityUtils.phredScaleErrorRate((double)pvalue)));
        return map;
    }

    @Override
    public Map<String, Object> annotate(Map<String, Map<Allele, List<GATKSAMRecord>>> stratifiedContexts, VariantContext vc) {
        if (!vc.isVariant()) {
            return null;
        }
        int[][] table = FisherStrand.getContingencyTable(stratifiedContexts, vc.getReference(), vc.getAltAlleleWithHighestAlleleCount());
        Double pvalue = Math.max(this.pValueForContingencyTable(table), 1.0E-320);
        if (pvalue == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FS, String.format("%.3f", QualityUtils.phredScaleErrorRate((double)pvalue)));
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList(FS);
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(FS, 1, VCFHeaderLineType.Float, "Phred-scaled p-value using Fisher's exact test to detect strand bias"));
    }

    private Double pValueForContingencyTable(int[][] originalTable) {
        double pValuePiece;
        double pCutoff;
        int[][] table = FisherStrand.copyContingencyTable(originalTable);
        double pValue = pCutoff = FisherStrand.computePValue(table);
        while (FisherStrand.rotateTable(table)) {
            pValuePiece = FisherStrand.computePValue(table);
            if (!(pValuePiece <= pCutoff)) continue;
            pValue += pValuePiece;
        }
        table = FisherStrand.copyContingencyTable(originalTable);
        while (FisherStrand.unrotateTable(table)) {
            pValuePiece = FisherStrand.computePValue(table);
            if (!(pValuePiece <= pCutoff)) continue;
            pValue += pValuePiece;
        }
        return pValue;
    }

    private static int[][] copyContingencyTable(int[][] t) {
        int[][] c = new int[2][2];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                c[i][j] = t[i][j];
            }
        }
        return c;
    }

    private static void printTable(int[][] table, double pValue) {
        System.out.printf("%d %d; %d %d : %f\n", table[0][0], table[0][1], table[1][0], table[1][1], pValue);
    }

    private static boolean rotateTable(int[][] table) {
        int[] nArray = table[0];
        nArray[0] = nArray[0] - 1;
        int[] nArray2 = table[1];
        nArray2[0] = nArray2[0] + 1;
        int[] nArray3 = table[0];
        nArray3[1] = nArray3[1] + 1;
        int[] nArray4 = table[1];
        nArray4[1] = nArray4[1] - 1;
        return table[0][0] >= 0 && table[1][1] >= 0;
    }

    private static boolean unrotateTable(int[][] table) {
        int[] nArray = table[0];
        nArray[0] = nArray[0] + 1;
        int[] nArray2 = table[1];
        nArray2[0] = nArray2[0] - 1;
        int[] nArray3 = table[0];
        nArray3[1] = nArray3[1] - 1;
        int[] nArray4 = table[1];
        nArray4[1] = nArray4[1] + 1;
        return table[0][1] >= 0 && table[1][0] >= 0;
    }

    private static double computePValue(int[][] table) {
        int[] rowSums = new int[]{FisherStrand.sumRow(table, 0), FisherStrand.sumRow(table, 1)};
        int[] colSums = new int[]{FisherStrand.sumColumn(table, 0), FisherStrand.sumColumn(table, 1)};
        int N = rowSums[0] + rowSums[1];
        double pCutoff = Arithmetic.logFactorial((int)rowSums[0]) + Arithmetic.logFactorial((int)rowSums[1]) + Arithmetic.logFactorial((int)colSums[0]) + Arithmetic.logFactorial((int)colSums[1]) - Arithmetic.logFactorial((int)table[0][0]) - Arithmetic.logFactorial((int)table[0][1]) - Arithmetic.logFactorial((int)table[1][0]) - Arithmetic.logFactorial((int)table[1][1]) - Arithmetic.logFactorial((int)N);
        return Math.exp(pCutoff);
    }

    private static int sumRow(int[][] table, int column) {
        int sum = 0;
        for (int r = 0; r < table.length; ++r) {
            sum += table[r][column];
        }
        return sum;
    }

    private static int sumColumn(int[][] table, int row) {
        int sum = 0;
        for (int c = 0; c < table[row].length; ++c) {
            sum += table[row][c];
        }
        return sum;
    }

    private static int[][] getContingencyTable(Map<String, Map<Allele, List<GATKSAMRecord>>> stratifiedContexts, Allele ref, Allele alt) {
        int[][] table = new int[2][2];
        for (Map<Allele, List<GATKSAMRecord>> alleleBins : stratifiedContexts.values()) {
            for (Map.Entry<Allele, List<GATKSAMRecord>> alleleBin : alleleBins.entrySet()) {
                boolean matchesRef = ref.equals((Object)alleleBin.getKey());
                boolean matchesAlt = alt.equals((Object)alleleBin.getKey());
                if (!matchesRef && !matchesAlt) continue;
                for (GATKSAMRecord read : alleleBin.getValue()) {
                    boolean isFW = read.getReadNegativeStrandFlag();
                    int row = matchesRef ? 0 : 1;
                    int column = isFW ? 0 : 1;
                    int[] nArray = table[row];
                    int n = column;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        return table;
    }

    private static int[][] getSNPContingencyTable(Map<String, AlignmentContext> stratifiedContexts, Allele ref, Allele alt) {
        int[][] table = new int[2][2];
        for (Map.Entry<String, AlignmentContext> sample : stratifiedContexts.entrySet()) {
            for (PileupElement p : sample.getValue().getBasePileup()) {
                if (p.isDeletion() || p.getRead().isReducedRead() || p.getRead().getMappingQuality() < 20 || p.getQual() < 20) continue;
                Allele base = Allele.create((byte)p.getBase(), (boolean)false);
                boolean isFW = !p.getRead().getReadNegativeStrandFlag();
                boolean matchesRef = ref.equals(base, true);
                boolean matchesAlt = alt.equals(base, true);
                if (!matchesRef && !matchesAlt) continue;
                int row = matchesRef ? 0 : 1;
                int column = isFW ? 0 : 1;
                int[] nArray = table[row];
                int n = column;
                nArray[n] = nArray[n] + 1;
            }
        }
        return table;
    }

    private static int[][] getIndelContingencyTable(Map<String, AlignmentContext> stratifiedContexts) {
        double INDEL_LIKELIHOOD_THRESH = 0.3;
        HashMap<PileupElement, LinkedHashMap<Allele, Double>> indelLikelihoodMap = IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap();
        if (indelLikelihoodMap == null) {
            return null;
        }
        int[][] table = new int[2][2];
        for (String sample : stratifiedContexts.keySet()) {
            AlignmentContext context = stratifiedContexts.get(sample);
            if (context == null || !context.hasBasePileup()) continue;
            ReadBackedPileup pileup = context.getBasePileup();
            for (PileupElement p : pileup) {
                boolean matchesAlt;
                if (p.getRead().isReducedRead() || p.getRead().getMappingQuality() < 20 || !indelLikelihoodMap.containsKey(p)) continue;
                LinkedHashMap<Allele, Double> el = indelLikelihoodMap.get(p);
                boolean isFW = !p.getRead().getReadNegativeStrandFlag();
                double refLikelihood = 0.0;
                double altLikelihood = Double.NEGATIVE_INFINITY;
                for (Allele a : el.keySet()) {
                    if (a.isReference()) {
                        refLikelihood = el.get(a);
                        continue;
                    }
                    double like = el.get(a);
                    if (!(like >= altLikelihood)) continue;
                    altLikelihood = like;
                }
                boolean matchesRef = refLikelihood > altLikelihood + 0.3;
                boolean bl = matchesAlt = altLikelihood > refLikelihood + 0.3;
                if (!matchesRef && !matchesAlt) continue;
                int row = matchesRef ? 0 : 1;
                int column = isFW ? 0 : 1;
                int[] nArray = table[row];
                int n = column;
                nArray[n] = nArray[n] + 1;
            }
        }
        return table;
    }
}

