/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

public class PileupWalker
extends LocusWalker<Integer, Integer>
implements TreeReducible<Integer> {
    @Output
    PrintStream out;
    @Argument(fullName="showVerbose", shortName="verbose", doc="Add an extra verbose section to the pileup output")
    public boolean SHOW_VERBOSE = false;
    @Input(fullName="metadata", shortName="metadata", doc="Add these ROD bindings to the output Pileup", required=false)
    public List<RodBinding<Feature>> rods = Collections.emptyList();
    private static final String verboseDelimiter = "@";

    @Override
    public void initialize() {
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        String rods = this.getReferenceOrderedData(tracker);
        if (context.hasBasePileup()) {
            ReadBackedPileup basePileup = context.getBasePileup();
            this.out.printf("%s %s", basePileup.getPileupString(Character.valueOf((char)ref.getBase())), rods);
            if (this.SHOW_VERBOSE) {
                this.out.printf(" %s", PileupWalker.createVerboseOutput(basePileup));
            }
            this.out.println();
        }
        return 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return this.treeReduce(sum, value);
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return lhs + rhs;
    }

    private String getReferenceOrderedData(RefMetaDataTracker tracker) {
        ArrayList<String> rodStrings = new ArrayList<String>();
        for (Feature datum : tracker.getValues(this.rods)) {
            rodStrings.add(datum.toString());
        }
        String rodString = Utils.join((String)", ", rodStrings);
        if (!rodString.equals("")) {
            rodString = "[ROD: " + rodString + "]";
        }
        return rodString;
    }

    private static String createVerboseOutput(ReadBackedPileup pileup) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append(pileup.getNumberOfDeletions());
        sb.append(" ");
        for (PileupElement p : pileup) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(p.getRead().getReadName());
            sb.append(verboseDelimiter);
            sb.append(p.getOffset());
            sb.append(verboseDelimiter);
            sb.append(p.getRead().getReadLength());
            sb.append(verboseDelimiter);
            sb.append(p.getRead().getMappingQuality());
        }
        return sb.toString();
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.out.println("[REDUCE RESULT] Traversal result is: " + result);
    }
}

