/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.samples;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.samples.PedReader;
import org.broadinstitute.sting.gatk.samples.PedigreeValidationType;
import org.broadinstitute.sting.gatk.samples.Sample;
import org.broadinstitute.sting.gatk.samples.SampleDB;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class SampleDBBuilder {
    PedigreeValidationType validationStrictness;
    final SampleDB sampleDB = new SampleDB();
    final GenomeAnalysisEngine engine;
    Set<Sample> samplesFromDataSources = new HashSet<Sample>();
    Set<Sample> samplesFromPedigrees = new HashSet<Sample>();

    protected SampleDBBuilder(PedigreeValidationType validationStrictness) {
        this.engine = null;
        this.validationStrictness = validationStrictness;
    }

    public SampleDBBuilder(GenomeAnalysisEngine engine, PedigreeValidationType validationStrictness) {
        this.engine = engine;
        this.validationStrictness = validationStrictness;
    }

    public SampleDBBuilder addSamplesFromSAMHeader(SAMFileHeader header) {
        this.addSamplesFromSampleNames(SampleUtils.getSAMFileSamples((SAMFileHeader)header));
        return this;
    }

    public SampleDBBuilder addSamplesFromSampleNames(Collection<String> sampleNames) {
        for (String sampleName : sampleNames) {
            if (this.sampleDB.getSample(sampleName) != null) continue;
            Sample newSample = new Sample(sampleName, this.sampleDB);
            this.sampleDB.addSample(newSample);
            this.samplesFromDataSources.add(newSample);
        }
        return this;
    }

    public SampleDBBuilder addSamplesFromPedigreeFiles(List<File> pedigreeFiles) {
        for (File pedFile : pedigreeFiles) {
            Collection<Sample> samples = this.addSamplesFromPedigreeArgument(pedFile);
            this.samplesFromPedigrees.addAll(samples);
        }
        return this;
    }

    public SampleDBBuilder addSamplesFromPedigreeStrings(List<String> pedigreeStrings) {
        for (String pedString : pedigreeStrings) {
            Collection<Sample> samples = this.addSamplesFromPedigreeArgument(pedString);
            this.samplesFromPedigrees.addAll(samples);
        }
        return this;
    }

    private Collection<Sample> addSamplesFromPedigreeArgument(File sampleFile) {
        PedReader reader = new PedReader();
        try {
            return reader.parse(sampleFile, this.getMissingFields(sampleFile), this.sampleDB);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(sampleFile, (Exception)e);
        }
    }

    private Collection<Sample> addSamplesFromPedigreeArgument(String string) {
        PedReader reader = new PedReader();
        return reader.parse(string, this.getMissingFields(string), this.sampleDB);
    }

    public SampleDB getFinalSampleDB() {
        this.validate();
        return this.sampleDB;
    }

    public EnumSet<PedReader.MissingPedField> getMissingFields(Object engineArg) {
        if (this.engine == null) {
            return EnumSet.noneOf(PedReader.MissingPedField.class);
        }
        List posTags = this.engine.getTags(engineArg).getPositionalTags();
        return PedReader.parseMissingFieldTags(engineArg, posTags);
    }

    protected final void validate() {
        if (this.validationStrictness == PedigreeValidationType.SILENT) {
            return;
        }
        if (!this.samplesFromPedigrees.isEmpty() && !this.samplesFromDataSources.isEmpty()) {
            HashSet<String> sampleNamesFromPedigrees = new HashSet<String>();
            for (Sample pSample : this.samplesFromPedigrees) {
                sampleNamesFromPedigrees.add(pSample.getID());
            }
            for (Sample dsSample : this.samplesFromDataSources) {
                if (sampleNamesFromPedigrees.contains(dsSample.getID())) continue;
                throw new UserException("Sample " + dsSample.getID() + " found in data sources but not in pedigree files with STRICT pedigree validation");
            }
        }
    }
}

