/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.filters.ReadFilter;

public class MaxInsertSizeFilter
extends ReadFilter {
    @Argument(fullName="maxInsertSize", shortName="maxInsert", doc="Discard reads with insert size greater than the specified value, defaults to 1000000", required=false)
    private int maxInsertSize = 1000000;

    public boolean filterOut(SAMRecord record) {
        return record.getReadPairedFlag() && (record.getInferredInsertSize() > this.maxInsertSize || record.getInferredInsertSize() < -1 * this.maxInsertSize);
    }
}

