/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.executive;

import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.executive.HierarchicalMicroScheduler;
import org.broadinstitute.sting.gatk.executive.OutputMergeTask;
import org.broadinstitute.sting.gatk.executive.WindowMaker;
import org.broadinstitute.sting.gatk.io.ThreadLocalOutputTracker;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ShardTraverser
implements Callable {
    private final HierarchicalMicroScheduler microScheduler;
    private final Walker walker;
    private final Shard shard;
    private final TraversalEngine traversalEngine;
    private final ThreadLocalOutputTracker outputTracker;
    private OutputMergeTask outputMergeTask;
    protected static final Logger logger = Logger.getLogger(ShardTraverser.class);
    private boolean complete = false;

    public ShardTraverser(HierarchicalMicroScheduler microScheduler, TraversalEngine traversalEngine, Walker walker, Shard shard, ThreadLocalOutputTracker outputTracker) {
        this.microScheduler = microScheduler;
        this.walker = walker;
        this.traversalEngine = traversalEngine;
        this.shard = shard;
        this.outputTracker = outputTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() {
        try {
            this.traversalEngine.startTimersIfNecessary();
            long startTime = System.currentTimeMillis();
            Object accumulator = this.walker.reduceInit();
            WindowMaker windowMaker = new WindowMaker(this.shard, this.microScheduler.getEngine().getGenomeLocParser(), this.microScheduler.getReadIterator(this.shard), this.shard.getGenomeLocs(), this.microScheduler.engine.getSampleDB().getSampleNames());
            for (WindowMaker.WindowMakerIterator iterator : windowMaker) {
                LocusShardDataProvider dataProvider = new LocusShardDataProvider(this.shard, iterator.getSourceInfo(), this.microScheduler.getEngine().getGenomeLocParser(), iterator.getLocus(), iterator, this.microScheduler.reference, this.microScheduler.rods);
                accumulator = this.traversalEngine.traverse(this.walker, dataProvider, accumulator);
                ((ShardDataProvider)dataProvider).close();
            }
            windowMaker.close();
            this.outputMergeTask = this.outputTracker.closeStorage();
            long endTime = System.currentTimeMillis();
            this.microScheduler.reportShardTraverseTime(endTime - startTime);
            Object ReduceType = accumulator;
            return ReduceType;
        }
        finally {
            ShardTraverser shardTraverser = this;
            synchronized (shardTraverser) {
                this.complete = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        ShardTraverser shardTraverser = this;
        synchronized (shardTraverser) {
            return this.complete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForComplete() {
        try {
            ShardTraverser shardTraverser = this;
            synchronized (shardTraverser) {
                if (this.isComplete()) {
                    return;
                }
                this.wait();
            }
        }
        catch (InterruptedException ex) {
            throw new ReviewedStingException("Interrupted while waiting for more output to be finalized.", (Throwable)ex);
        }
    }

    public OutputMergeTask getOutputMergeTask() {
        return this.outputMergeTask;
    }
}

