/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reference;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.picard.reference.FastaSequenceIndex;
import net.sf.picard.reference.FastaSequenceIndexBuilder;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.sam.CreateSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.datasources.reads.LocusShard;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.fasta.CachingIndexedFastaSequenceFile;

public class ReferenceDataSource {
    private IndexedFastaSequenceFile reference;
    protected static Logger logger = Logger.getLogger(ReferenceDataSource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceDataSource(File fastaFile) {
        if (!fastaFile.exists()) {
            throw new UserException("The fasta file you specified (" + fastaFile.getAbsolutePath() + ") does not exist.");
        }
        File indexFile = new File(fastaFile.getAbsolutePath() + ".fai");
        File dictFile = fastaFile.getAbsolutePath().endsWith("fa") ? new File(fastaFile.getAbsolutePath().replace(".fa", ".dict")) : new File(fastaFile.getAbsolutePath().replace(".fasta", ".dict"));
        if (!indexFile.exists()) {
            logger.info((Object)String.format("Index file %s does not exist. Trying to create it now.", indexFile.getAbsolutePath()));
            try {
                FastaSequenceIndexBuilder faiBuilder = new FastaSequenceIndexBuilder(fastaFile, true);
                FastaSequenceIndex sequenceIndex = faiBuilder.createIndex();
                FastaSequenceIndexBuilder.saveAsFaiFile((FastaSequenceIndex)sequenceIndex, (File)indexFile);
            }
            catch (UserException e) {
                throw e;
            }
            catch (Exception e) {
            }
        }
        if (!dictFile.exists()) {
            logger.info((Object)String.format("Dict file %s does not exist. Trying to create it now.", dictFile.getAbsolutePath()));
            try {
                File tempFile = File.createTempFile("dict", null, dictFile.getParentFile());
                tempFile.deleteOnExit();
                String[] args = new String[]{String.format("r=%s", fastaFile.getAbsolutePath()), String.format("o=%s", tempFile.getAbsolutePath())};
                new CreateSequenceDictionary().instanceMain(args);
                if (!tempFile.renameTo(dictFile)) {
                    throw new UserException("Error transferring temp file " + tempFile + " to dict file " + dictFile);
                }
            }
            catch (Exception e) {
                throw new UserException.CouldNotCreateReferenceIndexFile(dictFile, e);
            }
        }
        try {
            this.reference = new CachingIndexedFastaSequenceFile(fastaFile);
        }
        catch (IllegalArgumentException e) {
            throw new UserException.CouldNotReadInputFile(fastaFile, "Could not read reference sequence.  The FASTA must have either a .fasta or .fa extension", (Exception)e);
        }
        catch (Exception e) {
            throw new UserException.CouldNotReadInputFile(fastaFile, e);
        }
    }

    public IndexedFastaSequenceFile getReference() {
        return this.reference;
    }

    public Iterable<Shard> createShardsOverEntireReference(SAMDataSource readsDataSource, GenomeLocParser parser, int maxShardSize) {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        for (SAMSequenceRecord refSequenceRecord : this.reference.getSequenceDictionary().getSequences()) {
            for (int shardStart = 1; shardStart <= refSequenceRecord.getSequenceLength(); shardStart += maxShardSize) {
                int shardStop = Math.min(shardStart + maxShardSize - 1, refSequenceRecord.getSequenceLength());
                shards.add(new LocusShard(parser, readsDataSource, Collections.singletonList(parser.createGenomeLoc(refSequenceRecord.getSequenceName(), shardStart, shardStop)), null));
            }
        }
        return shards;
    }

    public Iterable<Shard> createShardsOverIntervals(SAMDataSource readsDataSource, GenomeLocSortedSet intervals, int maxShardSize) {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        for (GenomeLoc interval : intervals) {
            while (interval.size() > maxShardSize) {
                shards.add(new LocusShard(intervals.getGenomeLocParser(), readsDataSource, Collections.singletonList(intervals.getGenomeLocParser().createGenomeLoc(interval.getContig(), interval.getStart(), interval.getStart() + maxShardSize - 1)), null));
                interval = intervals.getGenomeLocParser().createGenomeLoc(interval.getContig(), interval.getStart() + maxShardSize, interval.getStop());
            }
            shards.add(new LocusShard(intervals.getGenomeLocParser(), readsDataSource, Collections.singletonList(interval), null));
        }
        return shards;
    }
}

