/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads.utilities;

import java.io.File;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;

public class BAMTagRenamer
extends CommandLineProgram {
    @Argument(fullName="input", shortName="I", doc="Input file to process", required=true)
    private File input = null;
    @Argument(fullName="output", shortName="O", doc="Output file to create", required=true)
    private File output = null;
    @Argument(fullName="bam_compression", shortName="compress", doc="Compression level to use when writing the BAM file.", required=false)
    private int compressionLevel = 5;
    @Argument(fullName="original_tag_name", shortName="otn", doc="Tag name to be replaced.", required=true)
    private String sourceTagName = null;
    @Argument(fullName="replacement_tag_name", shortName="rtn", doc="Tag name to be used as a replacement.", required=true)
    private String targetTagName = null;

    public int execute() {
        long readsWritten = 0L;
        long readsAltered = 0L;
        SAMFileReader reader = new SAMFileReader(this.input);
        SAMFileWriter writer = new SAMFileWriterFactory().makeBAMWriter(reader.getFileHeader(), true, this.output, this.compressionLevel);
        for (SAMRecord read : reader) {
            Object value = read.getAttribute(this.sourceTagName);
            if (value != null) {
                read.setAttribute(this.sourceTagName, null);
                read.setAttribute(this.targetTagName, value);
                ++readsAltered;
            }
            writer.addAlignment(read);
            if (++readsWritten % 1000000L != 0L) continue;
            System.out.printf("%d reads written.  %d tag names updated from %s to %s.%n", readsWritten, readsAltered, this.sourceTagName, this.targetTagName);
        }
        writer.close();
        System.out.printf("%d reads written.  %d tag names updated from %s to %s.%n", readsWritten, readsAltered, this.sourceTagName, this.targetTagName);
        return 0;
    }

    public static void main(String[] argv) {
        BAMTagRenamer instance = new BAMTagRenamer();
        try {
            BAMTagRenamer.start((CommandLineProgram)instance, (String[])argv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.exit(CommandLineProgram.result);
    }
}

