/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.Bin;
import net.sf.samtools.Chunk;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKBin;
import net.sf.samtools.GATKChunk;
import net.sf.samtools.LinearIndex;
import org.broadinstitute.sting.gatk.datasources.reads.GATKBAMIndex;

public class GATKBAMIndexData {
    private final GATKBAMIndex index;
    private final int referenceSequence;
    private final List<GATKBin> bins;
    private final LinearIndex linearIndex;

    public GATKBAMIndexData(GATKBAMIndex index, int referenceSequence, List<GATKBin> bins, LinearIndex linearIndex) {
        this.index = index;
        this.referenceSequence = referenceSequence;
        this.bins = bins;
        this.linearIndex = linearIndex;
    }

    public int getReferenceSequence() {
        return this.referenceSequence;
    }

    public GATKBAMFileSpan getSpanOverlapping(Bin bin) {
        if (bin == null) {
            return null;
        }
        GATKBin gatkBin = new GATKBin(bin);
        int binLevel = this.index.getLevelForBin(bin);
        int firstLocusInBin = this.index.getFirstLocusInBin(bin);
        ArrayList<GATKBin> binTree = new ArrayList<GATKBin>();
        if (gatkBin.getBinNumber() < this.bins.size() && this.bins.get(gatkBin.getBinNumber()) != null) {
            binTree.add(this.bins.get(gatkBin.getBinNumber()));
        }
        int currentBinLevel = binLevel;
        while (--currentBinLevel >= 0) {
            int binStart = GATKBAMIndex.getFirstBinInLevel(currentBinLevel);
            int binWidth = this.index.getMaxAddressibleGenomicLocation() / this.index.getLevelSize(currentBinLevel);
            int binNumber = firstLocusInBin / binWidth + binStart;
            if (binNumber >= this.bins.size() || this.bins.get(binNumber) == null) continue;
            binTree.add(this.bins.get(binNumber));
        }
        List<GATKChunk> chunkList = new ArrayList<GATKChunk>();
        for (GATKBin coveringBin : binTree) {
            for (GATKChunk chunk : coveringBin.getChunkList()) {
                chunkList.add(chunk.clone());
            }
        }
        int start = this.index.getFirstLocusInBin(bin);
        chunkList = this.optimizeChunkList(chunkList, this.linearIndex.getMinimumOffset(start));
        return new GATKBAMFileSpan(chunkList.toArray(new GATKChunk[chunkList.size()]));
    }

    private List<GATKChunk> optimizeChunkList(List<GATKChunk> chunks, long minimumOffset) {
        GATKChunk lastChunk = null;
        Collections.sort(chunks);
        ArrayList<GATKChunk> result = new ArrayList<GATKChunk>();
        for (GATKChunk chunk : chunks) {
            if (chunk.getChunkEnd() <= minimumOffset) continue;
            if (result.isEmpty()) {
                result.add(chunk);
                lastChunk = chunk;
                continue;
            }
            if (!lastChunk.overlaps((Chunk)chunk) && !lastChunk.isAdjacentTo((Chunk)chunk)) {
                result.add(chunk);
                lastChunk = chunk;
                continue;
            }
            if (chunk.getChunkEnd() <= lastChunk.getChunkEnd()) continue;
            lastChunk.setChunkEnd(chunk.getChunkEnd());
        }
        return result;
    }
}

