/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.Chunk;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKChunk;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broadinstitute.sting.gatk.datasources.reads.BAMAccessPlan;
import org.broadinstitute.sting.gatk.datasources.reads.BGZFBlockLoadingDispatcher;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BlockInputStream
extends InputStream {
    private final BGZFBlockLoadingDispatcher dispatcher;
    private final SAMReaderID reader;
    private final long length;
    private Throwable error;
    private BAMAccessPlan accessPlan;
    private final ByteBuffer buffer;
    private LinkedList<Integer> blockOffsets = new LinkedList();
    private LinkedList<Long> blockPositions = new LinkedList();
    private final Object lock = new Object();
    private final BlockCompressedInputStream validatingInputStream;

    BlockInputStream(BGZFBlockLoadingDispatcher dispatcher, SAMReaderID reader, boolean validate) {
        this.reader = reader;
        this.length = reader.samFile.length();
        this.buffer = ByteBuffer.wrap(new byte[65536]);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.limit(0);
        this.dispatcher = dispatcher;
        this.accessPlan = new BAMAccessPlan(reader, this, new GATKBAMFileSpan((Chunk)new GATKChunk(0L, Long.MAX_VALUE)));
        this.blockOffsets.add(0);
        this.blockPositions.add(0L);
        try {
            if (validate) {
                System.out.printf("BlockInputStream %s: BGZF block validation mode activated%n", this);
                this.validatingInputStream = new BlockCompressedInputStream(reader.samFile);
                this.validatingInputStream.available();
            } else {
                this.validatingInputStream = null;
            }
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to validate against Picard input stream", (Throwable)ex);
        }
    }

    public long length() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFilePointer() {
        long filePointer;
        Object object = this.lock;
        synchronized (object) {
            int blockIndex = 0;
            while (blockIndex + 1 < this.blockOffsets.size() && this.buffer.position() > this.blockOffsets.get(blockIndex + 1)) {
                ++blockIndex;
            }
            filePointer = this.blockPositions.get(blockIndex) + (long)(this.buffer.position() - this.blockOffsets.get(blockIndex));
        }
        return filePointer;
    }

    private void clearBuffers() {
        this.accessPlan.reset();
        this.buffer.clear();
        this.buffer.limit(0);
        this.blockOffsets.clear();
        this.blockOffsets.add(0);
        while (this.blockPositions.size() > 1) {
            this.blockPositions.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean eof() {
        Object object = this.lock;
        synchronized (object) {
            return this.accessPlan != null && (this.accessPlan.getBlockAddress() < 0L || this.accessPlan.getBlockAddress() >= this.length);
        }
    }

    public void submitAccessPlan(BAMAccessPlan accessPlan) {
        this.accessPlan = accessPlan;
        accessPlan.reset();
        this.clearBuffers();
        accessPlan.advancePosition(BlockInputStream.makeFilePointer(accessPlan.getBlockAddress(), 0));
        if (accessPlan.getBlockAddress() >= 0L) {
            this.waitForBufferFill();
        }
        if (this.validatingInputStream != null) {
            try {
                this.validatingInputStream.seek(BlockInputStream.makeFilePointer(accessPlan.getBlockAddress(), 0));
            }
            catch (IOException ex) {
                throw new ReviewedStingException("Unable to validate against Picard input stream", (Throwable)ex);
            }
        }
    }

    private void compactBuffer() {
        int bytesToRemove = 0;
        while (this.blockOffsets.size() > 1 && this.buffer.position() >= this.blockOffsets.get(1)) {
            this.blockOffsets.remove();
            this.blockPositions.remove();
            bytesToRemove = this.blockOffsets.peek();
        }
        if (this.buffer.remaining() == 0 && this.blockOffsets.size() > 1 && this.buffer.position() >= this.blockOffsets.peek()) {
            bytesToRemove += this.buffer.position();
            this.blockOffsets.remove();
            this.blockPositions.remove();
        }
        int finalBufferStart = this.buffer.position() - bytesToRemove;
        int finalBufferSize = this.buffer.remaining();
        this.buffer.position(bytesToRemove);
        this.buffer.compact();
        this.buffer.position(finalBufferStart);
        this.buffer.limit(finalBufferStart + finalBufferSize);
        for (int i = 0; i < this.blockOffsets.size(); ++i) {
            this.blockOffsets.set(i, this.blockOffsets.get(i) - bytesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyIntoBuffer(ByteBuffer incomingBuffer, BAMAccessPlan accessPlan, long filePosition) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.validatingInputStream != null) {
                    byte[] validBytes = new byte[incomingBuffer.remaining()];
                    byte[] currentBytes = new byte[incomingBuffer.remaining()];
                    int pos = incomingBuffer.position();
                    int lim = incomingBuffer.limit();
                    incomingBuffer.get(currentBytes);
                    incomingBuffer.limit(lim);
                    incomingBuffer.position(pos);
                    long currentFilePointer = this.validatingInputStream.getFilePointer();
                    this.validatingInputStream.seek(BlockInputStream.makeFilePointer(accessPlan.getBlockAddress(), 0));
                    this.validatingInputStream.read(validBytes);
                    this.validatingInputStream.seek(currentFilePointer);
                    if (!Arrays.equals(validBytes, currentBytes)) {
                        throw new ReviewedStingException(String.format("Bytes being inserted into BlockInputStream %s are incorrect", this));
                    }
                }
                this.compactBuffer();
                this.buffer.limit(this.buffer.capacity());
                List<GATKChunk> spansOverlapping = accessPlan.getSpansOverlappingBlock(accessPlan.getBlockAddress(), filePosition);
                this.accessPlan = accessPlan;
                accessPlan.advancePosition(BlockInputStream.makeFilePointer(filePosition, 0));
                if (this.buffer.remaining() < incomingBuffer.remaining()) {
                    this.lock.wait();
                }
                int bytesInIncomingBuffer = incomingBuffer.limit();
                for (GATKChunk spanOverlapping : spansOverlapping) {
                    this.blockOffsets.removeLast();
                    this.blockOffsets.add(this.buffer.position());
                    this.blockPositions.removeLast();
                    this.blockPositions.add(spanOverlapping.getChunkStart());
                    incomingBuffer.limit(spanOverlapping.getBlockEnd() > spanOverlapping.getBlockStart() ? bytesInIncomingBuffer : spanOverlapping.getBlockOffsetEnd());
                    incomingBuffer.position(spanOverlapping.getBlockOffsetStart());
                    this.buffer.put(incomingBuffer);
                    this.blockOffsets.add(this.buffer.position());
                    this.blockPositions.add(spanOverlapping.getChunkEnd());
                }
                this.buffer.flip();
                this.lock.notify();
            }
            catch (Exception ex) {
                this.reportException(ex);
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportException(Throwable t) {
        Object object = this.lock;
        synchronized (object) {
            this.error = t;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForErrors() {
        Object object = this.lock;
        synchronized (object) {
            if (this.error != null) {
                ReviewedStingException toThrow = new ReviewedStingException(String.format("Thread %s, BlockInputStream %s: Unable to retrieve BAM data from disk", Thread.currentThread().getId(), this), this.error);
                toThrow.setStackTrace(this.error.getStackTrace());
                throw toThrow;
            }
        }
    }

    @Override
    public int read() {
        byte[] singleByte = new byte[1];
        this.read(singleByte);
        return singleByte[0];
    }

    @Override
    public int read(byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] bytes, int offset, int length) {
        int remaining;
        Object object = this.lock;
        synchronized (object) {
            int numBytesToCopy;
            for (remaining = length; remaining > 0; remaining -= numBytesToCopy) {
                this.checkForErrors();
                this.waitForBufferFill();
                if (this.buffer.remaining() == 0) break;
                numBytesToCopy = Math.min(this.buffer.remaining(), remaining);
                this.buffer.get(bytes, length - remaining + offset, numBytesToCopy);
            }
            if (length - remaining > 0) {
                this.lock.notify();
            }
        }
        if (remaining < length) {
            return length - remaining;
        }
        return -1;
    }

    @Override
    public void close() {
        if (this.validatingInputStream != null) {
            try {
                this.validatingInputStream.close();
            }
            catch (IOException ex) {
                throw new ReviewedStingException("Unable to validate against Picard input stream", (Throwable)ex);
            }
        }
    }

    public String getSource() {
        return this.reader.getSamFilePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBufferFill() {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer.remaining() == 0 && !this.eof()) {
                this.dispatcher.queueBlockLoad(this.accessPlan);
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ex) {
                    throw new ReviewedStingException("Interrupt occurred waiting for buffer to fill", (Throwable)ex);
                }
            }
        }
    }

    public static long makeFilePointer(long blockAddress, int blockOffset) {
        return blockAddress << 16 | (long)blockOffset;
    }
}

