/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.Bin;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKChunk;
import net.sf.samtools.util.CloseableIterator;
import org.broadinstitute.sting.gatk.datasources.reads.BAMScheduleEntry;
import org.broadinstitute.sting.gatk.datasources.reads.GATKBAMIndex;
import org.broadinstitute.sting.gatk.datasources.reads.GATKBAMIndexData;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class BAMSchedule
implements CloseableIterator<BAMScheduleEntry> {
    private File scheduleFile;
    private FileChannel scheduleFileChannel;
    private final List<SAMReaderID> readerIDs = new ArrayList<SAMReaderID>();
    private final List<PeekableIterator<BAMScheduleEntry>> scheduleIterators = new ArrayList<PeekableIterator<BAMScheduleEntry>>();
    private BAMScheduleEntry nextScheduleEntry;
    private final int referenceSequence;
    private static final int INT_SIZE_IN_BYTES = 4;
    private static final int LONG_SIZE_IN_BYTES = 8;

    public BAMSchedule(SAMDataSource dataSource, List<GenomeLoc> intervals) {
        if (intervals.isEmpty()) {
            throw new ReviewedStingException("Tried to write schedule for empty interval list.");
        }
        this.referenceSequence = dataSource.getHeader().getSequence(intervals.get(0).getContig()).getSequenceIndex();
        this.createScheduleFile();
        this.readerIDs.addAll(dataSource.getReaderIDs());
        for (SAMReaderID reader : this.readerIDs) {
            GATKBAMIndex index = dataSource.getIndex(reader);
            GATKBAMIndexData indexData = index.readReferenceSequence(this.referenceSequence);
            int currentBinInLowestLevel = GATKBAMIndex.getFirstBinInLevel(GATKBAMIndex.getNumIndexLevels() - 1);
            Iterator<GenomeLoc> locusIterator = intervals.iterator();
            GenomeLoc currentLocus = locusIterator.next();
            long readerStartOffset = this.position();
            int maxChunkCount = 0;
            while (currentBinInLowestLevel < 37450 && currentLocus != null) {
                Bin bin = new Bin(this.referenceSequence, currentBinInLowestLevel);
                int binStart = index.getFirstLocusInBin(bin);
                int binStop = index.getLastLocusInBin(bin);
                if (binStop < currentLocus.getStart()) {
                    ++currentBinInLowestLevel;
                    continue;
                }
                if (binStart > currentLocus.getStop()) {
                    currentLocus = locusIterator.hasNext() ? locusIterator.next() : null;
                    continue;
                }
                GATKBAMFileSpan fileSpan = indexData.getSpanOverlapping(bin);
                if (!fileSpan.isEmpty()) {
                    ByteBuffer buffer = this.allocateByteBuffer(12 + fileSpan.getGATKChunks().size() * 8 * 2);
                    buffer.putInt(binStart);
                    buffer.putInt(binStop);
                    buffer.putInt(fileSpan.getGATKChunks().size());
                    for (GATKChunk chunk : fileSpan.getGATKChunks()) {
                        buffer.putLong(chunk.getChunkStart());
                        buffer.putLong(chunk.getChunkEnd());
                    }
                    maxChunkCount = Math.max(maxChunkCount, fileSpan.getGATKChunks().size());
                    buffer.flip();
                    this.write(buffer);
                }
                ++currentBinInLowestLevel;
            }
            long readerStopOffset = this.position();
            this.scheduleIterators.add((PeekableIterator<BAMScheduleEntry>)new PeekableIterator((Iterator)new BAMScheduleIterator(reader, readerStartOffset, readerStopOffset, maxChunkCount)));
            this.position(readerStopOffset);
        }
        this.advance();
    }

    public boolean hasNext() {
        return this.nextScheduleEntry != null;
    }

    public BAMScheduleEntry next() {
        BAMScheduleEntry currentScheduleEntry = this.nextScheduleEntry;
        this.advance();
        return currentScheduleEntry;
    }

    public void close() {
        try {
            this.scheduleFileChannel.close();
        }
        catch (IOException ex) {
            throw this.makeIOFailureException(true, "Unable to close schedule file.", ex);
        }
    }

    private final StingException makeIOFailureException(boolean wasWriting, String message, Exception e) {
        if (wasWriting) {
            if (e == null) {
                return new UserException.CouldNotCreateOutputFile(this.scheduleFile, message);
            }
            return new UserException.CouldNotCreateOutputFile(this.scheduleFile, message, e);
        }
        if (e == null) {
            return new UserException.CouldNotReadInputFile(this.scheduleFile, message);
        }
        return new UserException.CouldNotReadInputFile(this.scheduleFile, message, e);
    }

    private void advance() {
        this.nextScheduleEntry = null;
        BitSet selectedIterators = new BitSet(this.readerIDs.size());
        int currentStart = Integer.MAX_VALUE;
        int currentStop = Integer.MAX_VALUE;
        for (int reader = 0; reader < this.scheduleIterators.size(); ++reader) {
            PeekableIterator<BAMScheduleEntry> scheduleIterator = this.scheduleIterators.get(reader);
            if (!scheduleIterator.hasNext() || ((BAMScheduleEntry)scheduleIterator.peek()).start > currentStart) continue;
            if (((BAMScheduleEntry)scheduleIterator.peek()).start == currentStart) {
                selectedIterators.set(reader);
                currentStop = Math.min(((BAMScheduleEntry)scheduleIterator.peek()).stop, currentStop);
                continue;
            }
            if (((BAMScheduleEntry)scheduleIterator.peek()).start >= currentStart) continue;
            selectedIterators.clear();
            selectedIterators.set(reader);
            currentStart = ((BAMScheduleEntry)scheduleIterator.peek()).start;
            currentStop = ((BAMScheduleEntry)scheduleIterator.peek()).stop;
        }
        if (selectedIterators.isEmpty()) {
            return;
        }
        BAMScheduleEntry mergedScheduleEntry = new BAMScheduleEntry(currentStart, currentStop);
        int reader = selectedIterators.nextSetBit(0);
        while (reader >= 0) {
            PeekableIterator<BAMScheduleEntry> scheduleIterator = this.scheduleIterators.get(reader);
            BAMScheduleEntry individualScheduleEntry = (BAMScheduleEntry)scheduleIterator.peek();
            mergedScheduleEntry.mergeInto(individualScheduleEntry);
            if (individualScheduleEntry.stop <= currentStop) {
                scheduleIterator.next();
            }
            reader = selectedIterators.nextSetBit(reader + 1);
        }
        reader = selectedIterators.nextClearBit(0);
        while (reader < this.readerIDs.size()) {
            mergedScheduleEntry.addFileSpan(this.readerIDs.get(reader), new GATKBAMFileSpan());
            reader = selectedIterators.nextClearBit(reader + 1);
        }
        this.nextScheduleEntry = mergedScheduleEntry;
    }

    public void remove() {
        throw new UnsupportedOperationException("Unable to remove from a schedule iterator.");
    }

    private void createScheduleFile() {
        try {
            this.scheduleFile = File.createTempFile("bamschedule." + this.referenceSequence, null);
            this.scheduleFileChannel = new RandomAccessFile(this.scheduleFile, "rw").getChannel();
        }
        catch (IOException ex) {
            throw new UserException("Unable to create a temporary BAM schedule file.  Please make sure Java can write to the default temp directory or use -Djava.io.tmpdir= to instruct it to use a different temp directory instead.", (Throwable)ex);
        }
        this.scheduleFile.deleteOnExit();
    }

    private ByteBuffer allocateByteBuffer(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    private int read(ByteBuffer buffer) {
        try {
            return this.scheduleFileChannel.read(buffer);
        }
        catch (IOException ex) {
            throw this.makeIOFailureException(false, "Unable to read data from BAM schedule file.", ex);
        }
    }

    private void write(ByteBuffer buffer) {
        try {
            this.scheduleFileChannel.write(buffer);
            if (buffer.remaining() > 0) {
                throw this.makeIOFailureException(true, "Unable to write entire buffer to file.", null);
            }
        }
        catch (IOException ex) {
            throw this.makeIOFailureException(true, "Unable to write data to BAM schedule file.", ex);
        }
    }

    private long position() {
        try {
            return this.scheduleFileChannel.position();
        }
        catch (IOException ex) {
            throw this.makeIOFailureException(false, "Unable to retrieve position of BAM schedule file.", ex);
        }
    }

    private void position(long position) {
        try {
            this.scheduleFileChannel.position(position);
        }
        catch (IOException ex) {
            throw this.makeIOFailureException(false, "Unable to position BAM schedule file.", ex);
        }
    }

    private class BAMScheduleIterator
    implements Iterator<BAMScheduleEntry> {
        private final SAMReaderID reader;
        private long currentPosition;
        private final long stopPosition;
        private final ByteBuffer binHeader;
        private final ByteBuffer chunkData;

        public BAMScheduleIterator(SAMReaderID reader, long startPosition, long stopPosition, int maxChunkCount) {
            this.reader = reader;
            this.currentPosition = startPosition;
            this.stopPosition = stopPosition;
            this.binHeader = BAMSchedule.this.allocateByteBuffer(12);
            this.chunkData = BAMSchedule.this.allocateByteBuffer(maxChunkCount * 8 * 2);
        }

        @Override
        public boolean hasNext() {
            return this.currentPosition < this.stopPosition;
        }

        @Override
        public BAMScheduleEntry next() {
            BAMSchedule.this.position(this.currentPosition);
            int binHeaderBytesRead = BAMSchedule.this.read(this.binHeader);
            if (binHeaderBytesRead < 12) {
                throw new ReviewedStingException(String.format("Unable to read a complete bin header from BAM schedule file %s for BAM file %s. The BAM schedule file is likely incomplete/corrupt.", BAMSchedule.this.scheduleFile.getAbsolutePath(), this.reader.getSamFilePath()));
            }
            this.binHeader.flip();
            int start = this.binHeader.getInt();
            int stop = this.binHeader.getInt();
            int numChunks = this.binHeader.getInt();
            this.binHeader.flip();
            GATKChunk[] chunks = new GATKChunk[numChunks];
            this.chunkData.limit(numChunks * 8 * 2);
            long bytesRead = BAMSchedule.this.read(this.chunkData);
            if (bytesRead != (long)(numChunks * 8 * 2)) {
                throw new ReviewedStingException("Unable to read all chunks from file");
            }
            this.chunkData.flip();
            for (int i = 0; i < numChunks; ++i) {
                chunks[i] = new GATKChunk(this.chunkData.getLong(), this.chunkData.getLong());
            }
            this.chunkData.flip();
            BAMScheduleEntry nextScheduleEntry = new BAMScheduleEntry(start, stop);
            nextScheduleEntry.addFileSpan(this.reader, new GATKBAMFileSpan(chunks));
            this.currentPosition = BAMSchedule.this.position();
            return nextScheduleEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove from a BAMScheduleIterator");
        }
    }
}

