/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.utils.collections.Pair;

public class RODMetaDataContainer {
    private final HashMap<String, GATKFeature> nameMap = new HashMap();
    private final List<Pair<Class, GATKFeature>> classMap = new ArrayList<Pair<Class, GATKFeature>>();

    public void addEntry(GATKFeature data) {
        this.nameMap.put(data.getName(), data);
        this.classMap.add((Pair<Class, GATKFeature>)new Pair(data.getClass(), (Object)data));
    }

    public Collection<GATKFeature> getSet(String name) {
        if (name == null) {
            return this.getSet();
        }
        HashSet<GATKFeature> set = new HashSet<GATKFeature>();
        if (this.nameMap.containsKey(name)) {
            set.add(this.nameMap.get(name));
        }
        return set;
    }

    public Collection<GATKFeature> getSet() {
        return new ArrayList<GATKFeature>(this.nameMap.values());
    }

    public Collection<GATKFeature> getSet(Class cls) {
        ArrayList<GATKFeature> ret = new ArrayList<GATKFeature>();
        for (Pair<Class, GATKFeature> pair : this.classMap) {
            if (!((Class)pair.first).equals(cls)) continue;
            ret.add((GATKFeature)pair.second);
        }
        return ret;
    }
}

