/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.arguments;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMFileReader;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.gatk.DownsampleType;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.phonehome.GATKRunReport;
import org.broadinstitute.sting.gatk.samples.PedigreeValidationType;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.IntervalSetRule;

public class GATKArgumentCollection {
    private float versionNumber = 1.0f;
    private String description = "GATK Arguments";
    public Map<String, String> walkerArgs = new HashMap<String, String>();
    @Input(fullName="input_file", shortName="I", doc="SAM or BAM file(s)", required=false)
    public List<String> samFiles = new ArrayList<String>();
    @Argument(fullName="read_buffer_size", shortName="rbs", doc="Number of reads per SAM file to buffer in memory", required=false)
    public Integer readBufferSize = null;
    @Argument(fullName="phone_home", shortName="et", doc="What kind of GATK run report should we generate? STANDARD is the default, can be NO_ET so nothing is posted to the run repository. Please see http://www.broadinstitute.org/gsa/wiki/index.php/Phone_home for details.", required=false)
    public GATKRunReport.PhoneHomeOption phoneHomeType = GATKRunReport.PhoneHomeOption.STANDARD;
    @Argument(fullName="gatk_key", shortName="K", doc="GATK Key file. Required if running with -et NO_ET. Please see http://www.broadinstitute.org/gsa/wiki/index.php/Phone_home for details.", required=false)
    public File gatkKeyFile = null;
    @Argument(fullName="read_filter", shortName="rf", doc="Specify filtration criteria to apply to each read individually", required=false)
    public List<String> readFilters = new ArrayList<String>();
    @Input(fullName="intervals", shortName="L", doc="One or more genomic intervals over which to operate. Can be explicitly specified on the command line or in a file (including a rod file)", required=false)
    public List<IntervalBinding<Feature>> intervals = null;
    @Input(fullName="excludeIntervals", shortName="XL", doc="One or more genomic intervals to exclude from processing. Can be explicitly specified on the command line or in a file (including a rod file)", required=false)
    public List<IntervalBinding<Feature>> excludeIntervals = null;
    @Argument(fullName="interval_set_rule", shortName="isr", doc="Indicates the set merging approach the interval parser should use to combine the various -L or -XL inputs", required=false)
    public IntervalSetRule intervalSetRule = IntervalSetRule.UNION;
    @Argument(fullName="interval_merging", shortName="im", doc="Indicates the interval merging rule we should use for abutting intervals", required=false)
    public IntervalMergingRule intervalMerging = IntervalMergingRule.ALL;
    @Input(fullName="reference_sequence", shortName="R", doc="Reference sequence file", required=false)
    public File referenceFile = null;
    @Argument(fullName="nonDeterministicRandomSeed", shortName="ndrs", doc="Makes the GATK behave non deterministically, that is, the random numbers generated will be different in every run", required=false)
    public boolean nonDeterministicRandomSeed = false;
    private static DownsampleType DEFAULT_DOWNSAMPLING_TYPE = DownsampleType.BY_SAMPLE;
    private static int DEFAULT_DOWNSAMPLING_COVERAGE = 1000;
    @Argument(fullName="downsampling_type", shortName="dt", doc="Type of reads downsampling to employ at a given locus.  Reads will be selected randomly to be removed from the pile based on the method described here", required=false)
    public DownsampleType downsamplingType = null;
    @Argument(fullName="downsample_to_fraction", shortName="dfrac", doc="Fraction [0.0-1.0] of reads to downsample to", required=false)
    public Double downsampleFraction = null;
    @Argument(fullName="downsample_to_coverage", shortName="dcov", doc="Coverage [integer] to downsample to at any given locus; note that downsampled reads are randomly selected from all possible reads at a locus", required=false)
    public Integer downsampleCoverage = null;
    @Argument(fullName="baq", shortName="baq", doc="Type of BAQ calculation to apply in the engine", required=false)
    public BAQ.CalculationMode BAQMode = BAQ.CalculationMode.OFF;
    @Argument(fullName="baqGapOpenPenalty", shortName="baqGOP", doc="BAQ gap open penalty (Phred Scaled).  Default value is 40.  30 is perhaps better for whole genome call sets", required=false)
    public double BAQGOP = BAQ.DEFAULT_GOP;
    @Argument(fullName="performanceLog", shortName="PF", doc="If provided, a GATK runtime performance log will be written to this file", required=false)
    public File performanceLog = null;
    @Argument(fullName="useOriginalQualities", shortName="OQ", doc="If set, use the original base quality scores from the OQ tag when present instead of the standard scores", required=false)
    public Boolean useOriginalBaseQualities = false;
    @Input(fullName="BQSR", shortName="BQSR", required=false, doc="Filename for the input covariates table recalibration .csv file which enables on the fly base quality score recalibration")
    public File BQSR_RECAL_FILE = null;
    @Argument(fullName="quantize_quals", shortName="qq", doc="Quantize quality scores to a given number of levels.", required=false)
    public int quantizationLevels = -1;
    @Argument(fullName="defaultBaseQualities", shortName="DBQ", doc="If reads are missing some or all base quality scores, this value will be used for all base quality scores", required=false)
    public byte defaultBaseQualities = (byte)-1;
    @Argument(fullName="validation_strictness", shortName="S", doc="How strict should we be with validation", required=false)
    public SAMFileReader.ValidationStringency strictnessLevel = SAMFileReader.ValidationStringency.SILENT;
    @Argument(fullName="unsafe", shortName="U", doc="If set, enables unsafe operations: nothing will be checked at runtime.  For expert users only who know what they are doing.  We do not support usage of this argument.", required=false)
    public ValidationExclusion.TYPE unsafe;
    @Argument(fullName="num_threads", shortName="nt", doc="How many threads should be allocated to running this analysis.", required=false)
    public Integer numberOfThreads = 1;
    @Argument(fullName="num_cpu_threads", shortName="nct", doc="How many of the given threads should be allocated to the CPU", required=false)
    @Hidden
    public Integer numberOfCPUThreads = null;
    @Argument(fullName="num_io_threads", shortName="nit", doc="How many of the given threads should be allocated to IO", required=false)
    @Hidden
    public Integer numberOfIOThreads = null;
    @Argument(fullName="num_bam_file_handles", shortName="bfh", doc="The total number of BAM file handles to keep open simultaneously", required=false)
    public Integer numberOfBAMFileHandles = null;
    @Input(fullName="read_group_black_list", shortName="rgbl", doc="Filters out read groups matching <TAG>:<STRING> or a .txt file containing the filter strings one per line.", required=false)
    public List<String> readGroupBlackList = null;
    @Argument(fullName="pedigree", shortName="ped", doc="Pedigree files for samples", required=false)
    public List<File> pedigreeFiles = Collections.emptyList();
    @Argument(fullName="pedigreeString", shortName="pedString", doc="Pedigree string for samples", required=false)
    public List<String> pedigreeStrings = Collections.emptyList();
    @Argument(fullName="pedigreeValidationType", shortName="pedValidationType", doc="How strict should we be in validating the pedigree information?", required=false)
    public PedigreeValidationType pedigreeValidationType = PedigreeValidationType.STRICT;
    @Argument(fullName="allow_intervals_with_unindexed_bam", doc="Allow interval processing with an unsupported BAM.  NO INTEGRATION TESTS are available.  Use at your own risk.", required=false)
    @Hidden
    public boolean allowIntervalsWithUnindexedBAM = false;

    public DownsamplingMethod getDownsamplingMethod() {
        if (this.downsamplingType == null && this.downsampleFraction == null && this.downsampleCoverage == null) {
            return null;
        }
        if (this.downsamplingType == null && this.downsampleCoverage != null) {
            return new DownsamplingMethod(DEFAULT_DOWNSAMPLING_TYPE, this.downsampleCoverage, null);
        }
        return new DownsamplingMethod(this.downsamplingType, this.downsampleCoverage, this.downsampleFraction);
    }

    public void setDownsamplingMethod(DownsamplingMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.downsamplingType = method.type;
        this.downsampleCoverage = method.toCoverage;
        this.downsampleFraction = method.toFraction;
    }

    public static DownsamplingMethod getDefaultDownsamplingMethod() {
        return new DownsamplingMethod(DEFAULT_DOWNSAMPLING_TYPE, DEFAULT_DOWNSAMPLING_COVERAGE, null);
    }

    public boolean equals(GATKArgumentCollection other) {
        if (other == null) {
            return false;
        }
        if (other.samFiles.size() != this.samFiles.size()) {
            return false;
        }
        for (int x = 0; x < this.samFiles.size(); ++x) {
            if (this.samFiles.get(x).equals(other.samFiles.get(x))) continue;
            return false;
        }
        if (other.walkerArgs.size() != this.walkerArgs.size()) {
            return false;
        }
        for (String s : this.walkerArgs.keySet()) {
            if (other.walkerArgs.containsKey(s)) continue;
            return false;
        }
        if (!((Object)other.samFiles).equals(this.samFiles)) {
            return false;
        }
        if (other.readBufferSize == null || this.readBufferSize == null ? other.readBufferSize != null || this.readBufferSize != null : !other.readBufferSize.equals(this.readBufferSize)) {
            return false;
        }
        if (!(other.readBufferSize == null && this.readBufferSize == null || other.readBufferSize != null && this.readBufferSize != null)) {
            return false;
        }
        if (!other.strictnessLevel.equals((Object)this.strictnessLevel)) {
            return false;
        }
        if (!other.referenceFile.equals(this.referenceFile)) {
            return false;
        }
        if (other.intervals == null && this.intervals != null || !((Object)other.intervals).equals(this.intervals)) {
            return false;
        }
        if (!((Object)other.excludeIntervals).equals(this.excludeIntervals)) {
            return false;
        }
        if (!other.unsafe.equals((Object)this.unsafe)) {
            return false;
        }
        if (other.downsampleFraction == null && this.downsampleFraction != null || other.downsampleFraction != null && !other.downsampleFraction.equals(this.downsampleFraction)) {
            return false;
        }
        if (other.downsampleCoverage == null && this.downsampleCoverage != null || other.downsampleCoverage != null && !other.downsampleCoverage.equals(this.downsampleCoverage)) {
            return false;
        }
        if (!other.numberOfThreads.equals(this.numberOfThreads)) {
            return false;
        }
        if (this.numberOfCPUThreads == null && other.numberOfCPUThreads != null || this.numberOfCPUThreads.equals(other.numberOfCPUThreads)) {
            return false;
        }
        if (this.numberOfIOThreads == null && other.numberOfIOThreads != null || this.numberOfIOThreads.equals(other.numberOfIOThreads)) {
            return false;
        }
        if (other.numberOfBAMFileHandles == null && this.numberOfBAMFileHandles != null || other.numberOfBAMFileHandles != null && !other.numberOfBAMFileHandles.equals(this.numberOfBAMFileHandles)) {
            return false;
        }
        if (other.intervalMerging != this.intervalMerging) {
            return false;
        }
        if (other.phoneHomeType != this.phoneHomeType) {
            return false;
        }
        if (this.intervalSetRule != other.intervalSetRule) {
            return false;
        }
        if (this.BAQMode != other.BAQMode) {
            return false;
        }
        if (this.BAQGOP != other.BAQGOP) {
            return false;
        }
        if (other.performanceLog == null && this.performanceLog != null || other.performanceLog != null && !other.performanceLog.equals(this.performanceLog)) {
            return false;
        }
        return this.allowIntervalsWithUnindexedBAM == other.allowIntervalsWithUnindexedBAM;
    }
}

