/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.sf.picard.filter.SamRecordFilter;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ReadMetrics
implements Cloneable {
    private long nRecords;
    private long nReads;
    private long nSkippedReads;
    private long nUnmappedReads;
    private long nNotPrimary;
    private long nBadAlignments;
    private long nSkippedIndels;
    private long nDuplicates;
    private Map<Class, Long> counter = new HashMap<Class, Long>();

    public void incrementMetrics(ReadMetrics metrics) {
        this.nRecords += metrics.nRecords;
        this.nReads += metrics.nReads;
        this.nSkippedReads += metrics.nSkippedReads;
        this.nUnmappedReads += metrics.nUnmappedReads;
        this.nNotPrimary += metrics.nNotPrimary;
        this.nBadAlignments += metrics.nBadAlignments;
        this.nSkippedIndels += metrics.nSkippedIndels;
        this.nDuplicates += metrics.nDuplicates;
        for (Map.Entry<Class, Long> counterEntry : metrics.counter.entrySet()) {
            Class counterType = counterEntry.getKey();
            long newValue = (this.counter.containsKey(counterType) ? this.counter.get(counterType) : 0L) + counterEntry.getValue();
            this.counter.put(counterType, newValue);
        }
    }

    public ReadMetrics clone() {
        ReadMetrics newMetrics;
        try {
            newMetrics = (ReadMetrics)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new ReviewedStingException("Unable to clone runtime metrics", (Throwable)ex);
        }
        newMetrics.nRecords = this.nRecords;
        newMetrics.nReads = this.nReads;
        newMetrics.nSkippedReads = this.nSkippedReads;
        newMetrics.nUnmappedReads = this.nUnmappedReads;
        newMetrics.nNotPrimary = this.nNotPrimary;
        newMetrics.nBadAlignments = this.nBadAlignments;
        newMetrics.nSkippedIndels = this.nSkippedIndels;
        newMetrics.nDuplicates = this.nDuplicates;
        newMetrics.counter = new HashMap<Class, Long>(this.counter);
        return newMetrics;
    }

    public void incrementFilter(SamRecordFilter filter) {
        long c = 0L;
        if (this.counter.containsKey(filter.getClass())) {
            c = this.counter.get(filter.getClass());
        }
        this.counter.put(filter.getClass(), c + 1L);
    }

    public Map<String, Long> getCountsByFilter() {
        TreeMap<String, Long> sortedCounts = new TreeMap<String, Long>();
        for (Map.Entry<Class, Long> counterEntry : this.counter.entrySet()) {
            sortedCounts.put(counterEntry.getKey().getSimpleName(), counterEntry.getValue());
        }
        return sortedCounts;
    }

    public long getNumIterations() {
        return this.nRecords;
    }

    public void incrementNumIterations() {
        ++this.nRecords;
    }

    public long getNumReadsSeen() {
        return this.nReads;
    }

    public void incrementNumReadsSeen() {
        ++this.nReads;
    }

    public long getNumSkippedReads() {
        return this.nSkippedReads;
    }

    public void incrementNumSkippedReads() {
        ++this.nSkippedReads;
    }

    public long getNumUnmappedReads() {
        return this.nUnmappedReads;
    }

    public void incrementNumUnmappedReads() {
        ++this.nUnmappedReads;
    }

    public long getNumNonPrimaryReads() {
        return this.nNotPrimary;
    }

    public void incrementNumNonPrimaryReads() {
        ++this.nNotPrimary;
    }

    public long getNumBadAlignments() {
        return this.nBadAlignments;
    }

    public void incrementNumBadAlignments() {
        ++this.nBadAlignments;
    }

    public long getNumSkippedIndels() {
        return this.nSkippedIndels;
    }

    public void incrementNumSkippedIndels() {
        ++this.nSkippedIndels;
    }

    public long getNumDuplicates() {
        return this.nDuplicates;
    }

    public void incrementNumDuplicates() {
        ++this.nDuplicates;
    }
}

