/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.packing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import org.broadinstitute.sting.alignment.reference.packing.BasePackedOutputStream;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class PackUtils {
    public static final int ALPHABET_SIZE = 4;
    public static final int BITS_PER_BASE = (int)(Math.log(4.0) / Math.log(2.0));
    public static final int BITS_PER_BYTE = 8;

    public static void writeReferenceSequence(File outputFile, byte[] referenceSequence) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        BasePackedOutputStream<Byte> basePackedOutputStream = new BasePackedOutputStream<Byte>(Byte.class, outputStream, ByteOrder.BIG_ENDIAN);
        basePackedOutputStream.write(referenceSequence);
        ((OutputStream)outputStream).write(referenceSequence.length % 4);
        ((OutputStream)outputStream).close();
    }

    public static int bitsInType(Class<?> type) {
        try {
            long typeSize = type.getField("MAX_VALUE").getLong(null) - type.getField("MIN_VALUE").getLong(null) + 1L;
            long intTypeSize = 0x100000000L;
            if (typeSize > intTypeSize) {
                throw new ReviewedStingException("Cannot determine number of bits available in type: " + type.getName());
            }
            return (int)(Math.log(typeSize) / Math.log(2.0));
        }
        catch (NoSuchFieldException ex) {
            throw new ReviewedStingException("Cannot determine number of bits available in type: " + type.getName(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReviewedStingException("Cannot determine number of bits available in type: " + type.getName(), (Throwable)ex);
        }
    }

    public static byte packBase(byte base) {
        switch (base) {
            case 65: {
                return 0;
            }
            case 67: {
                return 1;
            }
            case 71: {
                return 2;
            }
            case 84: {
                return 3;
            }
        }
        throw new ReviewedStingException("Unknown base type: " + base);
    }

    public static byte unpackBase(byte pack) {
        switch (pack) {
            case 0: {
                return 65;
            }
            case 1: {
                return 67;
            }
            case 2: {
                return 71;
            }
            case 3: {
                return 84;
            }
        }
        throw new ReviewedStingException("Unknown pack type: " + pack);
    }

    public static void reverse(byte[] bases) {
        int i = 0;
        for (int j = bases.length - 1; i < j; ++i, --j) {
            byte temp = bases[j];
            bases[j] = bases[i];
            bases[i] = temp;
        }
    }

    public static int numberOfPartitions(long size, long partitionSize) {
        return (int)((size + partitionSize - 1L) / partitionSize);
    }
}

