/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.reflections.ReflectionsException;
import org.reflections.scanners.AbstractScanner;
import org.reflections.serializers.JavaCodeSerializer;
import org.reflections.vfs.Vfs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesScanner
extends AbstractScanner {
    private static final List<String> javaCodeSerializerInterfaces = Lists.newArrayList((Object[])new String[]{JavaCodeSerializer.IElement.class.getName(), JavaCodeSerializer.IPackage.class.getName(), JavaCodeSerializer.IClass.class.getName(), JavaCodeSerializer.IField.class.getName(), JavaCodeSerializer.IMethod.class.getName()});

    @Override
    public boolean acceptsInput(String file) {
        return file.endsWith(".class");
    }

    @Override
    public void scan(Vfs.File file) {
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            Object cls = this.getMetadataAdapter().createClassObject(inputStream);
            this.scan(cls, file);
        }
        catch (IOException e) {
            throw new RuntimeException("could not create class file from " + file.getName(), e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new ReflectionsException("could not close input stream", e);
            }
        }
    }

    private void scan(Object cls, Vfs.File file) {
        if (TypesScanner.isJavaCodeSerializer(this.getMetadataAdapter().getInterfacesNames(cls))) {
            return;
        }
        String className = this.getMetadataAdapter().getClassName(cls);
        this.getStore().put((Object)className, (Object)file.getFullPath());
    }

    @Override
    public void scan(Object cls) {
        throw new UnsupportedOperationException("should not get here");
    }

    public static boolean isJavaCodeSerializer(List<String> interfacesNames) {
        return interfacesNames.size() == 1 && javaCodeSerializerInterfaces.contains(interfacesNames.get(0));
    }
}

