/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.model.VariableModel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaFileObject;

public class Elements {
    @Requires(value={"method != null", "parameters != null", "!parameters.contains(null)"})
    public static void copyParameters(MethodModel methodModel, List<? extends VariableModel> list) {
        ArrayList<? extends VariableModel> arrayList = new ArrayList<VariableModel>(list);
        for (VariableModel variableModel : arrayList) {
            methodModel.addParameter(new VariableModel(variableModel));
        }
    }

    @Requires(value={"elements != null", "!elements.contains(null)", "clazz != null", "kinds != null"})
    public static <T extends ElementModel> List<? extends T> filter(List<? extends ElementModel> list, Class<T> clazz, ElementKind ... elementKindArray) {
        ArrayList<ElementModel> arrayList = new ArrayList<ElementModel>();
        List<ElementKind> list2 = Arrays.asList(elementKindArray);
        for (ElementModel elementModel : list) {
            if (!list2.contains((Object)elementModel.getKind()) || !clazz.isAssignableFrom(elementModel.getClass())) continue;
            arrayList.add(elementModel);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Requires(value={"element != null", "clazz != null", "kinds != null"})
    public static <T extends ElementModel> T findEnclosingElement(ElementModel elementModel, Class<T> clazz, ElementKind ... elementKindArray) {
        List<ElementKind> list = Arrays.asList(elementKindArray);
        do {
            if ((elementModel = elementModel.getEnclosingElement()) != null) continue;
            return null;
        } while (!list.contains((Object)elementModel.getKind()) || !clazz.isAssignableFrom(elementModel.getClass()));
        return (T)elementModel;
    }

    @Requires(value={"element != null"})
    public static TypeModel getTypeOf(ElementModel elementModel) {
        return Elements.findEnclosingElement(elementModel, TypeModel.class, ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE);
    }

    @Requires(value={"name != null", "!name.isEmpty()", "kind != null"})
    public static URI getUriForClass(String string, JavaFileObject.Kind kind) {
        try {
            return new URI("com.google.java.contract://com.google.java.contract/" + string + kind.extension);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException();
        }
    }
}

