/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.ElementModifier;
import java.util.EnumSet;

@Invariant(value={"getModifiers() != null"})
public abstract class QualifiedElementModel
extends ElementModel {
    protected EnumSet<ElementModifier> modifiers;

    @Requires(value={"kind != null", "name != null"})
    protected QualifiedElementModel(ElementKind elementKind, String string) {
        super(elementKind, string);
        this.modifiers = EnumSet.noneOf(ElementModifier.class);
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    protected QualifiedElementModel(QualifiedElementModel qualifiedElementModel) {
        super(qualifiedElementModel);
        this.modifiers = EnumSet.copyOf(qualifiedElementModel.modifiers);
    }

    @Override
    protected QualifiedElementModel clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public EnumSet<ElementModifier> getModifiers() {
        return this.modifiers;
    }

    @Requires(value={"modifier != null"})
    @Ensures(value={"getModifiers().contains(modifier)"})
    public void addModifier(ElementModifier elementModifier) {
        switch (elementModifier) {
            case PRIVATE: 
            case PACKAGE_PRIVATE: 
            case PROTECTED: 
            case PUBLIC: {
                this.modifiers.remove((Object)ElementModifier.PRIVATE);
                this.modifiers.remove((Object)ElementModifier.PACKAGE_PRIVATE);
                this.modifiers.remove((Object)ElementModifier.PROTECTED);
                this.modifiers.remove((Object)ElementModifier.PUBLIC);
            }
        }
        this.modifiers.add(elementModifier);
    }

    @Requires(value={"modifier != null"})
    @Ensures(value={"!getModifiers().contains(modifier)"})
    public void removeModifier(ElementModifier elementModifier) {
        this.modifiers.remove((Object)elementModifier);
        switch (elementModifier) {
            case PRIVATE: 
            case PACKAGE_PRIVATE: 
            case PROTECTED: 
            case PUBLIC: {
                this.modifiers.add(ElementModifier.PACKAGE_PRIVATE);
            }
        }
    }
}

