/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementVisitor;
import com.google.java.contract.util.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

@Invariant(value={"getEnclosingElement() == null || getEnclosingElement().getEnclosedElements().contains(this)", "Iterables.all(getEnclosedElements(), isValidEnclosedElement())", "getKind() != null", "getSimpleName() != null"})
public abstract class ElementModel
implements Cloneable {
    protected ElementKind kind;
    protected String simpleName;
    protected ElementModel enclosingElement;
    protected List<ElementModel> enclosedElements;
    protected Object sourceInfo;
    private final Predicate<ElementModel> isValidEnclosedElementPredicate = new Predicate<ElementModel>(){

        @Override
        public boolean apply(ElementModel elementModel) {
            return ElementModel.this.isValidEnclosedElement(elementModel);
        }
    };

    @Requires(value={"kind != null", "name != null"})
    protected ElementModel(ElementKind elementKind, String string) {
        this.kind = elementKind;
        this.simpleName = string;
        this.enclosingElement = null;
        this.enclosedElements = new ArrayList<ElementModel>();
        this.sourceInfo = null;
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    protected ElementModel(ElementModel elementModel) {
        this.kind = elementModel.kind;
        this.simpleName = elementModel.simpleName;
        this.enclosingElement = null;
        this.enclosedElements = new ArrayList<ElementModel>(elementModel.enclosedElements.size());
        ArrayList<ElementModel> arrayList = new ArrayList<ElementModel>(elementModel.enclosedElements);
        for (ElementModel elementModel2 : arrayList) {
            try {
                this.addEnclosedElement(elementModel2.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        this.sourceInfo = elementModel.sourceInfo;
    }

    @Ensures(value={"result != null", "result.getEnclosingElement() == null"})
    protected ElementModel clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public ElementKind getKind() {
        return this.kind;
    }

    public List<? extends ElementModel> getEnclosedElements() {
        return Collections.unmodifiableList(this.enclosedElements);
    }

    @Requires(value={"index >= 0", "index <= element.getEnclosedElements().size()", "isValidEnclosedElement(element)"})
    @Ensures(value={"enclosedElements.contains(element)"})
    protected void addEnclosedElement(int n, ElementModel elementModel) {
        this.fixEnclosedElement(elementModel);
        this.enclosedElements.add(n, elementModel);
    }

    @Requires(value={"isValidEnclosedElement(element)"})
    @Ensures(value={"getEnclosedElements().contains(element)"})
    public void addEnclosedElement(ElementModel elementModel) {
        this.fixEnclosedElement(elementModel);
        this.enclosedElements.add(elementModel);
    }

    private void fixEnclosedElement(ElementModel elementModel) {
        if (elementModel.enclosingElement != null) {
            elementModel.enclosingElement.removeEnclosedElement(elementModel);
        }
        elementModel.enclosingElement = this;
    }

    @Requires(value={"isValidEnclosedElement(element)"})
    @Ensures(value={"!getEnclosedElements().contains(element)"})
    public void removeEnclosedElement(ElementModel elementModel) {
        this.enclosedElements.remove(elementModel);
        elementModel.enclosingElement = null;
    }

    public ElementModel getEnclosingElement() {
        return this.enclosingElement;
    }

    @Requires(value={"element == null || isValidEnclosedElement(element)"})
    @Ensures(value={"element == getEnclosingElement()", "element.getEnclosedElements().contains(this)"})
    public void setEnclosingElement(ElementModel elementModel) {
        elementModel.addEnclosedElement(this);
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public Object getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(Object object) {
        this.sourceInfo = object;
    }

    @Requires(value={"visitor != null"})
    public abstract void accept(ElementVisitor var1);

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ElementModel)) {
            return false;
        }
        ElementModel elementModel = (ElementModel)object;
        return elementModel.getSimpleName().equals(this.getSimpleName()) && elementModel.getEnclosingElement().equals(this.getEnclosingElement());
    }

    public int hashCode() {
        return 31 * this.simpleName.hashCode() + this.getEnclosingElement().hashCode();
    }

    public String toString() {
        return this.simpleName;
    }

    public boolean isValidEnclosedElement(ElementModel elementModel) {
        return elementModel != null && this.getAllowedEnclosedKinds().contains((Object)elementModel.getKind());
    }

    public Predicate<ElementModel> isValidEnclosedElement() {
        return this.isValidEnclosedElementPredicate;
    }

    @Ensures(value={"result != null"})
    public EnumSet<ElementKind> getAllowedEnclosedKinds() {
        return EnumSet.noneOf(ElementKind.class);
    }
}

