/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.core.apt.SourceDependencyParser;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.util.JavaUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

public class SourcePreprocessor {
    public static void main(String[] stringArray) throws IOException, JavaUtils.ParseException {
        String string = System.getProperty("com.google.java.contract.depsoutput");
        for (String string2 : stringArray) {
            File file;
            String string3;
            if (string2.startsWith("-")) continue;
            String string4 = string2;
            if (string2.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
                string4 = string4.substring(0, string4.length() - JavaFileObject.Kind.SOURCE.extension.length());
            }
            string3 = (string3 = (file = new File(string4 + JavaFileObject.Kind.SOURCE.extension)).getParent()) == null ? "" : string3 + "/";
            FileInputStream fileInputStream = new FileInputStream(string2);
            SourceDependencyParser sourceDependencyParser = new SourceDependencyParser(new InputStreamReader(fileInputStream));
            try {
                sourceDependencyParser.parse();
            }
            catch (JavaUtils.ParseException parseException) {
                throw new JavaUtils.ParseException(file + " is malformed; " + "you should not compile contracts before compiling " + "the actual source files; " + "if this file is valid Java, you found a bug in Contracts for Java; " + "please email 'davidmorgan@google.com'", parseException);
            }
            Set<String> set = sourceDependencyParser.getImportNames();
            Map<ClassName, List<Long>> map = sourceDependencyParser.getContractLineNumbers();
            if (map.isEmpty()) continue;
            for (Map.Entry<ClassName, List<Long>> entry : map.entrySet()) {
                ClassName className = entry.getKey();
                File file2 = string == null ? new File(string3 + className.getSimpleName() + ".java.d") : new File(string + "/" + className.getBinaryName() + ".java.d");
                file2.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(set);
                objectOutputStream.writeObject(entry.getValue());
                objectOutputStream.close();
            }
            fileInputStream.close();
        }
    }
}

