/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.QualifiedElementModel;
import com.google.java.contract.core.model.TypeName;
import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Invariant(value={"processingEnv != null", "elementUtils != null", "typeUtils != null"})
class FactoryUtils {
    ProcessingEnvironment processingEnv;
    Elements elementUtils;
    Types typeUtils;

    @Requires(value={"processingEnv != null"})
    @Ensures(value={"this.processingEnv == processingEnv", "elementUtils == processingEnv.getElementUtils()", "typeUtils == processingEnv.getTypeUtils()"})
    FactoryUtils(ProcessingEnvironment processingEnvironment) {
        this.processingEnv = processingEnvironment;
        this.elementUtils = processingEnvironment.getElementUtils();
        this.typeUtils = processingEnvironment.getTypeUtils();
    }

    void copyModifiers(Element element, QualifiedElementModel qualifiedElementModel) {
        for (ElementModifier elementModifier : ElementModifier.forModifiers(element.getModifiers())) {
            qualifiedElementModel.addModifier(elementModifier);
        }
    }

    @Requires(value={"type != null", "type.getKind() == javax.lang.model.type.TypeKind.DECLARED"})
    @Ensures(value={"result == null || result.getDeclaredName().equals(type.toString())"})
    ClassName getClassNameForType(TypeMirror typeMirror) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        String string = this.elementUtils.getBinaryName(typeElement).toString().replace('.', '/');
        return new ClassName(string, ((Object)typeMirror).toString());
    }

    @Requires(value={"type != null"})
    @Ensures(value={"result == null || result.getDeclaredName().equals(type.toString())"})
    TypeName getTypeNameForType(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case NONE: {
                return null;
            }
        }
        return new TypeName(((Object)typeMirror).toString());
    }

    @Requires(value={"element != null"})
    @Ensures(value={"result != null"})
    TypeName getGenericTypeName(TypeParameterElement typeParameterElement) {
        String string = typeParameterElement.getSimpleName().toString();
        List<? extends TypeMirror> list = typeParameterElement.getBounds();
        if (list.isEmpty() || list.size() == 1 && ((Object)list.get(0)).toString().equals("java.lang.Object")) {
            return new TypeName(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" extends ");
        Iterator<? extends TypeMirror> iterator = list.iterator();
        while (true) {
            stringBuilder.append(((Object)iterator.next()).toString());
            if (!iterator.hasNext()) break;
            stringBuilder.append(" & ");
        }
        return new TypeName(stringBuilder.toString());
    }

    ElementKind getAnnotationKindForName(AnnotationMirror annotationMirror) {
        String string = annotationMirror.getAnnotationType().toString();
        ElementKind elementKind = string.equals("com.google.java.contract.Invariant") ? ElementKind.INVARIANT : (string.equals("com.google.java.contract.Requires") ? ElementKind.REQUIRES : (string.equals("com.google.java.contract.Ensures") ? ElementKind.ENSURES : (string.equals("com.google.java.contract.ThrowEnsures") ? ElementKind.THROW_ENSURES : null)));
        return elementKind;
    }

    boolean isContractAnnotation(AnnotationMirror annotationMirror) {
        return this.getAnnotationKindForName(annotationMirror) != null;
    }
}

