/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.AnnotationSourceInfo;
import com.google.java.contract.core.util.JavaUtils;
import com.google.java.contract.core.util.SyntheticJavaFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class DiagnosticManager
implements DiagnosticListener<JavaFileObject>,
Iterable<Report> {
    protected List<Report> reports = new ArrayList<Report>();
    protected int errorCount = 0;

    public boolean hasErrors() {
        return this.errorCount != 0;
    }

    @Ensures(value={"result >= 0"})
    public int getErrorCount() {
        return this.errorCount;
    }

    @Ensures(value={"result >= 0"})
    public int getCount() {
        return this.reports.size();
    }

    @Override
    public Iterator<Report> iterator() {
        return this.reports.iterator();
    }

    @Requires(value={"r != null"})
    public void report(Report report) {
        if (report.getKind() == Diagnostic.Kind.ERROR) {
            ++this.errorCount;
        }
        this.reports.add(report);
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        if (diagnostic.getKind() != Diagnostic.Kind.ERROR) {
            return;
        }
        this.report(new CompilerReport(diagnostic));
    }

    public void error(String string, String string2, int n, int n2, int n3, Object object) {
        this.report(new AnnotationReport(Diagnostic.Kind.ERROR, string, string2, n, n2, n3, object));
    }

    public void warning(String string, String string2, int n, int n2, int n3, Object object) {
        this.report(new AnnotationReport(Diagnostic.Kind.WARNING, string, string2, n, n2, n3, object));
    }

    @Invariant(value={"diagnostic != null"})
    public class CompilerReport
    extends Report {
        protected Diagnostic<? extends JavaFileObject> diagnostic;

        @Requires(value={"diagnostic != null"})
        public CompilerReport(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.diagnostic = diagnostic;
        }

        @Requires(value={"sourceContent != null", "sourceInfo != null"})
        protected String formatErrorSnippet(CharSequence charSequence, AnnotationSourceInfo annotationSourceInfo) {
            int n;
            List<String> list = annotationSourceInfo.getCode();
            int n2 = (int)this.diagnostic.getColumnNumber();
            int n3 = 0;
            for (String string : list) {
                n = string.length();
                if (n <= n3) continue;
                n3 = n;
            }
            int n4 = (int)this.diagnostic.getPosition();
            int n5 = n4 - n2 + 1;
            n = (int)this.diagnostic.getStartPosition();
            int n6 = (int)this.diagnostic.getEndPosition();
            String string = ((Object)charSequence.subSequence(n5, n6)).toString();
            String string2 = null;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            for (String string3 : list) {
                String string4 = "/*[" + JavaUtils.quoteComment(string3) + "]*/";
                int n10 = string.lastIndexOf(string4);
                if (n10 == -1) continue;
                string2 = string3;
                int n11 = n5 + (n10 += string4.length());
                n7 = n4 - n11;
                n8 = n - n11;
                n9 = n6 - n11;
                n7 -= JavaUtils.generatedCodeLength(string.substring(n10, n10 + n7));
                n8 -= JavaUtils.generatedCodeLength(string.substring(n10, n10 + n8));
                n9 -= JavaUtils.generatedCodeLength(string.substring(n10, n10 + n9));
            }
            if (string2 != null) {
                StringBuilder stringBuilder = new StringBuilder("clause: ");
                stringBuilder.append(string2);
                if (n7 != -1) {
                    stringBuilder.append("\n        ");
                    int n12 = string2.length();
                    if (n7 > n12) {
                        n7 = n12;
                    }
                    if (n8 > n12) {
                        n8 = n12;
                    }
                    if (n9 > n12) {
                        n9 = n12;
                    }
                    this.underlineError(stringBuilder, string2, n7, n8, n9);
                    string2 = stringBuilder.toString();
                }
            }
            return string2;
        }

        protected AnnotationSourceInfo getSourceInfo() {
            JavaFileObject javaFileObject = this.diagnostic.getSource();
            if (!(javaFileObject instanceof SyntheticJavaFile)) {
                return null;
            }
            SyntheticJavaFile syntheticJavaFile = (SyntheticJavaFile)javaFileObject;
            Object object = syntheticJavaFile.getSourceInfo(this.diagnostic.getLineNumber());
            if (!(object instanceof AnnotationSourceInfo)) {
                return null;
            }
            return (AnnotationSourceInfo)object;
        }

        @Override
        public Diagnostic.Kind getKind() {
            return this.diagnostic.getKind();
        }

        @Override
        public String getMessage(Locale locale) {
            AnnotationSourceInfo annotationSourceInfo = this.getSourceInfo();
            String string = "error in contract: ";
            String string2 = this.diagnostic.getCode();
            string = string2 != null && string2.startsWith("compiler.err.expected") ? string + "syntax error" : string + this.diagnostic.getMessage(locale);
            JavaFileObject javaFileObject = this.diagnostic.getSource();
            if (javaFileObject != null && annotationSourceInfo != null) {
                try {
                    CharSequence charSequence = javaFileObject.getCharContent(true);
                    return string + "\n" + this.formatErrorSnippet(charSequence, annotationSourceInfo);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string;
        }

        @Override
        public Element getElement() {
            AnnotationSourceInfo annotationSourceInfo = this.getSourceInfo();
            return this.getSourceInfo() == null ? null : annotationSourceInfo.getElement();
        }

        @Override
        public AnnotationMirror getAnnotationMirror() {
            AnnotationSourceInfo annotationSourceInfo = this.getSourceInfo();
            return this.getSourceInfo() == null ? null : annotationSourceInfo.getAnnotationMirror();
        }

        @Override
        public AnnotationValue getAnnotationValue() {
            AnnotationSourceInfo annotationSourceInfo = this.getSourceInfo();
            return this.getSourceInfo() == null ? null : annotationSourceInfo.getAnnotationValue();
        }
    }

    public class AnnotationReport
    extends Report {
        protected Diagnostic.Kind kind;
        protected String message;
        protected String sourceString;
        protected int position;
        protected int startPosition;
        protected int endPosition;
        protected AnnotationSourceInfo sourceInfo;

        @Requires(value={"kind != null", "message != null", "sourceString != null", "position >= startPosition", "position <= endPosition", "startPosition >= 0", "startPosition <= endPosition"})
        @Ensures(value={"kind == getKind()"})
        public AnnotationReport(Diagnostic.Kind kind, String string, String string2, int n, int n2, int n3, Object object) {
            this.kind = kind;
            this.message = string;
            this.sourceString = string2;
            this.position = n;
            this.startPosition = n2;
            this.endPosition = n3;
            if (object instanceof AnnotationSourceInfo) {
                this.sourceInfo = (AnnotationSourceInfo)object;
            }
        }

        @Override
        public Diagnostic.Kind getKind() {
            return this.kind;
        }

        @Override
        public String getMessage(Locale locale) {
            StringBuilder stringBuilder = new StringBuilder("clause: ");
            stringBuilder.append(this.sourceString);
            stringBuilder.append("\n        ");
            this.underlineError(stringBuilder, this.sourceString, this.position, this.startPosition, this.endPosition);
            return this.message + "\n" + stringBuilder.toString();
        }

        @Override
        public Element getElement() {
            return this.sourceInfo == null ? null : this.sourceInfo.getElement();
        }

        @Override
        public AnnotationMirror getAnnotationMirror() {
            return this.sourceInfo == null ? null : this.sourceInfo.getAnnotationMirror();
        }

        @Override
        public AnnotationValue getAnnotationValue() {
            return this.sourceInfo == null ? null : this.sourceInfo.getAnnotationValue();
        }
    }

    @Invariant(value={"getKind() != null", "getMessage(null) != null", "getAnnotationMirror() == null || getElement() != null", "getAnnotationValue() == null || getAnnotationMirror() != null"})
    public abstract class Report {
        public abstract Diagnostic.Kind getKind();

        public abstract String getMessage(Locale var1);

        public abstract Element getElement();

        public abstract AnnotationMirror getAnnotationMirror();

        public abstract AnnotationValue getAnnotationValue();

        @Requires(value={"buffer != null", "expr != null", "pos >= start", "pos <= end", "start >= 0", "start <= end", "end <= expr.length()"})
        protected void underlineError(StringBuilder stringBuilder, String string, int n, int n2, int n3) {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                stringBuilder.append(" ");
            }
            if (n == n2) {
                stringBuilder.append("^");
            } else {
                while (n4 < n) {
                    stringBuilder.append("~");
                    ++n4;
                }
                stringBuilder.append("^");
                ++n4;
                while (n4 < n3) {
                    stringBuilder.append("~");
                    ++n4;
                }
            }
        }
    }
}

