/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.AnnotationSourceInfo;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ContractMethodModel;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.util.ElementScanner;
import com.google.java.contract.core.util.Elements;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

@Invariant(value={"getLineNumberMap() != null", "Iterables.all(getLineNumberMap().keySet(), Predicates.between(1L, null))", "output != null", "lineNumber >= 1"})
public class ContractWriter
extends ElementScanner {
    private static final List<String> numericTypes = Arrays.asList("char", "byte", "short", "int", "long", "float", "double");
    private static final String CONTRACT_METHOD_SIGNATURE = "com.google.java.contract.core.agent.ContractMethodSignature";
    private static final String CONTRACT_KIND = "com.google.java.contract.core.model.ContractKind";
    private static final Pattern VARIADIC_REGEX = Pattern.compile("\\[\\p{javaWhitespace}*\\]\\p{javaWhitespace}*$");
    protected boolean debugTrace;
    protected ByteArrayOutputStream output;
    protected long lineNumber;
    protected Map<Long, Object> lineNumberMap;
    protected boolean isRootClass;
    protected TypeModel type;

    protected ContractWriter() {
        this(false);
    }

    protected ContractWriter(boolean bl) {
        this.debugTrace = bl;
        this.output = new ByteArrayOutputStream();
        this.lineNumber = 1L;
        this.lineNumberMap = new HashMap<Long, Object>();
        this.isRootClass = true;
        this.type = null;
    }

    @Requires(value={"parent != null"})
    protected ContractWriter(ContractWriter contractWriter) {
        this.debugTrace = contractWriter.debugTrace;
        this.output = contractWriter.output;
        this.lineNumber = contractWriter.lineNumber;
        this.lineNumberMap = contractWriter.lineNumberMap;
        this.isRootClass = false;
        this.type = null;
    }

    @Requires(value={"type != null"})
    @Ensures(value={"result != null"})
    protected static String getDefaultValue(TypeName typeName) {
        String string = typeName.getDeclaredName();
        if (string.equals("boolean")) {
            return "false";
        }
        if (numericTypes.contains(string)) {
            return "(" + string + ")0";
        }
        return "(" + string + ")null";
    }

    @Requires(value={"str != null"})
    protected void append(String string) {
        try {
            this.output.write(string.getBytes());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Ensures(value={"lineNumber == old(lineNumber) + 1"})
    protected void appendEndOfLine() {
        this.output.write(10);
        ++this.lineNumber;
    }

    @Requires(value={"info != null"})
    @Ensures(value={"lineNumber == old(lineNumber) + 1"})
    protected void appendEndOfLine(Object object) {
        this.lineNumberMap.put(this.lineNumber, object);
        this.appendEndOfLine();
    }

    @Requires(value={"list != null", "separator != null"})
    private void appendJoin(Collection<?> collection, String string) {
        if (collection.isEmpty()) {
            return;
        }
        Iterator<?> iterator = collection.iterator();
        while (true) {
            this.append(iterator.next().toString());
            if (!iterator.hasNext()) break;
            this.append(string);
        }
    }

    @Requires(value={"signature != null"})
    private void appendGenericSignature(List<? extends TypeName> list) {
        if (!list.isEmpty()) {
            this.append("<");
            this.appendJoin(list, ", ");
            this.append(">");
        }
    }

    @Requires(value={"modifiers != null"})
    private void appendModifiers(EnumSet<ElementModifier> enumSet) {
        ArrayList<ElementModifier> arrayList = new ArrayList<ElementModifier>(enumSet);
        Collections.sort(arrayList);
        this.appendJoin(arrayList, " ");
    }

    @Requires(value={"rootType != null"})
    private void appendPackageDeclaration(TypeModel typeModel) {
        String string = ClassName.getPackageName(typeModel.getName().getSemiQualifiedName());
        if (!string.isEmpty()) {
            this.append("package ");
            this.append(string);
            this.append(";");
            this.appendEndOfLine();
        }
    }

    @Requires(value={"rootType != null", "rootType.getEnclosingElement() == null"})
    private void appendImportStatements(TypeModel typeModel) {
        for (String string : typeModel.getImportNames()) {
            this.append("import ");
            this.append(string);
            this.append(";");
            this.appendEndOfLine();
        }
    }

    @Requires(value={"variable != null"})
    private void appendVariableDeclaration(VariableModel variableModel) {
        this.appendVariableDeclaration(variableModel, null);
    }

    @Requires(value={"variable != null"})
    private void appendVariableDeclaration(VariableModel variableModel, String string) {
        this.appendModifiers(variableModel.getModifiers());
        this.append(" ");
        if (string == null) {
            this.append(variableModel.getType().getDeclaredName());
        } else {
            this.append(string);
        }
        this.append(" ");
        this.append(variableModel.getSimpleName());
    }

    @Requires(value={"method != null"})
    private void appendMethodDeclaration(MethodModel methodModel) {
        Object object;
        EnumSet<ElementModifier> enumSet = methodModel.getModifiers();
        if (this.type.getKind().isInterfaceType()) {
            enumSet.remove((Object)ElementModifier.ABSTRACT);
        }
        this.appendModifiers(enumSet);
        this.append(" ");
        this.appendGenericSignature(methodModel.getTypeParameters());
        if (methodModel.isConstructor()) {
            this.append(" ");
            this.append(methodModel.getEnclosingElement().getSimpleName());
        } else {
            this.append(" ");
            this.append(methodModel.getReturnType().getDeclaredName());
            this.append(" ");
            this.append(methodModel.getSimpleName());
        }
        this.append("(");
        Iterator<? extends VariableModel> iterator = methodModel.getParameters().iterator();
        if (iterator.hasNext()) {
            object = iterator.next();
            while (iterator.hasNext()) {
                this.appendVariableDeclaration((VariableModel)object);
                this.append(", ");
                object = iterator.next();
            }
            if (!methodModel.isVariadic()) {
                this.appendVariableDeclaration((VariableModel)object);
            } else {
                String string = VARIADIC_REGEX.matcher(((VariableModel)object).getType().getDeclaredName()).replaceFirst("...");
                this.appendVariableDeclaration((VariableModel)object, string);
            }
        }
        this.append(")");
        object = methodModel.getExceptions();
        if (object.size() != 0) {
            this.append(" throws ");
            this.appendJoin((Collection<?>)object, ", ");
        }
    }

    @Requires(value={"method != null", "method.isConstructor()"})
    private void appendConstructorCode(MethodModel methodModel) {
        TypeModel typeModel = Elements.getTypeOf(methodModel);
        List<? extends TypeName> list = typeModel.getSuperArguments();
        if (!list.isEmpty()) {
            this.append("super(");
            Iterator<? extends TypeName> iterator = list.iterator();
            while (true) {
                this.append(ContractWriter.getDefaultValue(iterator.next()));
                if (!iterator.hasNext()) break;
                this.append(", ");
            }
            this.append(");");
        }
    }

    @Requires(value={"method != null", "!method.isConstructor()"})
    private void appendNormalMethodCode(MethodModel methodModel) {
        TypeName typeName = methodModel.getReturnType();
        if (!typeName.getDeclaredName().equals("void")) {
            this.append("return ");
            this.append(ContractWriter.getDefaultValue(typeName));
            this.append(";");
        }
    }

    @Requires(value={"contract != null"})
    private void appendContractSignature(ContractMethodModel contractMethodModel) {
        List<Long> list;
        MethodModel methodModel;
        this.append("@");
        this.append(CONTRACT_METHOD_SIGNATURE);
        this.append("(");
        this.append("kind = ");
        this.append(CONTRACT_KIND);
        this.append(".");
        this.append(contractMethodModel.getContractKind().name());
        int n = contractMethodModel.getId();
        if (n != -1) {
            this.append(", id = ");
            this.append(Integer.toString(n));
        }
        if ((methodModel = contractMethodModel.getContractedMethod()) != null) {
            this.append(", target = \"");
            this.append(methodModel.getSimpleName());
            this.append("\"");
        }
        if ((list = contractMethodModel.getLineNumbers()) != null && !list.isEmpty()) {
            this.append(", lines = { ");
            Iterator<Long> iterator = list.iterator();
            while (true) {
                Long l;
                this.append(Long.toString((l = iterator.next()) == null ? -1L : l));
                if (!iterator.hasNext()) break;
                this.append(", ");
            }
            this.append(" }");
        }
        this.append(")");
        this.appendEndOfLine();
    }

    @Override
    public void visitVariable(VariableModel variableModel) {
        if (variableModel.getKind() == ElementKind.CONSTANT) {
            return;
        }
        this.appendVariableDeclaration(variableModel);
        if (variableModel.getModifiers().contains((Object)ElementModifier.FINAL)) {
            this.append(" = ");
            String string = ContractWriter.getDefaultValue(variableModel.getType());
            this.append("\"dummy\".equals(\"dummy\") ? ");
            this.append(string);
            this.append(":");
            this.append(string);
        }
        this.append(";");
        this.appendEndOfLine();
    }

    @Override
    public void visitContractMethod(ContractMethodModel contractMethodModel) {
        this.appendContractSignature(contractMethodModel);
        this.appendMethodDeclaration(contractMethodModel);
        this.append(" {");
        this.appendEndOfLine();
        Object object = contractMethodModel.getSourceInfo();
        if (this.debugTrace && contractMethodModel.getContractKind() == ContractKind.HELPER) {
            this.append("com.google.java.contract.core.util.DebugUtils.contractInfo(");
            this.append("\"checking contract: ");
            this.append(ContractWriter.quoteString(((TypeModel)contractMethodModel.getEnclosingElement()).getName().getQualifiedName()));
            this.append(".");
            this.append(ContractWriter.quoteString(contractMethodModel.getSimpleName()));
            if (object instanceof AnnotationSourceInfo) {
                AnnotationSourceInfo annotationSourceInfo = (AnnotationSourceInfo)object;
                this.append(": ");
                this.append(ContractWriter.quoteString(((Object)annotationSourceInfo.getAnnotationValue()).toString()));
            }
            this.append("\");");
            this.appendEndOfLine();
        }
        this.append(contractMethodModel.getCode());
        if (object == null) {
            this.appendEndOfLine();
        } else {
            this.appendEndOfLine(object);
        }
        this.append("}");
        this.appendEndOfLine();
    }

    @Override
    public void visitMethod(MethodModel methodModel) {
        if (this.type.getKind() == ElementKind.ENUM && methodModel.getSimpleName().equals("<init>")) {
            return;
        }
        this.appendMethodDeclaration(methodModel);
        if (this.type.getKind().isInterfaceType() || methodModel.getModifiers().contains((Object)ElementModifier.ABSTRACT)) {
            this.append(";");
        } else {
            this.append(" {");
            this.appendEndOfLine();
            if (methodModel.isConstructor()) {
                this.appendConstructorCode(methodModel);
            } else {
                this.appendNormalMethodCode(methodModel);
            }
            this.appendEndOfLine();
            this.append("}");
        }
        this.appendEndOfLine();
    }

    @Override
    public void visitType(TypeModel typeModel) {
        if (this.type != null) {
            ContractWriter contractWriter = new ContractWriter(this);
            contractWriter.visitType(typeModel);
            this.lineNumber = contractWriter.lineNumber;
            return;
        }
        this.type = typeModel;
        if (this.isRootClass) {
            this.appendPackageDeclaration(typeModel);
            this.appendImportStatements(typeModel);
        }
        this.appendTypeDeclaration(typeModel);
        this.appendSuperclass(typeModel);
        this.appendInterfaces(typeModel);
        this.append(" {");
        this.appendEndOfLine();
        if (typeModel.getKind() == ElementKind.ENUM) {
            this.appendEnumSkeleton(typeModel);
        }
        this.scan(typeModel.getEnclosedElements());
        this.append("}");
        this.appendEndOfLine();
    }

    @Requires(value={"kind != null"})
    private String getKeywordForType(ElementKind elementKind) {
        String string = null;
        switch (this.type.getKind()) {
            case CLASS: {
                string = "class";
                break;
            }
            case ENUM: {
                string = "enum";
                break;
            }
            case INTERFACE: {
                string = "interface";
                break;
            }
            case ANNOTATION_TYPE: {
                string = "@interface";
            }
        }
        return string;
    }

    @Requires(value={"type != null"})
    private void appendEnumSkeleton(TypeModel typeModel) {
        List<VariableModel> list = Elements.filter(typeModel.getEnclosedElements(), VariableModel.class, ElementKind.CONSTANT);
        Iterator<VariableModel> iterator = list.iterator();
        if (iterator.hasNext()) {
            while (true) {
                this.append(iterator.next().getSimpleName());
                if (!iterator.hasNext()) break;
                this.append(", ");
            }
        }
        this.append(";");
        this.appendEndOfLine();
        this.append("private ");
        this.append(typeModel.getSimpleName());
        this.append("() {");
        this.appendEndOfLine();
        this.append("}");
        this.appendEndOfLine();
    }

    private void appendTypeDeclaration(TypeModel typeModel) {
        String string = this.getKeywordForType(typeModel.getKind());
        if (string == null) {
            throw new IllegalArgumentException();
        }
        EnumSet<ElementModifier> enumSet = typeModel.getModifiers();
        switch (typeModel.getKind()) {
            case INTERFACE: {
                enumSet.remove((Object)ElementModifier.ABSTRACT);
                break;
            }
            case ANNOTATION_TYPE: {
                enumSet.remove((Object)ElementModifier.ABSTRACT);
                enumSet.remove((Object)ElementModifier.STATIC);
            }
        }
        this.appendModifiers(enumSet);
        this.append(" ");
        this.append(string);
        this.append(" ");
        String string2 = typeModel.getSimpleName();
        this.append(string2);
        this.appendGenericSignature(typeModel.getTypeParameters());
    }

    @Requires(value={"type != null"})
    private void appendSuperclass(TypeModel typeModel) {
        if (typeModel.getKind() != ElementKind.ENUM && typeModel.getSuperclass() != null) {
            this.append(" extends ");
            this.append(typeModel.getSuperclass().getDeclaredName());
        }
    }

    @Requires(value={"type != null", "type.getKind() != ElementKind.ANNOTATION_TYPE|| type.getInterfaces().size() == 1"})
    private void appendInterfaces(TypeModel typeModel) {
        Set<? extends ClassName> set;
        ElementKind elementKind = typeModel.getKind();
        if (elementKind != ElementKind.ANNOTATION_TYPE && (set = typeModel.getInterfaces()).size() != 0) {
            if (elementKind == ElementKind.INTERFACE) {
                this.append(" extends ");
            } else {
                this.append(" implements ");
            }
            this.appendJoin(set, ", ");
        }
    }

    @Requires(value={"s != null"})
    @Ensures(value={"result != null"})
    public static String quoteString(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public Map<Long, ?> getLineNumberMap() {
        return this.lineNumberMap;
    }

    @Ensures(value={"result != null"})
    public byte[] toByteArray() {
        return this.output.toByteArray();
    }
}

