/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;

@Invariant(value={"element != null", "annotationMirror != null", "annotationValue != null", "code != null", "!code.isEmpty()", "!code.contains(null)"})
public class AnnotationSourceInfo {
    protected Element element;
    protected AnnotationMirror annotationMirror;
    protected AnnotationValue annotationValue;
    protected List<String> code;

    @Requires(value={"element != null", "annotationMirror != null", "annotationValue != null", "code != null", "!code.isEmpty()"})
    @Ensures(value={"element == getElement()", "annotationMirror == getAnnotationMirror()", "annotationValue == getAnnotationValue()", "code.equals(getCode())"})
    public AnnotationSourceInfo(Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue, List<String> list) {
        this.element = element;
        this.annotationMirror = annotationMirror;
        this.annotationValue = annotationValue;
        this.code = new ArrayList<String>(list);
    }

    @Ensures(value={"result != null"})
    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    @Ensures(value={"result != null"})
    public AnnotationValue getAnnotationValue() {
        return this.annotationValue;
    }

    @Ensures(value={"result != null", "!result.isEmpty()"})
    public List<String> getCode() {
        return this.code;
    }

    @Ensures(value={"result != null"})
    public Element getElement() {
        return this.element;
    }
}

