/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.samtools.BAMRecord;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMUtils;
import org.broadinstitute.sting.gatk.walkers.bqsr.EventType;
import org.broadinstitute.sting.utils.NGSPlatform;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public class GATKSAMRecord
extends BAMRecord {
    public static final String REDUCED_READ_CONSENSUS_TAG = "RR";
    public static final String REDUCED_READ_ORIGINAL_ALIGNMENT_START_SHIFT = "OP";
    public static final String REDUCED_READ_ORIGINAL_ALIGNMENT_END_SHIFT = "OE";
    public static final String BQSR_BASE_INSERTION_QUALITIES = "BI";
    public static final String BQSR_BASE_DELETION_QUALITIES = "BD";
    private String mReadString = null;
    private GATKSAMReadGroupRecord mReadGroup = null;
    private byte[] reducedReadCounts = null;
    private boolean retrievedReadGroup = false;
    private boolean retrievedReduceReadCounts = false;
    private Map<Object, Object> temporaryAttributes;

    public GATKSAMRecord(SAMFileHeader header) {
        this(new SAMRecord(header));
    }

    public GATKSAMRecord(SAMRecord read) {
        super(read.getHeader(), read.getMateReferenceIndex().intValue(), read.getAlignmentStart(), read.getReadName() != null ? (short)read.getReadNameLength() : (short)0, (short)read.getMappingQuality(), 0, read.getCigarLength(), read.getFlags(), read.getReadLength(), read.getMateReferenceIndex().intValue(), read.getMateAlignmentStart(), read.getInferredInsertSize(), null);
        SAMReadGroupRecord samRG = read.getReadGroup();
        this.clearAttributes();
        if (samRG != null) {
            GATKSAMReadGroupRecord rg = new GATKSAMReadGroupRecord(samRG);
            this.setReadGroup(rg);
        }
    }

    public GATKSAMRecord(SAMFileHeader header, int referenceSequenceIndex, int alignmentStart, short readNameLength, short mappingQuality, int indexingBin, int cigarLen, int flags, int readLen, int mateReferenceSequenceIndex, int mateAlignmentStart, int insertSize, byte[] variableLengthBlock) {
        super(header, referenceSequenceIndex, alignmentStart, readNameLength, mappingQuality, indexingBin, cigarLen, flags, readLen, mateReferenceSequenceIndex, mateAlignmentStart, insertSize, variableLengthBlock);
    }

    public String getReadString() {
        if (this.mReadString == null) {
            this.mReadString = super.getReadString();
        }
        return this.mReadString;
    }

    public void setReadString(String s) {
        super.setReadString(s);
        this.mReadString = s;
    }

    public GATKSAMReadGroupRecord getReadGroup() {
        if (!this.retrievedReadGroup) {
            SAMReadGroupRecord tempReadGroup = super.getReadGroup();
            this.mReadGroup = tempReadGroup == null ? null : new GATKSAMReadGroupRecord(tempReadGroup);
            this.retrievedReadGroup = true;
        }
        return this.mReadGroup;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GATKSAMRecord)) {
            return false;
        }
        return super.equals(o);
    }

    public void setBaseQualities(byte[] quals, EventType errorModel) {
        switch (errorModel) {
            case BASE_SUBSTITUTION: {
                this.setBaseQualities(quals);
                break;
            }
            case BASE_INSERTION: {
                this.setAttribute(BQSR_BASE_INSERTION_QUALITIES, SAMUtils.phredToFastq((byte[])quals));
                break;
            }
            case BASE_DELETION: {
                this.setAttribute(BQSR_BASE_DELETION_QUALITIES, SAMUtils.phredToFastq((byte[])quals));
                break;
            }
            default: {
                throw new ReviewedStingException("Unrecognized Base Recalibration type: " + (Object)((Object)errorModel));
            }
        }
    }

    public byte[] getBaseQualities(EventType errorModel) {
        switch (errorModel) {
            case BASE_SUBSTITUTION: {
                return this.getBaseQualities();
            }
            case BASE_INSERTION: {
                return this.getBaseInsertionQualities();
            }
            case BASE_DELETION: {
                return this.getBaseDeletionQualities();
            }
        }
        throw new ReviewedStingException("Unrecognized Base Recalibration type: " + (Object)((Object)errorModel));
    }

    public boolean hasBaseIndelQualities() {
        return this.getAttribute(BQSR_BASE_INSERTION_QUALITIES) != null || this.getAttribute(BQSR_BASE_DELETION_QUALITIES) != null;
    }

    public byte[] getBaseInsertionQualities() {
        byte[] quals = SAMUtils.fastqToPhred((String)this.getStringAttribute(BQSR_BASE_INSERTION_QUALITIES));
        if (quals == null) {
            quals = new byte[this.getBaseQualities().length];
            Arrays.fill(quals, (byte)45);
            this.setBaseQualities(quals, EventType.BASE_INSERTION);
        }
        return quals;
    }

    public byte[] getBaseDeletionQualities() {
        byte[] quals = SAMUtils.fastqToPhred((String)this.getStringAttribute(BQSR_BASE_DELETION_QUALITIES));
        if (quals == null) {
            quals = new byte[this.getBaseQualities().length];
            Arrays.fill(quals, (byte)45);
            this.setBaseQualities(quals, EventType.BASE_DELETION);
        }
        return quals;
    }

    public NGSPlatform getNGSPlatform() {
        return this.getReadGroup().getNGSPlatform();
    }

    public void setReadGroup(GATKSAMReadGroupRecord readGroup) {
        this.mReadGroup = readGroup;
        this.retrievedReadGroup = true;
        this.setAttribute("RG", this.mReadGroup.getId());
    }

    public byte[] getReducedReadCounts() {
        if (!this.retrievedReduceReadCounts) {
            this.reducedReadCounts = this.getByteArrayAttribute(REDUCED_READ_CONSENSUS_TAG);
            this.retrievedReduceReadCounts = true;
        }
        return this.reducedReadCounts;
    }

    public boolean isReducedRead() {
        return this.getReducedReadCounts() != null;
    }

    public final byte getReducedCount(int i) {
        byte firstCount = this.getReducedReadCounts()[0];
        byte offsetCount = this.getReducedReadCounts()[i];
        return i == 0 ? firstCount : (byte)Math.min(firstCount + offsetCount, 127);
    }

    public boolean containsTemporaryAttribute(Object key) {
        if (this.temporaryAttributes != null) {
            return this.temporaryAttributes.containsKey(key);
        }
        return false;
    }

    public Object setTemporaryAttribute(Object key, Object value) {
        if (this.temporaryAttributes == null) {
            this.temporaryAttributes = new HashMap<Object, Object>();
        }
        return this.temporaryAttributes.put(key, value);
    }

    public Object getTemporaryAttribute(Object key) {
        if (this.temporaryAttributes != null) {
            return this.temporaryAttributes.get(key);
        }
        return null;
    }

    public boolean isEmpty() {
        return super.getReadBases() == null || super.getReadLength() == 0;
    }

    public GATKSAMRecord simplify() {
        GATKSAMReadGroupRecord rg = this.getReadGroup();
        this.clearAttributes();
        this.setReadGroup(rg);
        return this;
    }

    public int getSoftStart() {
        CigarElement cigarElement;
        int start = this.getUnclippedStart();
        Iterator i$ = this.getCigar().getCigarElements().iterator();
        while (i$.hasNext() && (cigarElement = (CigarElement)i$.next()).getOperator() == CigarOperator.HARD_CLIP) {
            start += cigarElement.getLength();
        }
        return start;
    }

    public int getSoftEnd() {
        int stop = this.getUnclippedStart();
        if (ReadUtils.readIsEntirelyInsertion(this)) {
            return stop;
        }
        int shift = 0;
        CigarOperator lastOperator = null;
        for (CigarElement cigarElement : this.getCigar().getCigarElements()) {
            stop += shift;
            lastOperator = cigarElement.getOperator();
            if (cigarElement.getOperator().consumesReferenceBases() || cigarElement.getOperator() == CigarOperator.SOFT_CLIP || cigarElement.getOperator() == CigarOperator.HARD_CLIP) {
                shift = cigarElement.getLength();
                continue;
            }
            shift = 0;
        }
        return lastOperator == CigarOperator.HARD_CLIP ? stop - 1 : stop + shift - 1;
    }

    public int getOriginalAlignmentStart() {
        int originalAlignmentStart = this.getUnclippedStart();
        Integer alignmentShift = (Integer)this.getAttribute(REDUCED_READ_ORIGINAL_ALIGNMENT_START_SHIFT);
        if (alignmentShift != null) {
            originalAlignmentStart += alignmentShift.intValue();
        }
        return originalAlignmentStart;
    }

    public int getOriginalAlignmentEnd() {
        int originalAlignmentEnd = this.getUnclippedEnd();
        Integer alignmentShift = (Integer)this.getAttribute(REDUCED_READ_ORIGINAL_ALIGNMENT_END_SHIFT);
        if (alignmentShift != null) {
            originalAlignmentEnd -= alignmentShift.intValue();
        }
        return originalAlignmentEnd;
    }

    public static GATKSAMRecord emptyRead(GATKSAMRecord read) {
        GATKSAMRecord emptyRead = new GATKSAMRecord(read.getHeader(), read.getReferenceIndex(), 0, 0, 0, 0, 0, read.getFlags(), 0, read.getMateReferenceIndex(), read.getMateAlignmentStart(), read.getInferredInsertSize(), null);
        emptyRead.setCigarString("");
        emptyRead.setReadBases(new byte[0]);
        emptyRead.setBaseQualities(new byte[0]);
        GATKSAMReadGroupRecord samRG = read.getReadGroup();
        emptyRead.clearAttributes();
        if (samRG != null) {
            GATKSAMReadGroupRecord rg = new GATKSAMReadGroupRecord(samRG);
            emptyRead.setReadGroup(rg);
        }
        return emptyRead;
    }

    public Object clone() throws CloneNotSupportedException {
        GATKSAMRecord clone = (GATKSAMRecord)((Object)super.clone());
        if (this.temporaryAttributes != null) {
            for (Object attribute : this.temporaryAttributes.keySet()) {
                clone.setTemporaryAttribute(attribute, this.temporaryAttributes.get(attribute));
            }
        }
        return clone;
    }
}

