/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import com.google.java.contract.Requires;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineReader;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.refdata.ReferenceDependentFeatureCodec;
import org.broadinstitute.sting.gatk.refdata.tracks.FeatureManager;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.interval.IntervalUtils;

public final class IntervalBinding<T extends Feature> {
    private RodBinding<T> featureIntervals;
    private String stringIntervals;

    @Requires(value={"type != null", "rawName != null", "source != null", "tribbleType != null", "tags != null"})
    public IntervalBinding(Class<T> type, String rawName, String source, String tribbleType, Tags tags) {
        this.featureIntervals = new RodBinding<T>(type, rawName, source, tribbleType, tags);
    }

    @Requires(value={"intervalArgument != null"})
    public IntervalBinding(String intervalArgument) {
        this.stringIntervals = intervalArgument;
    }

    public String getSource() {
        if (this.featureIntervals != null) {
            return this.featureIntervals.getSource();
        }
        return this.stringIntervals;
    }

    public List<GenomeLoc> getIntervals(GenomeAnalysisEngine toolkit) {
        ArrayList<GenomeLoc> intervals;
        if (this.featureIntervals != null) {
            intervals = new ArrayList();
            FeatureCodec codec = new FeatureManager().getByName(this.featureIntervals.getTribbleType()).getCodec();
            if (codec instanceof ReferenceDependentFeatureCodec) {
                ((ReferenceDependentFeatureCodec)codec).setGenomeLocParser(toolkit.getGenomeLocParser());
            }
            try {
                FileInputStream fis = new FileInputStream(new File(this.featureIntervals.getSource()));
                AsciiLineReader lineReader = new AsciiLineReader((InputStream)fis);
                codec.readHeader((LineReader)lineReader);
                String line = lineReader.readLine();
                while (line != null) {
                    Feature feature = codec.decodeLoc(line);
                    if (feature == null) {
                        throw new UserException.MalformedFile(this.featureIntervals.getSource(), "Couldn't parse line '" + line + "'");
                    }
                    intervals.add(toolkit.getGenomeLocParser().createGenomeLoc(feature));
                    line = lineReader.readLine();
                }
            }
            catch (Exception e) {
                throw new UserException.MalformedFile(this.featureIntervals.getSource(), "Problem reading the interval file", e);
            }
        } else {
            intervals = IntervalUtils.parseIntervalArguments(toolkit.getGenomeLocParser(), this.stringIntervals);
        }
        return intervals;
    }

    public String toString() {
        return this.getSource();
    }
}

