/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCodeIterator;
import ch.epfl.lamp.fjbg.JConstantPool;
import ch.epfl.lamp.fjbg.JLocalVariable;
import ch.epfl.lamp.fjbg.JMethod;
import ch.epfl.lamp.fjbg.JMethodType;
import ch.epfl.lamp.fjbg.JOpcode;
import ch.epfl.lamp.fjbg.JReferenceType;
import ch.epfl.lamp.fjbg.JType;
import ch.epfl.lamp.util.ByteArray;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class JCode {
    protected boolean frozen = false;
    protected final FJBGContext context;
    protected final JMethod owner;
    protected final ByteArray codeArray;
    protected final LinkedList exceptionHandlers = new LinkedList();
    protected final JConstantPool pool;
    protected final ArrayList offsetToPatch = new ArrayList();
    protected static int UNKNOWN_STACK_SIZE = Integer.MIN_VALUE;
    protected int maxStackSize = UNKNOWN_STACK_SIZE;
    protected int[] stackProduction = null;
    protected int[] stackSizes;
    protected final LinkedList attributes = new LinkedList();
    protected int[] lineNumbers = null;

    protected JCode(FJBGContext context, JClass clazz, JMethod owner) {
        this.context = context;
        this.pool = clazz.getConstantPool();
        this.owner = owner;
        this.codeArray = new ByteArray();
    }

    protected JCode(FJBGContext context, JClass clazz, JMethod owner, DataInputStream stream) throws IOException {
        this.context = context;
        this.pool = clazz.getConstantPool();
        this.owner = owner;
        int size2 = stream.readInt();
        this.codeArray = new ByteArray(stream, size2);
    }

    public int getPC() {
        return this.codeArray.getSize();
    }

    public int getSize() {
        return this.codeArray.getSize();
    }

    public JMethod getOwner() {
        return this.owner;
    }

    public int getMaxStackSize() {
        if (this.maxStackSize == UNKNOWN_STACK_SIZE) {
            this.maxStackSize = this.computeMaxStackSize();
        }
        return this.maxStackSize;
    }

    public void freeze() throws OffsetTooBigException {
        assert (!this.frozen);
        this.patchAllOffset();
        this.codeArray.freeze();
        this.frozen = true;
    }

    public void addAttribute(JAttribute attr) {
        this.attributes.add(attr);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void emit(JOpcode opcode) {
        this.setStackProduction(this.getPC(), opcode);
        this.codeArray.addU1(opcode.code);
    }

    public void emitNOP() {
        this.emit(JOpcode.NOP);
    }

    public void emitACONST_NULL() {
        this.emit(JOpcode.ACONST_NULL);
    }

    public void emitICONST_M1() {
        this.emit(JOpcode.ICONST_M1);
    }

    public void emitICONST_0() {
        this.emit(JOpcode.ICONST_0);
    }

    public void emitICONST_1() {
        this.emit(JOpcode.ICONST_1);
    }

    public void emitICONST_2() {
        this.emit(JOpcode.ICONST_2);
    }

    public void emitICONST_3() {
        this.emit(JOpcode.ICONST_3);
    }

    public void emitICONST_4() {
        this.emit(JOpcode.ICONST_4);
    }

    public void emitICONST_5() {
        this.emit(JOpcode.ICONST_5);
    }

    public void emitLCONST_0() {
        this.emit(JOpcode.LCONST_0);
    }

    public void emitLCONST_1() {
        this.emit(JOpcode.LCONST_1);
    }

    public void emitFCONST_0() {
        this.emit(JOpcode.FCONST_0);
    }

    public void emitFCONST_1() {
        this.emit(JOpcode.FCONST_1);
    }

    public void emitFCONST_2() {
        this.emit(JOpcode.FCONST_2);
    }

    public void emitDCONST_0() {
        this.emit(JOpcode.DCONST_0);
    }

    public void emitDCONST_1() {
        this.emit(JOpcode.DCONST_1);
    }

    public void emitBIPUSH(int b) {
        this.emitU1(JOpcode.BIPUSH, b);
    }

    public void emitSIPUSH(int s) {
        this.emitU2(JOpcode.SIPUSH, s);
    }

    public void emitLDC(int value) {
        this.emitU1(JOpcode.LDC, this.pool.addInteger(value));
    }

    public void emitLDC(float value) {
        this.emitU1(JOpcode.LDC, this.pool.addFloat(value));
    }

    public void emitLDC(String value) {
        this.emitU1(JOpcode.LDC, this.pool.addString(value));
    }

    public void emitLDC_W(int value) {
        this.emitU1(JOpcode.LDC_W, this.pool.addInteger(value));
    }

    public void emitLDC_W(float value) {
        this.emitU1(JOpcode.LDC_W, this.pool.addFloat(value));
    }

    public void emitLDC_W(String value) {
        this.emitU1(JOpcode.LDC_W, this.pool.addString(value));
    }

    public void emitLDC2_W(long value) {
        this.emitU2(JOpcode.LDC2_W, this.pool.addLong(value));
    }

    public void emitLDC2_W(double value) {
        this.emitU2(JOpcode.LDC2_W, this.pool.addDouble(value));
    }

    public void emitILOAD(int index) {
        this.emitU1(JOpcode.ILOAD, index);
    }

    public void emitLLOAD(int index) {
        this.emitU1(JOpcode.LLOAD, index);
    }

    public void emitFLOAD(int index) {
        this.emitU1(JOpcode.FLOAD, index);
    }

    public void emitDLOAD(int index) {
        this.emitU1(JOpcode.DLOAD, index);
    }

    public void emitALOAD(int index) {
        this.emitU1(JOpcode.ALOAD, index);
    }

    public void emitILOAD_0() {
        this.emit(JOpcode.ILOAD_0);
    }

    public void emitILOAD_1() {
        this.emit(JOpcode.ILOAD_1);
    }

    public void emitILOAD_2() {
        this.emit(JOpcode.ILOAD_2);
    }

    public void emitILOAD_3() {
        this.emit(JOpcode.ILOAD_3);
    }

    public void emitLLOAD_0() {
        this.emit(JOpcode.LLOAD_0);
    }

    public void emitLLOAD_1() {
        this.emit(JOpcode.LLOAD_1);
    }

    public void emitLLOAD_2() {
        this.emit(JOpcode.LLOAD_2);
    }

    public void emitLLOAD_3() {
        this.emit(JOpcode.LLOAD_3);
    }

    public void emitFLOAD_0() {
        this.emit(JOpcode.FLOAD_0);
    }

    public void emitFLOAD_1() {
        this.emit(JOpcode.FLOAD_1);
    }

    public void emitFLOAD_2() {
        this.emit(JOpcode.FLOAD_2);
    }

    public void emitFLOAD_3() {
        this.emit(JOpcode.FLOAD_3);
    }

    public void emitDLOAD_0() {
        this.emit(JOpcode.DLOAD_0);
    }

    public void emitDLOAD_1() {
        this.emit(JOpcode.DLOAD_1);
    }

    public void emitDLOAD_2() {
        this.emit(JOpcode.DLOAD_2);
    }

    public void emitDLOAD_3() {
        this.emit(JOpcode.DLOAD_3);
    }

    public void emitALOAD_0() {
        this.emit(JOpcode.ALOAD_0);
    }

    public void emitALOAD_1() {
        this.emit(JOpcode.ALOAD_1);
    }

    public void emitALOAD_2() {
        this.emit(JOpcode.ALOAD_2);
    }

    public void emitALOAD_3() {
        this.emit(JOpcode.ALOAD_3);
    }

    public void emitIALOAD() {
        this.emit(JOpcode.IALOAD);
    }

    public void emitLALOAD() {
        this.emit(JOpcode.LALOAD);
    }

    public void emitFALOAD() {
        this.emit(JOpcode.FALOAD);
    }

    public void emitDALOAD() {
        this.emit(JOpcode.DALOAD);
    }

    public void emitAALOAD() {
        this.emit(JOpcode.AALOAD);
    }

    public void emitBALOAD() {
        this.emit(JOpcode.BALOAD);
    }

    public void emitCALOAD() {
        this.emit(JOpcode.CALOAD);
    }

    public void emitSALOAD() {
        this.emit(JOpcode.SALOAD);
    }

    public void emitISTORE(int index) {
        this.emitU1(JOpcode.ISTORE, index);
    }

    public void emitLSTORE(int index) {
        this.emitU1(JOpcode.LSTORE, index);
    }

    public void emitFSTORE(int index) {
        this.emitU1(JOpcode.FSTORE, index);
    }

    public void emitDSTORE(int index) {
        this.emitU1(JOpcode.DSTORE, index);
    }

    public void emitASTORE(int index) {
        this.emitU1(JOpcode.ASTORE, index);
    }

    public void emitISTORE_0() {
        this.emit(JOpcode.ISTORE_0);
    }

    public void emitISTORE_1() {
        this.emit(JOpcode.ISTORE_1);
    }

    public void emitISTORE_2() {
        this.emit(JOpcode.ISTORE_2);
    }

    public void emitISTORE_3() {
        this.emit(JOpcode.ISTORE_3);
    }

    public void emitLSTORE_0() {
        this.emit(JOpcode.LSTORE_0);
    }

    public void emitLSTORE_1() {
        this.emit(JOpcode.LSTORE_1);
    }

    public void emitLSTORE_2() {
        this.emit(JOpcode.LSTORE_2);
    }

    public void emitLSTORE_3() {
        this.emit(JOpcode.LSTORE_3);
    }

    public void emitFSTORE_0() {
        this.emit(JOpcode.FSTORE_0);
    }

    public void emitFSTORE_1() {
        this.emit(JOpcode.FSTORE_1);
    }

    public void emitFSTORE_2() {
        this.emit(JOpcode.FSTORE_2);
    }

    public void emitFSTORE_3() {
        this.emit(JOpcode.FSTORE_3);
    }

    public void emitDSTORE_0() {
        this.emit(JOpcode.DSTORE_0);
    }

    public void emitDSTORE_1() {
        this.emit(JOpcode.DSTORE_1);
    }

    public void emitDSTORE_2() {
        this.emit(JOpcode.DSTORE_2);
    }

    public void emitDSTORE_3() {
        this.emit(JOpcode.DSTORE_3);
    }

    public void emitASTORE_0() {
        this.emit(JOpcode.ASTORE_0);
    }

    public void emitASTORE_1() {
        this.emit(JOpcode.ASTORE_1);
    }

    public void emitASTORE_2() {
        this.emit(JOpcode.ASTORE_2);
    }

    public void emitASTORE_3() {
        this.emit(JOpcode.ASTORE_3);
    }

    public void emitIASTORE() {
        this.emit(JOpcode.IASTORE);
    }

    public void emitLASTORE() {
        this.emit(JOpcode.LASTORE);
    }

    public void emitFASTORE() {
        this.emit(JOpcode.FASTORE);
    }

    public void emitDASTORE() {
        this.emit(JOpcode.DASTORE);
    }

    public void emitAASTORE() {
        this.emit(JOpcode.AASTORE);
    }

    public void emitBASTORE() {
        this.emit(JOpcode.BASTORE);
    }

    public void emitCASTORE() {
        this.emit(JOpcode.CASTORE);
    }

    public void emitSASTORE() {
        this.emit(JOpcode.SASTORE);
    }

    public void emitPOP() {
        this.emit(JOpcode.POP);
    }

    public void emitPOP2() {
        this.emit(JOpcode.POP2);
    }

    public void emitDUP() {
        this.emit(JOpcode.DUP);
    }

    public void emitDUP_X1() {
        this.emit(JOpcode.DUP_X1);
    }

    public void emitDUP_X2() {
        this.emit(JOpcode.DUP_X2);
    }

    public void emitDUP2() {
        this.emit(JOpcode.DUP2);
    }

    public void emitDUP2_X1() {
        this.emit(JOpcode.DUP2_X1);
    }

    public void emitDUP2_X2() {
        this.emit(JOpcode.DUP2_X2);
    }

    public void emitSWAP() {
        this.emit(JOpcode.SWAP);
    }

    public void emitIADD() {
        this.emit(JOpcode.IADD);
    }

    public void emitLADD() {
        this.emit(JOpcode.LADD);
    }

    public void emitFADD() {
        this.emit(JOpcode.FADD);
    }

    public void emitDADD() {
        this.emit(JOpcode.DADD);
    }

    public void emitISUB() {
        this.emit(JOpcode.ISUB);
    }

    public void emitLSUB() {
        this.emit(JOpcode.LSUB);
    }

    public void emitFSUB() {
        this.emit(JOpcode.FSUB);
    }

    public void emitDSUB() {
        this.emit(JOpcode.DSUB);
    }

    public void emitIMUL() {
        this.emit(JOpcode.IMUL);
    }

    public void emitLMUL() {
        this.emit(JOpcode.LMUL);
    }

    public void emitFMUL() {
        this.emit(JOpcode.FMUL);
    }

    public void emitDMUL() {
        this.emit(JOpcode.DMUL);
    }

    public void emitIDIV() {
        this.emit(JOpcode.IDIV);
    }

    public void emitLDIV() {
        this.emit(JOpcode.LDIV);
    }

    public void emitFDIV() {
        this.emit(JOpcode.FDIV);
    }

    public void emitDDIV() {
        this.emit(JOpcode.DDIV);
    }

    public void emitIREM() {
        this.emit(JOpcode.IREM);
    }

    public void emitLREM() {
        this.emit(JOpcode.LREM);
    }

    public void emitFREM() {
        this.emit(JOpcode.FREM);
    }

    public void emitDREM() {
        this.emit(JOpcode.DREM);
    }

    public void emitINEG() {
        this.emit(JOpcode.INEG);
    }

    public void emitLNEG() {
        this.emit(JOpcode.LNEG);
    }

    public void emitFNEG() {
        this.emit(JOpcode.FNEG);
    }

    public void emitDNEG() {
        this.emit(JOpcode.DNEG);
    }

    public void emitISHL() {
        this.emit(JOpcode.ISHL);
    }

    public void emitLSHL() {
        this.emit(JOpcode.LSHL);
    }

    public void emitISHR() {
        this.emit(JOpcode.ISHR);
    }

    public void emitLSHR() {
        this.emit(JOpcode.LSHR);
    }

    public void emitIUSHR() {
        this.emit(JOpcode.IUSHR);
    }

    public void emitLUSHR() {
        this.emit(JOpcode.LUSHR);
    }

    public void emitIAND() {
        this.emit(JOpcode.IAND);
    }

    public void emitLAND() {
        this.emit(JOpcode.LAND);
    }

    public void emitIOR() {
        this.emit(JOpcode.IOR);
    }

    public void emitLOR() {
        this.emit(JOpcode.LOR);
    }

    public void emitIXOR() {
        this.emit(JOpcode.IXOR);
    }

    public void emitLXOR() {
        this.emit(JOpcode.LXOR);
    }

    public void emitIINC(int index, int increment) {
        this.emitU1U1(JOpcode.IINC, index, increment);
    }

    public void emitI2L() {
        this.emit(JOpcode.I2L);
    }

    public void emitI2F() {
        this.emit(JOpcode.I2F);
    }

    public void emitI2D() {
        this.emit(JOpcode.I2D);
    }

    public void emitL2I() {
        this.emit(JOpcode.L2I);
    }

    public void emitL2F() {
        this.emit(JOpcode.L2F);
    }

    public void emitL2D() {
        this.emit(JOpcode.L2D);
    }

    public void emitF2I() {
        this.emit(JOpcode.F2I);
    }

    public void emitF2L() {
        this.emit(JOpcode.F2L);
    }

    public void emitF2D() {
        this.emit(JOpcode.F2D);
    }

    public void emitD2I() {
        this.emit(JOpcode.D2I);
    }

    public void emitD2L() {
        this.emit(JOpcode.D2L);
    }

    public void emitD2F() {
        this.emit(JOpcode.D2F);
    }

    public void emitI2B() {
        this.emit(JOpcode.I2B);
    }

    public void emitI2C() {
        this.emit(JOpcode.I2C);
    }

    public void emitI2S() {
        this.emit(JOpcode.I2S);
    }

    public void emitLCMP() {
        this.emit(JOpcode.LCMP);
    }

    public void emitFCMPL() {
        this.emit(JOpcode.FCMPL);
    }

    public void emitFCMPG() {
        this.emit(JOpcode.FCMPG);
    }

    public void emitDCMPL() {
        this.emit(JOpcode.DCMPL);
    }

    public void emitDCMPG() {
        this.emit(JOpcode.DCMPG);
    }

    protected void emitGenericIF(JOpcode opcode, Label label) throws OffsetTooBigException {
        this.emitU2(opcode, label.getOffset16(this.getPC() + 1, this.getPC()));
    }

    public void emitIFEQ(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IFEQ, label);
    }

    public void emitIFEQ(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IFEQ, targetPC - this.getPC());
    }

    public void emitIFEQ() {
        this.emitU2(JOpcode.IFEQ, 0);
    }

    public void emitIFNE(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IFNE, label);
    }

    public void emitIFNE(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IFNE, targetPC - this.getPC());
    }

    public void emitIFNE() {
        this.emitU2(JOpcode.IFNE, 0);
    }

    public void emitIFLT(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IFLT, label);
    }

    public void emitIFLT(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IFLT, targetPC - this.getPC());
    }

    public void emitIFLT() {
        this.emitU2(JOpcode.IFLT, 0);
    }

    public void emitIFGE(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IFGE, label);
    }

    public void emitIFGE(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IFGE, targetPC - this.getPC());
    }

    public void emitIFGE() {
        this.emitU2(JOpcode.IFGE, 0);
    }

    public void emitIFGT(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IFGT, label);
    }

    public void emitIFGT(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IFGT, targetPC - this.getPC());
    }

    public void emitIFGT() {
        this.emitU2(JOpcode.IFGT, 0);
    }

    public void emitIFLE(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IFLE, label);
    }

    public void emitIFLE(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IFLE, targetPC - this.getPC());
    }

    public void emitIFLE() {
        this.emitU2(JOpcode.IFLE, 0);
    }

    public void emitIF_ICMPEQ(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IF_ICMPEQ, label);
    }

    public void emitIF_ICMPEQ(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IF_ICMPEQ, targetPC - this.getPC());
    }

    public void emitIF_ICMPEQ() {
        this.emitU2(JOpcode.IF_ICMPEQ, 0);
    }

    public void emitIF_ICMPNE(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IF_ICMPNE, label);
    }

    public void emitIF_ICMPNE(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IF_ICMPNE, targetPC - this.getPC());
    }

    public void emitIF_ICMPNE() {
        this.emitU2(JOpcode.IF_ICMPNE, 0);
    }

    public void emitIF_ICMPLT(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IF_ICMPLT, label);
    }

    public void emitIF_ICMPLT(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IF_ICMPLT, targetPC - this.getPC());
    }

    public void emitIF_ICMPLT() {
        this.emitU2(JOpcode.IF_ICMPLT, 0);
    }

    public void emitIF_ICMPGE(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IF_ICMPGE, label);
    }

    public void emitIF_ICMPGE(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IF_ICMPGE, targetPC - this.getPC());
    }

    public void emitIF_ICMPGE() {
        this.emitU2(JOpcode.IF_ICMPGE, 0);
    }

    public void emitIF_ICMPGT(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IF_ICMPGT, label);
    }

    public void emitIF_ICMPGT(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IF_ICMPGT, targetPC - this.getPC());
    }

    public void emitIF_ICMPGT() {
        this.emitU2(JOpcode.IF_ICMPGT, 0);
    }

    public void emitIF_ICMPLE(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IF_ICMPLE, label);
    }

    public void emitIF_ICMPLE(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IF_ICMPLE, targetPC - this.getPC());
    }

    public void emitIF_ICMPLE() {
        this.emitU2(JOpcode.IF_ICMPLE, 0);
    }

    public void emitIF_ACMPEQ(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IF_ACMPEQ, label);
    }

    public void emitIF_ACMPEQ(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IF_ACMPEQ, targetPC - this.getPC());
    }

    public void emitIF_ACMPEQ() {
        this.emitU2(JOpcode.IF_ACMPEQ, 0);
    }

    public void emitIF_ACMPNE(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IF_ACMPNE, label);
    }

    public void emitIF_ACMPNE(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IF_ACMPNE, targetPC - this.getPC());
    }

    public void emitIF_ACMPNE() {
        this.emitU2(JOpcode.IF_ACMPNE, 0);
    }

    public void emitIFNULL(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IFNULL, label);
    }

    public void emitIFNULL(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IFNULL, targetPC - this.getPC());
    }

    public void emitIFNULL() {
        this.emitU2(JOpcode.IFNULL, 0);
    }

    public void emitIFNONNULL(Label label) throws OffsetTooBigException {
        this.emitGenericIF(JOpcode.IFNONNULL, label);
    }

    public void emitIFNONNULL(int targetPC) throws OffsetTooBigException {
        this.emitU2(JOpcode.IFNONNULL, targetPC - this.getPC());
    }

    public void emitIFNONNULL() {
        this.emitU2(JOpcode.IFNONNULL, 0);
    }

    public void emitGOTO(Label label) throws OffsetTooBigException {
        this.emitU2(JOpcode.GOTO, label.getOffset16(this.getPC() + 1, this.getPC()));
    }

    public void emitGOTO(int targetPC) throws OffsetTooBigException {
        int offset = targetPC - this.getPC();
        this.checkOffset16(offset);
        this.emitU2(JOpcode.GOTO, offset);
    }

    public void emitGOTO() {
        this.emitU2(JOpcode.GOTO, 0);
    }

    public void emitGOTO_W(Label label) {
        this.emitU4(JOpcode.GOTO_W, label.getOffset32(this.getPC() + 1, this.getPC()));
    }

    public void emitGOTO_W(int targetPC) {
        this.emitU4(JOpcode.GOTO_W, targetPC - this.getPC());
    }

    public void emitGOTO_W() {
        this.emitU4(JOpcode.GOTO_W, 0);
    }

    public void emitJSR(Label label) throws OffsetTooBigException {
        this.emitU2(JOpcode.JSR, label.getOffset16(this.getPC() + 1, this.getPC()));
    }

    public void emitJSR(int targetPC) {
        this.emitU2(JOpcode.JSR, targetPC - this.getPC());
    }

    public void emitJSR() {
        this.emitU2(JOpcode.JSR, 0);
    }

    public void emitJSR_W(Label label) {
        this.emitU4(JOpcode.JSR_W, label.getOffset32(this.getPC() + 1, this.getPC()));
    }

    public void emitJSR_W(int targetPC) {
        this.emitU4(JOpcode.JSR_W, targetPC - this.getPC());
    }

    public void emitJSR_W() {
        this.emitU4(JOpcode.JSR_W, 0);
    }

    public void emitRET(int index) {
        this.emitU1(JOpcode.RET, index);
    }

    public void emitRET(JLocalVariable var) {
        this.emitRET(var.getIndex());
    }

    public void emitTABLESWITCH(int[] keys, Label[] branches, Label defaultBranch) {
        assert (keys.length == branches.length);
        int low = keys[0];
        int high = keys[keys.length - 1];
        int instrPC = this.getPC();
        this.setStackProduction(instrPC, JOpcode.TABLESWITCH);
        this.codeArray.addU1(170);
        while (this.getPC() % 4 != 0) {
            this.codeArray.addU1(0);
        }
        this.codeArray.addU4(defaultBranch.getOffset32(this.getPC(), instrPC));
        this.codeArray.addU4(low);
        this.codeArray.addU4(high);
        for (int i = 0; i < branches.length; ++i) {
            assert (keys[i] == low + i);
            this.codeArray.addU4(branches[i].getOffset32(this.getPC(), instrPC));
        }
    }

    public void emitLOOKUPSWITCH(int[] keys, Label[] branches, Label defaultBranch) {
        assert (keys.length == branches.length);
        int instrPC = this.getPC();
        this.setStackProduction(this.getPC(), JOpcode.LOOKUPSWITCH);
        this.codeArray.addU1(171);
        while (this.getPC() % 4 != 0) {
            this.codeArray.addU1(0);
        }
        this.codeArray.addU4(defaultBranch.getOffset32(this.getPC(), instrPC));
        this.codeArray.addU4(branches.length);
        for (int i = 0; i < branches.length; ++i) {
            this.codeArray.addU4(keys[i]);
            this.codeArray.addU4(branches[i].getOffset32(this.getPC(), instrPC));
        }
    }

    public void emitIRETURN() {
        this.emit(JOpcode.IRETURN);
    }

    public void emitLRETURN() {
        this.emit(JOpcode.LRETURN);
    }

    public void emitFRETURN() {
        this.emit(JOpcode.FRETURN);
    }

    public void emitDRETURN() {
        this.emit(JOpcode.DRETURN);
    }

    public void emitARETURN() {
        this.emit(JOpcode.ARETURN);
    }

    public void emitRETURN() {
        this.emit(JOpcode.RETURN);
    }

    public void emitGETSTATIC(String className, String name, JType type) {
        this.setStackProduction(this.getPC(), type.getSize());
        int index = this.pool.addFieldRef(className, name, type.getSignature());
        this.emitU2(JOpcode.GETSTATIC, index);
    }

    public void emitPUTSTATIC(String className, String name, JType type) {
        this.setStackProduction(this.getPC(), -type.getSize());
        int index = this.pool.addFieldRef(className, name, type.getSignature());
        this.emitU2(JOpcode.PUTSTATIC, index);
    }

    public void emitGETFIELD(String className, String name, JType type) {
        this.setStackProduction(this.getPC(), type.getSize() - 1);
        int index = this.pool.addFieldRef(className, name, type.getSignature());
        this.emitU2(JOpcode.GETFIELD, index);
    }

    public void emitPUTFIELD(String className, String name, JType type) {
        this.setStackProduction(this.getPC(), -(type.getSize() + 1));
        int index = this.pool.addFieldRef(className, name, type.getSignature());
        this.emitU2(JOpcode.PUTFIELD, index);
    }

    public void emitINVOKEVIRTUAL(String className, String name, JMethodType type) {
        this.setStackProduction(this.getPC(), type.getProducedStack() - 1);
        int index = this.pool.addClassMethodRef(className, name, type.getSignature());
        this.emitU2(JOpcode.INVOKEVIRTUAL, index);
    }

    public void emitINVOKESPECIAL(String className, String name, JMethodType type) {
        this.setStackProduction(this.getPC(), type.getProducedStack() - 1);
        int index = this.pool.addClassMethodRef(className, name, type.getSignature());
        this.emitU2(JOpcode.INVOKESPECIAL, index);
    }

    public void emitINVOKESTATIC(String className, String name, JMethodType type) {
        this.setStackProduction(this.getPC(), type.getProducedStack());
        int index = this.pool.addClassMethodRef(className, name, type.getSignature());
        this.emitU2(JOpcode.INVOKESTATIC, index);
    }

    public void emitINVOKEINTERFACE(String className, String name, JMethodType type) {
        this.setStackProduction(this.getPC(), type.getProducedStack() - 1);
        int index = this.pool.addInterfaceMethodRef(className, name, type.getSignature());
        this.emitU2U1U1(JOpcode.INVOKEINTERFACE, index, type.getArgsSize() + 1, 0);
    }

    public void emitNEW(String className) {
        this.emitU2(JOpcode.NEW, this.pool.addClass(className));
    }

    public void emitNEWARRAY(JType elemType) {
        this.emitU1(JOpcode.NEWARRAY, elemType.getTag());
    }

    public void emitANEWARRAY(JReferenceType elemType) {
        this.emitU2(JOpcode.ANEWARRAY, this.pool.addDescriptor(elemType));
    }

    public void emitMULTIANEWARRAY(JReferenceType elemType, int dimensions) {
        this.setStackProduction(this.getPC(), -dimensions + 1);
        this.emitU2U1(JOpcode.MULTIANEWARRAY, this.pool.addDescriptor(elemType), dimensions);
    }

    public void emitARRAYLENGTH() {
        this.emit(JOpcode.ARRAYLENGTH);
    }

    public void emitATHROW() {
        this.emit(JOpcode.ATHROW);
    }

    public void emitCHECKCAST(JReferenceType type) {
        this.emitU2(JOpcode.CHECKCAST, this.pool.addDescriptor(type));
    }

    public void emitINSTANCEOF(JReferenceType type) {
        this.emitU2(JOpcode.INSTANCEOF, this.pool.addDescriptor(type));
    }

    public void emitMONITORENTER() {
        this.emit(JOpcode.MONITORENTER);
    }

    public void emitMONITOREXIT() {
        this.emit(JOpcode.MONITOREXIT);
    }

    public void emitWIDE(JOpcode opcode, int index) {
        assert (opcode.code == 21 || opcode.code == 22 || opcode.code == 23 || opcode.code == 24 || opcode.code == 25 || opcode.code == 54 || opcode.code == 55 || opcode.code == 56 || opcode.code == 57 || opcode.code == 58 || opcode.code == 169) : "invalide opcode for WIDE: " + opcode;
        this.setStackProduction(this.getPC(), opcode);
        this.codeArray.addU1(JOpcode.WIDE.code);
        this.codeArray.addU1(opcode.code);
        this.codeArray.addU2(index);
    }

    public void emitWIDE(JOpcode opcode, int index, int constant) {
        assert (opcode.code == 132) : "invalid opcode for WIDE: " + opcode;
        this.setStackProduction(this.getPC(), opcode);
        this.codeArray.addU1(196);
        this.codeArray.addU1(opcode.code);
        this.codeArray.addU2(index);
        this.codeArray.addU2(constant);
    }

    protected void emitU1(JOpcode opcode, int i1) {
        this.setStackProduction(this.getPC(), opcode);
        this.codeArray.addU1(opcode.code);
        this.codeArray.addU1(i1);
    }

    protected void emitU1U1(JOpcode opcode, int i1, int i2) {
        this.setStackProduction(this.getPC(), opcode);
        this.codeArray.addU1(opcode.code);
        this.codeArray.addU1(i1);
        this.codeArray.addU1(i2);
    }

    protected void emitU2(JOpcode opcode, int i1) {
        this.setStackProduction(this.getPC(), opcode);
        this.codeArray.addU1(opcode.code);
        this.codeArray.addU2(i1);
    }

    protected void emitU2U1(JOpcode opcode, int i1, int i2) {
        this.setStackProduction(this.getPC(), opcode);
        this.codeArray.addU1(opcode.code);
        this.codeArray.addU2(i1);
        this.codeArray.addU1(i2);
    }

    protected void emitU2U1U1(JOpcode opcode, int i1, int i2, int i3) {
        this.setStackProduction(this.getPC(), opcode);
        this.codeArray.addU1(opcode.code);
        this.codeArray.addU2(i1);
        this.codeArray.addU1(i2);
        this.codeArray.addU1(i3);
    }

    protected void emitU4(JOpcode opcode, int i1) {
        this.setStackProduction(this.getPC(), opcode);
        this.codeArray.addU1(opcode.code);
        this.codeArray.addU4(i1);
    }

    protected int getU1(int sourcePos) {
        return this.codeArray.getU1(sourcePos);
    }

    protected int getU2(int sourcePos) {
        return this.codeArray.getU2(sourcePos);
    }

    protected int getU4(int sourcePos) {
        return this.codeArray.getU4(sourcePos);
    }

    protected int getS1(int sourcePos) {
        return this.codeArray.getS1(sourcePos);
    }

    protected int getS2(int sourcePos) {
        return this.codeArray.getS2(sourcePos);
    }

    protected int getS4(int sourcePos) {
        return this.codeArray.getS4(sourcePos);
    }

    protected int getStackProduction(int pc) {
        if (this.stackProduction == null || pc >= this.stackProduction.length) {
            return UNKNOWN_STACK_SIZE;
        }
        return this.stackProduction[pc];
    }

    protected void setStackProduction(int pc, int production) {
        if (this.stackProduction == null) {
            this.stackProduction = new int[256];
            Arrays.fill(this.stackProduction, UNKNOWN_STACK_SIZE);
        } else {
            while (pc >= this.stackProduction.length) {
                int[] newStackProduction = new int[this.stackProduction.length * 2];
                System.arraycopy(this.stackProduction, 0, newStackProduction, 0, this.stackProduction.length);
                Arrays.fill(newStackProduction, this.stackProduction.length, newStackProduction.length, UNKNOWN_STACK_SIZE);
                this.stackProduction = newStackProduction;
            }
        }
        this.stackProduction[pc] = production;
    }

    protected void setStackProduction(int pc, JOpcode opcode) {
        if (this.getStackProduction(pc) == UNKNOWN_STACK_SIZE) {
            this.setStackProduction(pc, opcode.getProducedDataSize() - opcode.getConsumedDataSize());
        }
    }

    protected int computeMaxStackSize() {
        if (this.stackSizes == null) {
            this.stackSizes = new int[this.getSize()];
            Arrays.fill(this.stackSizes, UNKNOWN_STACK_SIZE);
            this.stackSizes[0] = 0;
        }
        int size2 = this.computeMaxStackSize(0, 0, 0);
        ExceptionHandler exh2 = null;
        for (ExceptionHandler exh2 : this.exceptionHandlers) {
            int exhSize = this.computeMaxStackSize(exh2.getHandlerPC(), 1, 1);
            if (size2 >= exhSize) continue;
            size2 = exhSize;
        }
        return size2;
    }

    protected int computeMaxStackSize(int pc, int stackSize, int maxStackSize) {
        JCodeIterator iterator2 = new JCodeIterator(this, pc);
        int successors2;
        while ((successors2 = iterator2.getSuccessorCount()) != 0) {
            assert (this.stackProduction[iterator2.getPC()] != UNKNOWN_STACK_SIZE) : "unknown stack production, pc=" + iterator2.getPC() + " in method " + this.owner.getName();
            if ((stackSize += this.stackProduction[iterator2.getPC()]) > maxStackSize) {
                maxStackSize = stackSize;
            }
            int nextPC = -1;
            for (int i = 0; i < successors2; ++i) {
                int succPC = iterator2.getSuccessorPC(i);
                assert (succPC >= 0 && succPC < this.stackSizes.length) : iterator2.getPC() + ": invalid pc: " + succPC + " op: " + iterator2.getOpcode();
                if (this.stackSizes[succPC] != UNKNOWN_STACK_SIZE) continue;
                this.stackSizes[succPC] = stackSize;
                if (nextPC == -1) {
                    nextPC = succPC;
                    continue;
                }
                maxStackSize = this.computeMaxStackSize(succPC, stackSize, maxStackSize);
            }
            if (nextPC == -1) {
                return maxStackSize;
            }
            iterator2.moveTo(nextPC);
        }
        return maxStackSize;
    }

    protected void checkOffset16(int offset) throws OffsetTooBigException {
        if (offset < Short.MIN_VALUE || offset > Short.MAX_VALUE) {
            throw new OffsetTooBigException("offset too big to fit in 16 bits: " + offset);
        }
    }

    public Label newLabel() {
        return new Label();
    }

    public Label[] newLabels(int count2) {
        Label[] labels = new Label[count2];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = this.newLabel();
        }
        return labels;
    }

    protected void recordOffsetToPatch(int offsetPC, int size2, int instrPC, Label label) {
        this.offsetToPatch.add(new OffsetToPatch(offsetPC, size2, instrPC, label));
    }

    protected void patchAllOffset() throws OffsetTooBigException {
        for (OffsetToPatch offset : this.offsetToPatch) {
            int offsetValue = offset.label.getAnchor() - offset.instrPC;
            if (offset.size == 16) {
                this.checkOffset16(offsetValue);
                this.codeArray.putU2(offset.pc, offsetValue);
                continue;
            }
            this.codeArray.putU4(offset.pc, offsetValue);
        }
    }

    public void addExceptionHandler(ExceptionHandler handler2) {
        assert (!this.frozen);
        this.exceptionHandlers.add(handler2);
    }

    public void addExceptionHandler(int startPC, int endPC, int handlerPC, String catchType) {
        this.addExceptionHandler(new ExceptionHandler(startPC, endPC, handlerPC, catchType));
    }

    public void addFinallyHandler(int startPC, int endPC, int handlerPC) {
        assert (!this.frozen);
        this.addExceptionHandler(startPC, endPC, handlerPC, null);
    }

    public List getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    protected void ensureLineNumberCapacity(int endPC) {
        assert (!this.frozen);
        if (this.lineNumbers == null) {
            this.lineNumbers = new int[endPC];
            this.addAttribute(this.context.JLineNumberTableAttribute(this.owner.getOwner(), this));
        } else if (this.lineNumbers.length < endPC) {
            int[] newLN = new int[Math.max(endPC, this.lineNumbers.length * 2)];
            System.arraycopy(this.lineNumbers, 0, newLN, 0, this.lineNumbers.length);
            this.lineNumbers = newLN;
        }
    }

    public void setLineNumber(int startPC, int endPC, int line) {
        this.ensureLineNumberCapacity(endPC);
        Arrays.fill(this.lineNumbers, startPC, endPC, line);
    }

    public void setLineNumber(int instrPC, int line) {
        this.setLineNumber(instrPC, instrPC + 1, line);
    }

    public void completeLineNumber(int startPC, int endPC, int line) {
        this.ensureLineNumberCapacity(endPC);
        for (int pc = startPC; pc < endPC; ++pc) {
            if (this.lineNumbers[pc] != 0) continue;
            this.lineNumbers[pc] = line;
        }
    }

    public int[] getLineNumbers() {
        assert (this.frozen);
        if (this.lineNumbers == null) {
            return new int[0];
        }
        if (this.lineNumbers.length == this.getPC()) {
            return this.lineNumbers;
        }
        int[] trimmedLN = new int[this.getPC()];
        System.arraycopy(this.lineNumbers, 0, trimmedLN, 0, Math.min(this.lineNumbers.length, trimmedLN.length));
        return trimmedLN;
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        assert (this.frozen);
        stream.writeInt(this.getSize());
        this.codeArray.writeTo(stream);
    }

    public class ExceptionHandler {
        protected int startPC;
        protected int endPC;
        protected int handlerPC;
        protected final String catchType;
        protected final int catchTypeIndex;

        public void setStartPC(int pc) {
            this.startPC = pc;
        }

        public int getStartPC() {
            return this.startPC;
        }

        public void setEndPC(int pc) {
            this.endPC = pc;
        }

        public int getEndPC() {
            return this.endPC;
        }

        public void setHandlerPC(int pc) {
            this.handlerPC = pc;
        }

        public int getHandlerPC() {
            return this.handlerPC;
        }

        public ExceptionHandler(String catchType) {
            this(0, 0, 0, catchType);
        }

        public ExceptionHandler(int startPC, int endPC, int handlerPC, String catchType) {
            this.startPC = startPC;
            this.endPC = endPC;
            this.handlerPC = handlerPC;
            this.catchType = catchType;
            this.catchTypeIndex = catchType == null ? 0 : JCode.this.pool.addClass(catchType);
        }

        public ExceptionHandler(DataInputStream stream) throws IOException {
            this.startPC = stream.readShort();
            this.endPC = stream.readShort();
            this.handlerPC = stream.readShort();
            this.catchTypeIndex = stream.readShort();
            this.catchType = this.catchTypeIndex == 0 ? null : JCode.this.pool.lookupClass(this.catchTypeIndex);
        }

        public void writeTo(DataOutputStream stream) throws IOException {
            stream.writeShort(this.startPC);
            stream.writeShort(this.endPC);
            stream.writeShort(this.handlerPC);
            stream.writeShort(this.catchTypeIndex);
        }
    }

    protected static class OffsetToPatch {
        public final int pc;
        public final int size;
        public final int instrPC;
        public final Label label;

        public OffsetToPatch(int pc, int size2, int instrPC, Label label) {
            this.pc = pc;
            this.size = size2;
            this.instrPC = instrPC;
            this.label = label;
        }
    }

    public class Label {
        protected boolean anchored = false;
        protected int targetPC = 0;

        public void anchorToNext() {
            assert (!this.anchored);
            this.targetPC = JCode.this.getPC();
            this.anchored = true;
        }

        public int getAnchor() {
            assert (this.anchored);
            return this.targetPC;
        }

        protected int getOffset16(int pc, int instrPC) throws OffsetTooBigException {
            if (this.anchored) {
                int offset = this.targetPC - instrPC;
                JCode.this.checkOffset16(offset);
                return offset;
            }
            JCode.this.recordOffsetToPatch(pc, 16, instrPC, this);
            return 0;
        }

        protected int getOffset32(int pc, int instrPC) {
            if (this.anchored) {
                return this.targetPC - instrPC;
            }
            JCode.this.recordOffsetToPatch(pc, 32, instrPC, this);
            return 0;
        }
    }

    public static class OffsetTooBigException
    extends Exception {
        public OffsetTooBigException() {
        }

        public OffsetTooBigException(String message) {
            super(message);
        }
    }
}

