\name{smartDTR}
\alias{smartDTR}
\alias{print.smartDTR}
\alias{plot.smartDTR}
\title{Dynamic Treatment Regimen (DTR) Trial design clinical trial calculations}
\description{
Dynamic Treatment Regimen (DTR) Trial design clinical trial calculations
}
\usage{
smartDTR(mu_Barm=cbind(G1=c(30,25), G0=c(20,20)),
                     sigsq_Barm=cbind(G1=c(100,100), G0=c(100,100)),
                     nsubject=500,  Barm=c(1,3), type="continuous",  
                     sens=seq(0.5,1, by=0.1), spec=seq(0.5, 1, by=0.1),
                     pG_A1 = 0.5, pG_A2 = 0.5, pran_A1 = 0.5, 
                     pran_Barm = c(0.5, 0.5))
}
\arguments{
  \item{mu_Barm}{matrix of two named vectors of the means for the two
    Blevels (columns) for the smart DTR trial, with rows as 'G1' and 'G0'}
  \item{sigsq_Barm}{matrix of two named vectors of the variances (sigma-squared) for the two
    Blevels (columns) for the smart DTR trial, with rows as 'G1' and 'G0'}
  \item{nsubject}{total sample size for the trial}
  \item{Barm}{for the second phase of the trial, the 'B' levels for
    which the DTR means/variances apply}
  \item{type}{trial response variable type; only continuous is
    implemented currently}
  \item{sens}{range of sensitivity for smart SST calculations; (0,1]}
  \item{spec}{range of specificity for smart SST calculations; (0,1]}
  \item{pG_A1}{probability of response to therapy given assignment to A1}
  \item{pG_A2}{probability of response to therapy given assignment to A2}
  \item{pran_A1}{probability of random assignment to A1}
  \item{pran_Barm}{probability of assignment to Barms}
}
\details{
 more details on smart DTR
}
\value{
  An object of the smartDTR S3 class, with the following elements:
  \item{dtrdat: }{data.frame with sens, spec, mu, sigsq and sample size (n)
  }
}
\references{
 
  Example: Davies RB (1980) Algorithm AS 155: The Distribution of a Linear
  Combination of chi-2 Random Variables, Journal of the Royal
  Statistical Society. Series C (Applied Statistics), 29(3):323-33
}
\author{
Jun (Jessie) He, Aberaham Eyman-Casey, Jason P. Sinnwell, Mayo Clinic
}

\examples{
sst1 <- smartSST(mu_Blevel=c(G1=30, G0=20), sigsq_Blevel=c(G1=16,G0=16),
        Blevel=1, sens=seq(.6, 1, by=.1),  spec=seq(.6, 1, by=.1),
        nsubject=252)
print(sst1$sstdat, digits=2)
}

