#' plot.smartSST
#'
#' Plot for \code{smartSST} object.
#'
#' @param x an object of class \code{\link{meanSST}}
#' @param Barm explain
#' @param xtype explain
#' @param metric explain
#' @param ylim explain
#' @param mar explain here
#' @param legend.inset explain here
#' @return Nothing is returned 
#' @seealso \code{\link{meanSST}}
#' @examples
#' @author AEC
#' @name plotSmart
NULL
#> NULL

#' @rdname plot.meanSST
#' @export
#'

plot.smartSST <- function(obj, xtype = "spec", metric="mean",
                      relativeBias=FALSE, mar=c(4, 4, 4, 6),
                      legend.inset=c(-.2,0), cex.axis = .7, cex.lab=.9, ...) {
  ## verify inputs
  if(any(mar < 0) | length(mar) < 4) {
      stop("invalid vector for mar")
  }
  if(obj$Barm < 1 | obj$Barm > 8){
    stop("Invalid B Level: ", Barm)
  }
  
  if(xtype != "sens" & xtype != "spec"){
    stop("Please enter valid xtype (spec or sens): ", xtype)
  }
  if(metric != "mean" & metric != "variance") {
    stop("Please enter valid metric (mean, variance): ", metric)
  }
  if(xtype == "sens") {
      ## AEC: u-sens and u-spec to be used below in legend
      ## rather than nrow(dat)
      usens <- unique(obj$sstdat$sens)
      seqst <- min(usens)
      seqend <- max(usens)
      seqtick <- usens[2] - usens[1]      
  } else {
      uspec <- unique(obj$sstdat$spec)
      seqst <- min(uspec)
      seqend <- max(uspec)
      seqtick <- uspec[2] - uspec[1]
  }

  if(metric == "mean" & relativeBias == FALSE) {  
    title = "Expected mean of "
    BLabel = paste0("B", as.character(obj$Barm))
    metricname <- "mu"
    
    dat <- obj$sstdat[,c("sens","spec","mu_Barm")]
    colnames(dat)[ncol(dat)] <- paste0("mu_B", obj$Barm)
    par(mar=mar, xpd=TRUE)
    if(xtype == "spec"){
        interaction.plot(dat$spec, dat$sens, dat[,3],
                 xlab=expression(paste("Specificity",(pi[2]))), xtick=TRUE,
                 ylab= paste0(title, BLabel), col=c(1:nrow(dat)), lwd=2,
                 legend=FALSE, cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
        
        legend("topright", inset = legend.inset, 
               legend = c(seq(seqst, seqend, by= seqtick)), 
               lty=c(nrow(dat):1), col=c(1:nrow(dat)),
               lwd=2, title = expression(paste("Sensitivity", (pi[1]))), bty="n", cex=cex.axis)
        ## if(spec) 
    } else if(xtype == "sens") {
        interaction.plot(dat$sens, dat$spec, dat[,3],
                 xlab=expression(paste("Sensitivity",(pi[1]))), xtick=TRUE,
                 ylab= paste0(title, BLabel), col=c(1:nrow(dat)), lwd=2,
                 legend=FALSE, cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
        
        legend("topright", inset=legend.inset, 
               legend = c(seq(seqst, seqend, by=seqtick)), 
               lty=c(nrow(dat):1), col=c(1:nrow(dat)),
               lwd=2, title = expression(paste("Specificity", (pi[2]))), bty="n", cex=cex.axis)
        
    } ## if(sens)

  } ## metric == "mean" & !relativeBias

  if(metric == "variance" & relativeBias == FALSE) {
      title = "Variance of "
      BLabel = paste0("B", as.character(obj$Barm))
      dat <- obj$sstdat[,c("sens","spec","sigsq_Barm")]
      colnames(dat)[ncol(dat)] <- paste0("sigsq_B", obj$Barm)
      par(mar=mar, xpd=TRUE)
      if(xtype == "spec") {
          interaction.plot(dat$spec, dat$sens, dat[,3],
             xlab=expression(paste("Specificity",(pi[2]))), xtick = TRUE,
             ylab=paste0(title, BLabel), col=c(1:nrow(dat)), lwd=2,
             legend=FALSE,cex.lab=cex.lab,cex.axis=cex.axis, cex.main=cex.lab)
          legend("topright", inset=legend.inset, 
                 legend = c(seq(seqst,seqend,by=seqtick)),
                 lty=c(nrow(dat):1),col=c(1:nrow(dat)),
                 lwd=2,title=expression(paste("Sensitivity",(pi[1]))),bty="n",cex=cex.axis)
      } else if(xtype == "sens") {
          interaction.plot(dat$sens, dat$spec, dat[,3],
               xlab=expression(paste("Sensitivity",(pi[1]))), xtick = TRUE,
               ylab=paste0(title, BLabel), ,col=c(1:nrow(dat)),lwd=2,
               legend=FALSE,cex.lab=cex.lab,cex.axis=cex.axis, cex.main=cex.lab)
          legend("topright", inset=legend.inset, 
               legend = c(seq(seqst,seqend,by=seqtick)),
               lty=c(nrow(dat):1),col=c(1:nrow(dat)), ncol=2,lwd=2,
             title=expression(paste("Specificity",(pi[2]))),bty="n",cex=cex.axis)
    }
  } ## variance metric

  if(metric == "mean" & relativeBias == TRUE) {
    title = "Relative bias of mean "
    BLabel = paste0("B", as.character(obj$Barm))
  
    dat <- obj$sstdat[,c("sens","spec","mu_Barm", "sigsq_Barm")]
    mu_true <- ifelse(obj$Barm %in% c(1,2,5,6), obj$mu_Barm["G1"], obj$mu_Barm["G0"])
    #mu_spec1 <- dat$mu_Barm[dat$spec==1 & dat$sens == 1]
    dat$bias_Barm <- 100 * (mu_true - dat$mu_Barm)/mu_true
    colnames(dat) <- gsub("Barm", BLabel, colnames(dat))
    par(mar=mar, xpd=TRUE)
    if(xtype == "spec") {
      interaction.plot(dat$spec,dat$sens,dat[,grep("bias", colnames(dat))],
                 xlab=expression(paste("Specificity",(pi[2]))),
                 ylab=paste0("Relative bias of mean of ", BLabel, "(%)"),
                 col=c(1:nrow(dat)), lwd=2, legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
         ##,trace.label="Sensitivity")
      legend("topright",inset=legend.inset, 
               legend = c(seq(seqst,seqend,by=seqtick)),
             lty=c(nrow(dat):1),col=c(1:nrow(dat)),
         lwd=2,title=expression(paste("Sensitivity",(pi[1]))),bty="n",cex=cex.axis)
    }
    if(xtype == "sens") {
        interaction.plot(dat$sens, dat$spec,dat[,grep("bias", colnames(dat))],
                 xlab=expression(paste("Sensitivity",(pi[1]))),
                 ylab=paste0("Relative bias of mean of ", BLabel, "(%)"),col=c(1:6), lwd=2,
                 legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab,trace.label="Specificity")
       
        legend("topright", inset=legend.inset, 
               legend = c(seq(seqst,seqend,by=seqtick)),
               lty=c(nrow(dat):1),col=c(1:nrow(dat)),
        ncol=1,lwd=2,title=expression(paste("Specificity",(pi[2]))),
        bty="n",cex=cex.axis)
    }
  }
  if(metric == "variance" & relativeBias == TRUE) {
      title = "Relative bias of variance "
      BLabel = paste0("B", as.character(obj$Barm))
      
      dat <- obj$sstdat[,c("sens","spec","mu_Barm", "sigsq_Barm")]
      sigsq_true <- ifelse(obj$Barm %in% c(1,2,5,6), obj$sigsq_Barm["G1"], obj$sigsq_Barm["G0"])
      dat$bias_Barm <- 100 * (sigsq_true - dat$sigsq_Barm)/sigsq_true
      colnames(dat) <- gsub("Barm", BLabel, colnames(dat))
      par(mar=mar, xpd=TRUE)
      if(xtype == "spec") {
          interaction.plot(dat$spec,dat$sens,dat[,grep("bias", colnames(dat))],
                           xlab=expression(paste("Specificity",(pi[2]))),
                           ylab=paste0(title, BLabel, "(%)"),
                           col=c(1:6), lwd=2, legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)#,trace.label="Sensitivity")
          legend("topright",inset=legend.inset, 
                 legend = c(seq(seqst,seqend,by=seqtick)),
                 lty=c(nrow(dat):1),col=c(1:nrow(dat)),
                 lwd=2,title=expression(paste("Sensitivity",(pi[1]))),bty="n",cex=cex.axis)
      }
      if(xtype == "sens") {
          interaction.plot(dat$sens, dat$spec,dat[,grep("bias", colnames(dat))],
                           xlab=expression(paste("Sensitivity",(pi[1]))),
                           ylab=paste0(title, BLabel, "(%)"),col=c(1:6), lwd=2,
                           legend=FALSE,cex.lab=cex, cex.axis=cex.axis, cex.main=cex,trace.label="Specificity")
          
          legend("topright", inset=legend.inset, 
                 legend = c(seq(seqst,seqend,by=seqtick)),
                 lty=c(nrow(dat):1),col=c(1:nrow(dat)),
                 ncol=1,lwd=2,title=expression(paste("Specificity",(pi[2]))),
                 bty="n",cex=cex.axis)
      }
    } ## variance & relativeBias

  invisible()      
}

