##meanSST(Blevel=”B1”, mu_G0=40, mu_G1=50, pi1=seq(0.4, 1), pi2=c(0.4, 1))
## because sst is specific, all that is needed for means on B levels, and need sample size and pG_A1.
## combine mean and variance calculations
smartDTR <- function(mu_Barm=cbind(G1=c(30,25), G0=c(20,20)),
                     sigsq_Barm=cbind(G1=c(100,100), G0=c(100,100)),
                     nsubject=500,  Barm=c(1,3), type="continuous",  
                     sens=seq(0.5,1, by=0.1), spec=seq(0.5, 1, by=0.1),
                     pG_A1 = 0.5, pG_A2 = 0.5, pran_A1 = 0.5, 
                     pran_Barm = c(0.5, 0.5)) {
    
    ## to-do: validate input
    ## call smartSST for each blevel in the bgroup,
    ## use sstdat from each
    
    sst1 <- smartSST(mu_Barm[1,], sigsq_Barm[1,], nsubject=nsubject, type=type,
                     Barm=Barm[1], sens=sens, spec=spec,pG_A1=pG_A1,
                     pG_A2=pG_A2, pran_A1=pran_A1, pran_Barm=pran_Barm[1])
    sst2 <- smartSST(mu_Barm[2,], sigsq_Barm[2,], nsubject=nsubject, type=type,
                     Barm=Barm[2], sens=sens, spec=spec, pG_A1=pG_A1,
                     pG_A2=pG_A2, pran_A1=pran_A1, pran_Barm=pran_Barm[2])
    
    nA1 <- nsubject*pran_A1
    if(all(Barm %in%  c(1,3))) {
        n_B1B3 <- sst1$sstdat$n_Barm + sst2$sstdat$n_Barm
        
        n_B1G1 <- nA1 * sst1$sstdat$sens * sst1$pG_A1 * sst1$pran_Barm
        n_B1G0 <- nA1 * (1-sst1$sstdat$spec) * (1-sst1$pG_A1) * sst1$pran_Barm
        n_B3G1 <- nA1 * (1-sst2$sstdat$sens) * sst2$pG_A1 * sst2$pran_Barm
        n_B3G0 <- nA1 * (sst2$sstdat$spec) * (1-sst2$pG_A1) * sst2$pran_Barm
       
        ##mixed mean  ## JPS use mu_Barm and n_Barm from smartSST call
        mu_B1B3 <- (sst1$sstdat$n_Barm * sst1$sstdat$mu_Barm +
                    sst2$sstdat$n_Barm * sst2$sstdat$mu_Barm)/(n_B1B3)

        
        ##mixed sigmasquare
        sigsq_B1B3 <- (n_B1G1*(sigsq_Barm[1,1] + mu_Barm[1,1]^2) +
                       n_B1G0*(sigsq_Barm[1,2] + mu_Barm[1,2]^2) +
                       n_B3G1*(sigsq_Barm[2,1] + mu_Barm[2,1]^2) +
                       n_B3G0*(sigsq_Barm[2,2] + mu_Barm[2,2]^2))/n_B1B3 -
                     mu_B1B3^2
  
        dtrdat <- data.frame(sens=sst1$sstdat$sens, spec=sst1$sstdat$spec,
                     n_Barm=n_B1B3, mu_Barm=mu_B1B3,
                     sigsq_Barm=sigsq_B1B3)
    }
    if(all(Barm %in% c(1,4))) {
        n_B1B4 <- sst1$sstdat$n_Barm + sst2$sstdat$n_Barm
        
        n_B1G1 <- nA1 * sst1$sstdat$sens * sst1$pG_A1 * sst1$pran_Barm
        n_B1G0 <- nA1 * (1-sst1$sstdat$spec) * (1-sst1$pG_A1) * sst1$pran_Barm
        n_B4G1 <- nA1 * (1-sst2$sstdat$sens) * sst2$pG_A1 * sst2$pran_Barm
        n_B4G0 <- nA1 * (sst2$sstdat$spec) * (1-sst2$pG_A1) * sst2$pran_Barm

        mu_B1B4 <- (sst1$sstdat$n_Barm * sst1$sstdat$mu_Barm +
                    sst2$sstdat$n_Barm * sst2$sstdat$mu_Barm)/(n_B1B4)

        ##mixed sigmasquare
        sigsq_B1B4 <- (n_B1G1*(sigsq_Barm[1,1] + mu_Barm[1,1]^2) +
                       n_B1G0*(sigsq_Barm[2,1] + mu_Barm[2,1]^2) +
                       n_B4G1*(sigsq_Barm[1,2] + mu_Barm[1,2]^2) +
                       n_B4G0*(sigsq_Barm[2,2] + mu_Barm[2,2]^2))/n_B1B4 -
                      mu_B1B4^2
        dtrdat <- data.frame(sens=sst1$sstdat$sens, spec=sst1$sstdat$spec,
                             n_Barm=n_B1B4, mu_Barm=mu_B1B4,
                             sigsq_Barm=sigsq_B1B4)
    }
    if(all(Barm %in% c(2,4))) {
        n_B2B4 <- sst1$sstdat$n_Barm + sst2$sstdat$n_Barm
        
        n_B2G1 <- nA1 * sst1$sstdat$sens * sst1$pG_A1 * (1-sst1$pran_Barm)
        n_B2G0 <- nA1 * (1-sst1$sstdat$spec) * (1-sst1$pG_A1) * (1-sst1$pran_Barm) 
        n_B4G1 <- nA1 * (1-sst2$sstdat$sens) * sst2$pG_A1 * sst2$pran_Barm
        n_B4G0 <- nA1 * (sst2$sstdat$spec) * (1-sst2$pG_A1) * sst2$pran_Barm

        mu_B2B4 <- (sst1$sstdat$n_Barm * sst1$sstdat$mu_Barm +
                    sst2$sstdat$n_Barm * sst2$sstdat$mu_Barm)/(n_B2B4)

        ##mixed sigmasquare
        sigsq_B2B4 <- (n_B2G1*(sigsq_Barm[1,1] + mu_Barm[1,1]^2) +
                       n_B2G0*(sigsq_Barm[1,2] + mu_Barm[1,2]^2) +
                       n_B4G1*(sigsq_Barm[2,1] + mu_Barm[2,1]^2) +
                       n_B4G0*(sigsq_Barm[2,2] + mu_Barm[2,2]^2))/n_B2B4 -
                      mu_B2B4^2
        dtrdat <- data.frame(sens=sst1$sstdat$sens, spec=sst1$sstdat$spec,
                             n_Barm=n_B2B4, mu_Barm=mu_B2B4,
                             sigsq_Barm=sigsq_B2B4)

    }
    if(all(Barm %in%  c(2,3))) {
        n_B2B3 <- sst1$sstdat$n_Barm + sst2$sstdat$n_Barm
        
        n_B2G1 <- nA1 * sst1$sstdat$sens * sst1$pG_A1 * (1-sst1$pran_Barm)
        n_B2G0 <- nA1 * (1-sst1$sstdat$spec) * (1-sst1$pG_A1) * (1-sst1$pran_Barm) 
        n_B3G1 <- nA1 * (1-sst2$sstdat$sens) * sst2$pG_A1 * sst2$pran_Barm
        n_B3G0 <- nA1 * (sst2$sstdat$spec) * (1-sst2$pG_A1) * sst2$pran_Barm
       
        mu_B2B3 <- (sst1$sstdat$n_Barm * sst1$sstdat$mu_Barm +
                    sst2$sstdat$n_Barm * sst2$sstdat$mu_Barm)/(n_B2B3)

        ##mixed sigmasquare
        sigsq_B2B3 <- (n_B2G1*(sigsq_Barm[1,1] + mu_Barm[1,1]^2) +
                       n_B2G0*(sigsq_Barm[1,2] + mu_Barm[1,2]^2) +
                       n_B3G1*(sigsq_Barm[2,1] + mu_Barm[2,2]^2) +
                       n_B3G0*(sigsq_Barm[2,2] + mu_Barm[2,2]^2))/n_B2B3 -
                      mu_B2B3^2
        dtrdat <- data.frame(sens=sst1$sstdat$sens, spec=sst1$sstdat$spec,
                             n_Barm=n_B2B3, mu_Barm=mu_B2B3,
                             sigsq_Barm=sigsq_B2B3)

    }
    nA2 <- nsubject - nA1
    if(all(Barm %in% c(5,7))) {

        n_B5B7 <- sst1$sstdat$n_Barm + sst2$sstdat$n_Barm
        
        n_B5G1 <- nA2 * sst1$sstdat$sens * (1-sst1$pG_A1) * sst1$pran_Barm
        n_B5G0 <- nA2 * (1-sst1$sstdat$spec) * (sst1$pG_A1) * sst1$pran_Barm
        n_B7G1 <- nA2 * (1-sst2$sstdat$sens) * (1-sst2$pG_A1) * sst2$pran_Barm
        n_B7G0 <- nA2 * (sst2$sstdat$spec) * (sst2$pG_A1) * sst2$pran_Barm

        ##mixed mean  ## JPS use mu_Barm and n_Barm from smartSST call
        mu_B5B7 <- (sst1$sstdat$n_Barm * sst1$sstdat$mu_Barm +
                    sst2$sstdat$n_Barm * sst2$sstdat$mu_Barm)/(n_B5B7)

        ##mixed sigmasquare
        sigsq_B5B7 <- (n_B5G1*(sigsq_Barm[1,1] + mu_Barm[1,1]^2) +
                       n_B5G0*(sigsq_Barm[1,2] + mu_Barm[1,2]^2) +
                       n_B7G1*(sigsq_Barm[2,1] + mu_Barm[2,1]^2) +
                       n_B7G0*(sigsq_Barm[2,2] + mu_Barm[2,2]^2))/n_B5B7 -
                      mu_B5B7^2
        dtrdat <- data.frame(sens=sst1$sstdat$sens, spec=sst1$sstdat$spec,
                     n_Barm=n_B5B7, mu_Barm=mu_B5B7,
                     sigsq_Barm=sigsq_B5B7)

    }
    if(all(Barm %in% c(5,8))) {
        n_B5B8 <- sst1$sstdat$n_Barm + sst2$sstdat$n_Barm
        
        n_B5G1 <- nA2 * sst1$sstdat$sens * (1-sst1$pG_A1) * sst1$pran_Barm
        n_B5G0 <- nA2 * (1-sst1$sstdat$spec) * (sst1$pG_A1) * sst1$pran_Barm

        n_B8G1 <- nA2 * (1-sst2$sstdat$sens) * (1-sst2$pG_A1) * (1-sst2$pran_Barm)        
        n_B8G0 <- nA2 * (sst2$sstdat$spec) * (sst2$pG_A1) * (1-sst2$pran_Barm)
        
        ##mixed mean  ## JPS use mu_Barm and n_Barm from smartSST call
        mu_B5B8 <- (sst1$sstdat$n_Barm * sst1$sstdat$mu_Barm +
                    sst2$sstdat$n_Barm * sst2$sstdat$mu_Barm)/(n_B5B8)

        ##mixed sigmasquare
        sigsq_B5B8 <- (n_B5G1*(sigsq_Barm[1,1] + mu_Barm[1,1]^2) +
                       n_B5G0*(sigsq_Barm[1,2] + mu_Barm[1,2]^2) +
                       n_B8G1*(sigsq_Barm[2,1] + mu_Barm[2,1]^2) +
                       n_B8G0*(sigsq_Barm[2,2] + mu_Barm[2,2]^2))/n_B5B8 -
                      mu_B5B8^2
        dtrdat <- data.frame(sens=sst1$sstdat$sens, spec=sst1$sstdat$spec,
                     n_Barm=n_B5B8, mu_Barm=mu_B5B8,
                     sigsq_Barm=sigsq_B5B8)
    }
    if(all(Barm %in% c(6,8))) {
        n_B6B8 <- sst1$sstdat$n_Barm + sst2$sstdat$n_Barm
        
        n_B6G1 <- nA2 * sst1$sstdat$sens * (1-sst1$pG_A1) * (1-sst1$pran_Barm)
        n_B6G0 <- nA2 * (1-sst1$sstdat$spec) * (sst1$pG_A1) * (1-sst1$pran_Barm)

        n_B8G1 <- nA2 * (1-sst2$sstdat$sens) * (1-sst2$pG_A1) * (1-sst2$pran_Barm)        
        n_B8G0 <- nA2 * (sst2$sstdat$spec) * (sst2$pG_A1) * (1-sst2$pran_Barm)
        
        ##mixed mean  ## JPS use mu_Barm and n_Barm from smartSST call
        mu_B6B8 <- (sst1$sstdat$n_Barm * sst1$sstdat$mu_Barm +
                    sst2$sstdat$n_Barm * sst2$sstdat$mu_Barm)/(n_B6B8)

        ##mixed sigmasquare
        sigsq_B6B8 <- (n_B6G1*(sigsq_Barm[1,1] + mu_Barm[1,1]^2) +
                       n_B6G0*(sigsq_Barm[1,2] + mu_Barm[1,2]^2) +
                       n_B8G1*(sigsq_Barm[2,1] + mu_Barm[2,1]^2) +
                       n_B8G0*(sigsq_Barm[2,2] + mu_Barm[2,2]^2))/n_B6B8 -
                      mu_B6B8^2
        dtrdat <- data.frame(sens=sst1$sstdat$sens, spec=sst1$sstdat$spec,
                     n_Barm=n_B6B8, mu_Barm=mu_B6B8,
                     sigsq_Barm=sigsq_B6B8)

    }
     if(all(Barm %in% c(6,8))) {
        n_B6B8 <- sst1$sstdat$n_Barm + sst2$sstdat$n_Barm
        
        n_B6G1 <- nA2 * sst1$sstdat$sens * (1-sst1$pG_A1) * (1-sst1$pran_Barm)
        n_B6G0 <- nA2 * (1-sst1$sstdat$spec) * (sst1$pG_A1) * (1-sst1$pran_Barm)

        n_B8G1 <- nA2 * (1-sst2$sstdat$sens) * (1-sst2$pG_A1) * (1-sst2$pran_Barm)        
        n_B8G0 <- nA2 * (sst2$sstdat$spec) * (sst2$pG_A1) * (1-sst2$pran_Barm)
        
        ##mixed mean  ## JPS use mu_Barm and n_Barm from smartSST call
        mu_B6B8 <- (sst1$sstdat$n_Barm * sst1$sstdat$mu_Barm +
                    sst2$sstdat$n_Barm * sst2$sstdat$mu_Barm)/(n_B6B8)

        ##mixed sigmasquare
        sigsq_B6B8 <- (n_B6G1*(sigsq_Barm[1,1] + mu_Barm[1,1]^2) +
                       n_B6G0*(sigsq_Barm[1,2] + mu_Barm[1,2]^2) +
                       n_B8G1*(sigsq_Barm[2,1] + mu_Barm[2,1]^2) +
                       n_B8G0*(sigsq_Barm[2,2] + mu_Barm[2,2]^2))/n_B6B8 -
                      mu_B6B8^2
        dtrdat <- data.frame(sens=sst1$sstdat$sens, spec=sst1$sstdat$spec,
                     n_Barm=n_B6B8, mu_Barm=mu_B6B8,
                     sigsq_Barm=sigsq_B6B8)
    }
    if(all(Barm %in% c(6,7))) {
        n_B6B7 <- sst1$sstdat$n_Barm + sst2$sstdat$n_Barm
        
        n_B6G1 <- nA2 * sst1$sstdat$sens * (1-sst1$pG_A1) * (1-sst1$pran_Barm)
        n_B6G0 <- nA2 * (1-sst1$sstdat$spec) * (sst1$pG_A1) * (1-sst1$pran_Barm)

        n_B7G1 <- nA2 * (1-sst2$sstdat$sens) * (1-sst2$pG_A1) * (sst2$pran_Barm)        
        n_B7G0 <- nA2 * (sst2$sstdat$spec) * (sst2$pG_A1) * (sst2$pran_Barm)
        
        ##mixed mean  ## JPS use mu_Barm and n_Barm from smartSST call
        mu_B6B7 <- (sst1$sstdat$n_Barm * sst1$sstdat$mu_Barm +
                    sst2$sstdat$n_Barm * sst2$sstdat$mu_Barm)/(n_B6B7)

        ##mixed sigmasquare
        sigsq_B6B7 <- (n_B6G1*(sigsq_Barm[1,1] + mu_Barm[1,1]^2) +
                       n_B6G0*(sigsq_Barm[1,2] + mu_Barm[1,2]^2) +
                       n_B7G1*(sigsq_Barm[2,1] + mu_Barm[2,1]^2) +
                       n_B7G0*(sigsq_Barm[2,2] + mu_Barm[2,2]^2))/n_B6B7 -
                      mu_B6B7^2
        dtrdat <- data.frame(sens=sst1$sstdat$sens, spec=sst1$sstdat$spec,
                     n_Barm=n_B6B7, mu_Barm=mu_B6B7,
                     sigsq_Barm=sigsq_B6B7)
    }
    
    out <- list(dtrdat=dtrdat, sst1=sst1, sst2=sst2,
                mu_Barm=mu_Barm, sigsq_Barm=sigsq_Barm,Barm = Barm)
#                pG_A1 = pG_A1, pG_A2=pG_A2, pran_A1=pran_A1,  pran_Barm=pran_Barm)   
    ## pG_A1, pran, etc are all within sst objects
    
    ## to assign class, for S3 method dispatch (plot, print)    
    class(out) <- c("smartDTR", "list")
    return(out)
}

print.smartDTR <- function(x, ...) {
  cat("smart DTR object with B-level:", x$Barm, "\n")
  print(x$dtrdat, ...)
  invisible()
}

