
## plot smart DTR object

plot.smartDTR <- function(obj, xtype="sens", metric="mean",
                          relativeBias=FALSE, mar=c(4, 4, 4, 6),
                          legend.inset=c(-.2,0), cex.axis = .7, cex.lab=.9, ...) {
    
    if(!("smartDTR" %in% class(obj))) {
        stop("Object not a smartDTR class")
    }

    if(xtype == "sens") {
        ## AEC: u-sens and u-spec to be used below in legend
        ## rather than nrow(dat)
        usens <- sort(unique(obj$dtr$sens), decreasing=FALSE)
        seqst <- min(usens)
        seqend <- max(usens)
        seqtick <- usens[2] - usens[1]      
    } else {
        uspec <- sort(unique(obj$dtrdat$spec), decreasing=FALSE)
        seqst <- min(uspec)
        seqend <- max(uspec)
        seqtick <- uspec[2] - uspec[1]
    }

    if(metric == "mean" & relativeBias ==FALSE) {
    #Plot mixed mean
      mudat <- obj$dtrdat[,c("sens", "spec", "mu_Barm")]
      Blabel <- paste0("B",obj$Barm[1], "B", obj$Barm[2])        

      if(xtype == "spec") { 
        par(mar=mar, xpd=TRUE)
        interaction.plot(mudat$spec, mudat$sens, mudat$mu_Barm,
           xlab=expression(paste("Specificity",(pi[2]))),
           ylab=paste0("Expected mean of ", Blabel),col=c(1:nrow(mudat)), lwd=2,
           legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
        legend("topright", inset=legend.inset,
           legend = c(seq(seqst,seqend,by=seqtick)),
           lty=c(nrow(mudat):1),col=c(1:nrow(mudat)),
           lwd=2,title=expression(paste("Sensitivity",(pi[1]))),bty="n",cex=cex.axis) 
      }  ## if spec
      if(xtype == "sens") { 
        par(mar=mar, xpd=TRUE)
        interaction.plot(mudat$sens, mudat$spec, mudat$mu_Barm,
           xlab=expression(paste("Sensitivity",(pi[2]))),
           ylab=paste0("Expected mean of ", Blabel),col=c(1:nrow(mudat)), lwd=2,
           legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
        legend("topright", inset=legend.inset,
           legend = c(seq(seqst,seqend,by=seqtick)),
           lty=c(nrow(mudat):1),col=c(1:nrow(mudat)),
           lwd=2,title=expression(paste("Specificity",(pi[1]))),bty="n",cex=cex.axis) 
      } ## if sens
    }  #metric mean & !relativeBias

    if(metric == "variance" & relativeBias == FALSE) {
      sigdat <- obj$dtrdat[,c("sens", "spec", "sigsq_Barm")]
      Blabel <- paste0("B",obj$Barm[1], "B", obj$Barm[2])        

      if(xtype == "spec") { 
        par(mar=mar, xpd=TRUE)
        interaction.plot(sigdat$spec, sigdat$sens, sigdat$sigsq_Barm,
           xlab=expression(paste("Specificity",(pi[2]))),
           ylab=paste0("Estimated variance of ", Blabel),col=c(1:nrow(sigdat)), lwd=2,
           legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
        legend("topright", inset=legend.inset,
           legend = c(seq(seqst,seqend,by=seqtick)),
           lty=c(nrow(sigdat):1),col=c(1:nrow(sigdat)),
           lwd=2,title=expression(paste("Sensitivity",(pi[1]))),bty="n",cex=cex.axis) 
      }  ## if spec
      if(xtype == "sens") { 
        par(mar=mar, xpd=TRUE)
        interaction.plot(sigdat$sens, sigdat$spec, sigdat$sigsq_Barm,
           xlab=expression(paste("Sensitivity",(pi[2]))),
           ylab=paste0("Estimated variance of ", Blabel),col=c(1:nrow(sigdat)), lwd=2,
           legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
        legend("topright", inset=legend.inset,
           legend = c(seq(seqst,seqend,by=seqtick)),
           lty=c(nrow(sigdat):1),col=c(1:nrow(sigdat)),
           lwd=2,title=expression(paste("Specificity",(pi[1]))),bty="n",cex=cex.axis) 
      } ## if sens
    }  #metric variance
    
    if(metric == "mean" & relativeBias==TRUE) {
      mudat <- obj$dtrdat[,c("sens", "spec", "mu_Barm")]
      true_mumix <- (obj$sst1$pG_A1*obj$sst1$pran_Barm*obj$sst1$mu_Barm["G1"] +
                      (1-obj$sst2$pG_A1)* obj$sst2$pran_Barm * obj$sst2$mu_Barm["G0"]) /
             (obj$sst1$pG_A1 * obj$sst1$pran_Barm + (1-obj$sst2$pG_A1)*obj$sst2$pran_Barm)
      ##true_mu_B1B3 <- (pG_A1*Pran_B1B2*mu_A1B1G1R1+(1-pG_A1)*Pran_B3B4*mu_A1B3G0R0)/(pG_A1*Pran_B1B2+(1-pG_A1)*Pran_B3B4)
      mudat$bias_Barm <- 100 * (true_mumix - mudat$mu_Barm)/true_mumix
      Blabel <- paste0("B",obj$Barm[1], "B", obj$Barm[2])        
      colnames(mudat) <- gsub("Barm", Blabel, colnames(mudat))
      if(xtype == "spec") { 
        par(mar=mar, xpd=TRUE)
        interaction.plot(mudat$spec, mudat$sens, mudat[,grep("bias", colnames(mudat))],
           xlab=expression(paste("Specificity",(pi[2]))),
           ylab=paste0("Bias of mixed mean of ", Blabel, "(%)"),col=c(1:nrow(mudat)), lwd=2,
           legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
        legend("topright", inset=legend.inset,
           legend = c(seq(seqst,seqend,by=seqtick)),
           lty=c(nrow(mudat):1),col=c(1:nrow(mudat)),
           lwd=2,title=expression(paste("Sensitivity",(pi[1]))),bty="n",cex=cex.axis) 
      }  ## if spec
      if(xtype == "sens") { 
        par(mar=mar, xpd=TRUE)
        interaction.plot(mudat$sens, mudat$spec, mudat[,grep("bias", colnames(mudat))],
           xlab=expression(paste("Sensitivity",(pi[2]))),
           ylab=paste0("Bias of mixed mean of ", Blabel, "(%)"),col=c(1:nrow(mudat)), lwd=2,
           legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
        legend("topright", inset=legend.inset,
           legend = c(seq(seqst,seqend,by=seqtick)),
           lty=c(nrow(mudat):1),col=c(1:nrow(mudat)),
           lwd=2,title=expression(paste("Specificity",(pi[1]))),bty="n",cex=cex.axis) 
      } ## if sens
    }  #metric bias of mixed mean

    ##Bias of mixed variance
    if(metric == "variance" & relativeBias==TRUE) {
        ## true_sigsq_B1B3<-(pG_A1*(sigsq_A1B1G1R1+mu_A1B1G1R1^2)*Pran_B1B2+(1-pG_A1)*(sigsq_A1B3G0R0+mu_A1B3G0R0^2)*Pran_B3B4)/
           ##       (pG_A1*Pran_B1B2+(1-pG_A1)*Pran_B3B4)-(true_mu_B1B3)^2   
     #bias_B1B3_s <- (true_sigsq_B1B3-sigsq_B1B3)/true_sigsq_B1B3*100      
      sigdat <- obj$dtrdat[,c("sens", "spec", "sigsq_Barm")]
      true_sigmix <- (obj$sst1$pG_A1*obj$sst1$pran_Barm*(obj$sigsq_Barm[1,1] + obj$mu_Barm[1,1]^2) +
          (1-obj$sst2$pG_A1)*obj$sst2$pran_Barm*(obj$sigsq_Barm[2,2] + obj$mu_Barm[2,2]^2))/
          (obj$sst1$pG_A1 * obj$sst1$pran_Barm + (1-obj$sst2$pG_A1)*obj$sst2$pran_Barm)
    #  browser()   
      #  true_sigmix <- (obj$sst1$pG_A1*obj$sst1$pran_Barm*obj$sst1$sigsq_Barm["G1"] +
      #                (1-obj$sst2$pG_A1)* obj$sst2$pran_Barm * obj$sst2$sigsq_Barm["G0"]) /
      #       (obj$sst1$pG_A1 * obj$sst1$pran_Barm + (1-obj$sst2$pG_A1)*obj$sst2$pran_Barm)
      ##true_mu_B1B3 <- (pG_A1*Pran_B1B2*mu_A1B1G1R1+
        ## (1-pG_A1)*Pran_B3B4*mu_A1B3G0R0)/ (pG_A1*Pran_B1B2+(1-pG_A1)*Pran_B3B4)
      sigdat$bias_Barm <- 100 * (true_sigmix - sigdat$sigsq_Barm)/true_sigmix

      Blabel <- paste0("B",obj$Barm[1], "B", obj$Barm[2])        
      colnames(sigdat) <- gsub("Barm", Blabel, colnames(sigdat))
      if(xtype == "spec") { 
        par(mar=mar, xpd=TRUE)
        interaction.plot(sigdat$spec, sigdat$sens, sigdat[,grep("bias", colnames(sigdat))],
           xlab=expression(paste("Specificity",(pi[2]))),
           ylab=paste0("Bias of mixed variance of ", Blabel, "(%)"),col=c(1:nrow(sigdat)), lwd=2,
           legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
        legend("topright", inset=legend.inset,
           legend = c(seq(seqst,seqend,by=seqtick)),
           lty=c(nrow(sigdat):1),col=c(1:nrow(sigdat)),
           lwd=2,title=expression(paste("Sensitivity",(pi[1]))),bty="n",cex=cex.axis) 
      }  ## if spec
      if(xtype == "sens") { 
        par(mar=mar, xpd=TRUE)
        interaction.plot(sigdat$sens, sigdat$spec, sigdat[,grep("bias", colnames(sigdat))],
           xlab=expression(paste("Sensitivity",(pi[2]))),
           ylab=paste0("Bias of mixed variance of ", Blabel, "(%)"),col=c(1:nrow(sigdat)), lwd=2,
           legend=FALSE,cex.lab=cex.lab, cex.axis=cex.axis, cex.main=cex.lab)
        legend("topright", inset=legend.inset,
           legend = c(seq(seqst,seqend,by=seqtick)),
           lty=c(nrow(sigdat):1),col=c(1:nrow(sigdat)),
           lwd=2,title=expression(paste("Specificity",(pi[1]))),bty="n",cex=cex.axis) 
      } ## if sens
    }  #metric bias of mixed variance

    invisible()
}
