#$Author: sinnwell $
#$Date: 2011/02/16 14:33:20 $
#$Header: /projects/genetics/cvs/cvsroot/mend.err/R/print.sge.q,v 1.1.1.1 2011/02/16 14:33:20 sinnwell Exp $
#$Locker:  $
#$Log: print.sge.q,v $
#Revision 1.1.1.1  2011/02/16 14:33:20  sinnwell
#initial for mend.err package
#
#Revision 1.3  2009/02/25 22:13:35  sinnwell
#add keywords
#
# This function prints the return value of an object of class "sge" in a 
# tabular data.frame fashion.

print.sge <-function(x,loc.display=NULL,display.column=NULL,...)
{
 # Retrieve fields of x that are of interest:

 n               <- x$n
 nLoci           <- x$nLoci
 loci.used       <- x$loci.used
 ped             <- x$ped
 allele.labels   <- x$allele.labels
 locus.labels    <- x$locus.labels
 err.locus       <- x$err.locus
 err.relation    <- x$err.relation
 err.spouse      <- x$err.spouse
 nGeno           <- n*nLoci
 pedigree.column <- x$pedigree.column
 person.column   <- x$person.column
 labID.column    <- x$labID.column
 father.column   <- x$father.column
 mother.column   <- x$mother.column
 sex.column      <- x$sex.column

 
 if(is.null(display.column))
    display.column <- c(pedigree.column, person.column, labID.column,
                        father.column,   mother.column, sex.column)

 # The return value from the sge() function returns genotype data with the 
 # first nLoci items belonging to peson 1, the second nLoci items belonging
 # to person 2, and so on.  This print funtion will print out locus 1 for 
 # all members of the pedigree, then locus 2 will be printed out, and this 
 # will continue until all nLoci loci have been printed out in serial order.
 # Therefore, we must from a permutation vector, called perm, will will reorder
 # the original genotype data, which is given per person, into the desired 
 # format for printing, which is per locus:

 offset <- nLoci*(0:(n-1))
 perm   <- numeric(nGeno)
 
 for(i in 1:nLoci)
    perm[((i-1)*n+1):(i*n)] <- offset + i

 # Reorder the genotypes so that they are listed per locus:

 tmp.list <- list(NULL)
 j <- 0
 for(i in 1:n)
     tmp.list[((i-1)*nLoci + 1):(i*nLoci)] <- x$person[[i]]$locus
 
 tmp.list <-tmp.list[perm]

 # Convert the recoded genotype allele codes back to their original uncoded
 # values:

 # genoList.tmp will hold genotype lists with their original coding restored:

 genoList.tmp <- list(NULL)

 for(i in 1:nLoci)
   {
    genoList.tmp[[i]] <- unlist(tmp.list[((i-1)*n + 1):(i*n)])
    genoList.tmp[[i]][genoList.tmp[[i]] == -1] <- length(allele.labels[[i]])
    genoList.tmp[[i]] <- allele.labels[[i]][genoList.tmp[[i]]]
   }

 # Form a two-column matrix that will hold the genotypes in (allele1,allele2) 
 # fashion:

 tmp.geno      <- matrix(unlist(genoList.tmp),ncol=2,byrow=T)
 tmp.geno.rows <- nrow(tmp.geno)

 # Allocate vectors to held other columns of the pedigree in 
 # addition to the genotypes above:

 tmp.pedigree   <- matrix(ped[1,pedigree.column],nrow = tmp.geno.rows, ncol=1)
 tmp.person     <- matrix("",nrow = tmp.geno.rows, ncol=1)
 if(!is.null(labID.column))
    tmp.labID      <- matrix("",nrow = tmp.geno.rows, ncol=1)
 tmp.father     <- matrix("",nrow = tmp.geno.rows, ncol=1)
 tmp.mother     <- matrix("",nrow = tmp.geno.rows, ncol=1)
 tmp.sex        <- matrix("",nrow = tmp.geno.rows, ncol=1)

 index          <- x$genoLengths
 index          <- index[perm]
 index          <- index / 2

 for(i in 2:nGeno)
    index[i]    <- index[i] + index[i-1]

 index          <- index + 1
 index[2:nGeno] <- index[1:(nGeno-1)]
 index[1]       <- 1

 tmp.person[index,1] <- ped[,person.column]
 if(!is.null(labID.column))
    tmp.labID[index,1]  <- ped[,labID.column]
 tmp.father[index,1] <- ped[,father.column]
 tmp.mother[index,1] <- ped[,mother.column]
 tmp.sex[index,1]    <- ped[,sex.column]

 tmp <- data.frame(cbind(tmp.pedigree,
                         tmp.person,
                         if(!is.null(labID.column)) 
                            tmp.labID 
                         else 
                            NULL,
                         tmp.father,
                         tmp.mother,
                         tmp.sex,
                         tmp.geno))


 ncol.tmp <- ncol(tmp)
 tmp <- tmp[,c(display.column,ncol.tmp-1,ncol.tmp)]

 if(!is.null(labID.column))
   {
    tmp.names  <- c("Pedigree",  "Person",    
                    "LabID",      "Father",    
                    "Mother",     "Sex",       
                    "Allele 1",   "Allele 2")
    tmp.names  <- c(tmp.names[display.column],tmp.names[7], tmp.names[8])
   }
 else
   {
    tmp.names  <- c("Pedigree",  "Person",    
                    "Father",     "Mother",     
                    "Sex",        "Allele 1",   
                    "Allele 2")
 tmp.names  <- c(tmp.names[display.column],tmp.names[6], tmp.names[7])
   }
 names(tmp) <- tmp.names

 # locus.index will hold the row index of the start of each locus.  This 
 # will allow a separate table to be printed for each locus:

 locus.index   <-index[(0:(nLoci - 1))*n + 1]
 locus.index[nLoci+1] <- tmp.geno.rows + 1

 # The following is used to allow the user to display a subset of the loci 
 # present in an object of class "sge":

 tmp.index <- 1:nLoci
 if(is.null(loc.display))
   {
    # Display all loci:
    loci2display <- tmp.index
   }
 else if(all(loc.display <= 0))
        {
         # Remove any loci specified as negative indices, i.e. myVec[-1]
         if(any(abs(loc.display) > nLoci))
           {
            msg <- paste("Locus range is 1:",nLoci,"\n",sep="")
            warning(msg)
           }
         loci2display <- tmp.index
         loc.display  <- loc.display[loc.display >= -nLoci]
         if(length(loc.display > 0))
            loci2display <- loci2display[loc.display]
        }
 else if(all(loc.display >= 0))
        {
         if(any(loc.display > nLoci))
           {
            msg <- paste("Locus range is 1:",nLoci,"\n",sep="")
            warning(msg)
           }
         # Display all loci that are within bounds:
         loci2display <- loc.display[0 < loc.display & loc.display <= nLoci]
        }
 else 
   {
    # loc.display contains invalid values:
    err.msg <- "loc.display must be specified as a vector of integers that are "
    err.msg <- paste("\n", err.msg, "all non-negative \nor all non-positive.",
                     sep="")
    stop(err.msg)
   }

 cat("\n")

 for(i in loci2display)
   {
    cat("#################################################################\n")
    if(err.locus[i])
      {
       cat("                         MENDELIAN ERROR\n\n")
       cat(paste("There was a Mendelian Error detected in person ", 
                  ped[,person.column][err.locus[i]],
                  " at locus ",locus.labels[loci.used[i]],
                  ".\n\n",
                  sep =""))

       if(err.relation[i] == 1)
         {
          msg <- paste("This error was detected when person ",
                       ped[,person.column][err.locus[i]],
                       " was being processed as\na child in a nuclear family.\n",
                       "\n",
                       sep="")
          cat(msg)
         }
       else             ##### err.relation[i] == 2
         {
          msg <- paste("This error was detected when person ",
                       ped[,person.column][err.locus[i]],
                       " was being processed as\na parent in a nuclear family",
                       " with spouse ",
                       ped[,person.column][err.spouse[i]],
                       ".\n\n",
                       sep="")
          cat(msg)
         }
      }
    cat(paste("Locus ", locus.labels[loci.used[i]], ": \n\n",sep=""))
    print(tmp[locus.index[i]:(locus.index[i+1] - 1),])
    cat("\n\n")
  }

 invisible()
 return(tmp)
}


