#$Author: sinnwell $
#$Date: 2011/02/16 14:33:20 $
#$Header: /projects/genetics/cvs/cvsroot/mend.err/R/print.mend.err.q,v 1.1.1.1 2011/02/16 14:33:20 sinnwell Exp $
#$Locker:  $
#$Log: print.mend.err.q,v $
#Revision 1.1.1.1  2011/02/16 14:33:20  sinnwell
#initial for mend.err package
#
#Revision 1.2  2009/02/25 22:13:35  sinnwell
#add keywords
#
print.mend.err <- function(x,...)
{
 # This function prints out the return value of mend.err() in tabular form:

 ped.no.err  <- x$ped.no.err
 ped.err     <- x$ped.err
 ped.missing <- x$ped.missing
 n.ped       <- x$n.ped
 n.err       <- x$n.err

 cat("\n")
 msg <-paste("################################",
             "#########",
             "################################\n",
             "########################",
                " MENDELIAN ERROR RESULTS ",
             "########################\n",
             "################################",
             "#########",
             "################################\n\n",
             sep="")
 cat(msg)

 cat("<0 = No Mendelian Error, 1 = Mendelian Error>:\n")


 # Pedigrees without Mendelian Errors:

 if(!is.null(ped.no.err))
   {
    cat("\nThe following pedigrees had no Mendelian Errors:\n\n")
    print(ped.no.err)
   }

 # Pedigrees with Mendelian Errors:
 if(!is.null(ped.err))
   {
    cat("\nThe following pedigrees had Mendelian Errors:\n\n")
    print(ped.err)
   }

 # Pedigrees with no allele data:

 if(!is.null(ped.missing))
   {
    cat("\nThe following pedigrees had no genotype data:\n\n")
    print(ped.missing)
   }

 # Display the total number of pedigrees with errors:

 if(n.err == 0)
   cat("\n\nNo pedigrees contained Mendelian Errors.\n")
 else if(n.err == 1)
   cat(paste("\n\nThere was ",n.err,
             " pedigree with Mendelian Errors.\n",
               sep=""))
 else
   cat(paste("\n\nThere were ",n.err,
             " pedigrees with Mendelian Errors.\n",
               sep=""))

 # Display the total number of pedigrees processed:

 if(n.ped == 1)
    cat(paste("A total of ",
              n.ped,
             " pedigree was processed.\n\n",
               sep=""))
 else
    cat(paste("A total of ",
               n.ped,
             " pedigrees were processed.\n\n",
               sep=""))

 invisible()
 return(x)
}
