#$Author: sinnwell $
#$Date: 2011/02/25 16:37:23 $
#$Header: /projects/genetics/cvs/cvsroot/mend.err/R/print.sge.jackknife.q,v 1.2 2011/02/25 16:37:23 sinnwell Exp $
#$Locker:  $
#$Log: print.sge.jackknife.q,v $
#Revision 1.2  2011/02/25 16:37:23  sinnwell
#long to int, add x.sexcheck, T to TRUE
#
#Revision 1.1.1.1  2011/02/16 14:33:20  sinnwell
#initial for mend.err package
#
#Revision 1.3  2009/02/25 22:13:35  sinnwell
#add keywords
#
print.sge.jackknife <- function(x, display.orig=FALSE,...)
{
 orig            <- x$orig
 ped             <- orig$ped
 geno            <- orig$geno
 typed           <- x$typed
 n.typed         <- x$n.typed
 loci            <- x$loci
 loci.used       <- orig$loci.used
 locus.labels    <- orig$locus.labels
 results         <- x$results
 pedigree.column <- orig$pedigree.column
 person.column   <- orig$person.column
 labID.column    <- orig$labID.column
 
 if(display.orig)
   {
    # Display the orignal results that will be jackknifed:
    cat("The original genotype eliminated pedigree is:\n\n")
    print(orig)
   }

  cat("\n")
  cat(paste("At the following loci in pedigree ",
            ped[1,pedigree.column],
            ", jackknifing one of the \nlisted subjects",
            " will eliminate Mendelian Errors:\n\n",sep = ""))

  subject.start <- 1
  locus.start   <- 1
  locus.end     <- 0
 
  for(i in 1:length(loci))
     {
      pedigree <- NULL
      person   <- NULL
      labID    <- NULL
      allele1  <- NULL
      allele2  <- NULL
      k        <- 1
      
      msg <-paste("########################### ",
                  "LOCUS ",
                  locus.labels[loci[i]],
                  " ###########################\n",
                  sep="")
      cat(msg)
      cat(paste("Locus ",locus.labels[loci[i]],":\n",sep=""))
      
      subject.end <- n.typed[i]
      locus.end <- locus.end + subject.end

      mendelian.error  <- as.logical(results[locus.start:locus.end])
      if(all(mendelian.error))
        {
         # Jackknifing has failed to produce a consistent pedigree:
         msg <- paste("No single subject can be jackknifed ",
                      "to eliminate Mendelian Errors in",
                      "\npedigree ",
                      ped[1,pedigree.column],
                      ".\n\n",
                       sep="")
         cat(msg)
        }
      else
        {
         cat("Subjects:  ")
         for(j in (subject.start:subject.end))
            {
             if(!mendelian.error[j])
               {
                 pedigree <- c(pedigree,ped[typed[[i]][j], pedigree.column])
                 person   <- c(person,ped[typed[[i]][j], person.column])
                 if(!is.null(labID.column))
                   labID   <-  c(labID,ped[typed[[i]][j], labID.column])
                 allele1  <- c(allele1,geno[typed[[i]][j],2*loci[i]-1])
                 allele2  <- c(allele2,geno[typed[[i]][j],2*loci[i]])                
                 cat(paste(ped[typed[[i]][j],person.column], " ",sep=""))
               }   #### end if     #####
            }     ##### end for(j) #####

         cat("\nAlleles:\n\n")
         if(!is.null(labID.column))
           {
            tmp <- data.frame(cbind(pedigree,person,labID,allele1,allele2))
            names(tmp) <- c("Pedigree","Person","LabID","Allele1","Allele2")
           } 
         else
           {
            tmp <- data.frame(cbind(pedigree,person,allele1,allele2))
            names(tmp) <- c("Pedigree","Person","Allele1","Allele2")
           }
         print(tmp)
         cat("\n")
         
        }   #### end else   #####
      locus.start <- locus.start + subject.end
     }    ###### end for(i) #####

  invisible()
  return(cat(""))
}
