\name{ld.pairs}
\alias{ld.pairs}
\title{
  Linkage Disequilibrium Measures for Locus Pairs
}
\description{
For un-phased genotypes with di-allele or multi-allele markers, 
compute linkage disequilibrium statistics for locus pairs based 
on haplotype frequency estimates.
}
\usage{
ld.pairs(geno, locus.label=NA, miss.val=c(0,NA), r2=FALSE, em.control=haplo.em.control())
}
\arguments{
\item{geno}{
Matrix of alleles, such that each locus has a pair of adjacent columns
of alleles, and the order of columns corresponds to the order of loci 
on a chromosome.  If there are K loci, then geno has 2*K columns. Rows
represent all observed alleles for each subject.
}
\item{locus.label }{
Vector of labels for the loci in geno, has length K (see definition 
of geno matrix).
}
\item{miss.val }{
Vector of codes for missing values of alleles
}
\item{r2}{
Logical, if TRUE, compute r2 measure for LD.  Only applies to SNP loci.
}
\item{em.control }{
List of control parameters for the haplo.em function.  
}
}
\value{
A data frame with the columns described as follows.

\item{loc1, loc2}{
Index for the pair of loci considered for linkage disequilibrium measure.
}
\item{loc1.label, loc2.label }{
Names for the loci pair indexed by loc1 and loc2, extracted from locus.label
}
\item{dprime.ave }{
The weighted average of the dprime (D') measure of linkage disequilibrium. For
two loci with m and n #-alleles, weight the (m-1)*(n-1) D' measures by
the expected haplotype frequency under no linkage disequilibrium.
}
\item{r2 }{
r-squared, commonly used LD measure, commonly interpreted as the
correlation between two SNP loci.
}
\item{lr.stat, lr.df, and lr.pval}{
Likelihood Ratio test statistic, degrees of freedom, and p-value based
on the likelihood from combined haplotype frequencies with and without
Linkage Disequilibrium.  (See haplo.em)
}
\item{comp.stat, comp.df, comp.pval}{
Composite LD test statistic, degrees of freedom, and p-value.
The composite LD measures contributions of LD between two
alleles when they appear either on the same diplotype or opposing
diplotypes, making haplotype frequency estimation irrelevant.
}
}
\section{Side Effects}{

}
\details{
The composite LD measure was extended from Weir and Cockerham (1989)
to apply to multi-allelic loci by Schaid (2003).  For two loci with m
and n alleles, the (m-1)*(n-1) ld measures (D) have a var-covar matrix
(V) which can be approximated by Fischer's approximation using Taylor series
expansion.  The global compositeLD test statistic (a result of the
computation of t(D) \%*\% inverse(V) \%*\%D) has an approximate chi-square
distribution with (m-1)*(n-1) degrees of freedom.
}
\section{References}{
Hedrick PW. "Gametic disequilibrium measures: proceed with
caution." Genetics. 117.2 (1987): 331-41.
}
\section{}{
Weir BS, and Cockerham CC. "Complete characterization of
disequilibrium at two loci."  Mathematical Evolutionary Theory, (Ed.)
M.W. Feldman, Princeton University Press. (1989): 86-110.
}
\section{}{
Schaid DJ.  Linkage Disequilibrium Testing when Linkage Phase is
Unknown.  Genetics. 166.1 (2004):505-512.
}
\seealso{
haplo.em, compositeLD
}
\examples{
 
 "geno.random" <- matrix(c(c(4, 2, 4, 4, 2, 2, 4, 2, 1, 3)
                , c(4, 3, 4, 1, 2, 4, 3, 4, 2, 4)
                , c(2, 2, 2, 3, 1, 3, 1, 3, 3, 2)
                , c(2, 3, 3, 3, 3, 3, 3, 2, 3, 3)
                , c(4, 3, 3, 1, 4, 4, 2, 2, 4, 3)
                , c(2, 4, 4, 1, 4, 4, 1, 4, 3, 1)
                , c(3, 2, 4, 4, 4, 4, 2, 1, 2, 4)
                , c(3, 2, 4, 3, 4, 3, 3, 4, 3, 4)
                ), ncol=10, byrow=TRUE)

  ld.obj5 <- ld.pairs(geno.random,c("A","B","C","D", "E"))
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 43267.
