#$Author: sinnwell $
#$Date: 2006/10/17 18:14:01 $
#$Header: /projects/genetics/cvs/cvsroot/hwe/R/hwe.exact.bi.q,v 1.2 2006/10/17 18:14:01 sinnwell Exp $
#$Locker:  $
#$Log: hwe.exact.bi.q,v $
#Revision 1.2  2006/10/17 18:14:01  sinnwell
#add keywords
#
hwe.exact.bi <- function(a1,a2){

# Title: HWE exact test for a locus with 2 alleles

# Author: Dan Schaid

# Compute exact test for HWE for a biallelic locus
# See Weir Genetic Data Analysis II, p 99

# a1 and a2 are vectors of alleles w/o missing values


   n <- length(a1)
   t1 <- ifelse(a1 < a2, a1, a2)
   t2 <- ifelse(a2 > a1, a2, a1)
   avec <- c(t1,t2)
   avec <- factor(avec)

   # Observed genotype counts
   t1 <- avec[1:n]
   t2 <- avec[(n+1):(2*n)]
   tbl <- table(t1,t2)
   y <- tbl[row(tbl) <= col(tbl)]

   #  y = vector of genotype counts arranged as:
   #            (homozygote, heterozygote, other homozygote)

   n.allele <- nrow(tbl)

   if(n.allele>2) stop("Exact test not for >2 alleles")
  

   # if only a single type of homozygote is observed, then there
   # is no variation at the locus, and cannot test for HWE, so
   # return NA

   if(y[1]==n | y[3]==n) return(NA)

   nab <- y[2]
   naa <- min(y[-2])
   na <- 2*naa + nab
   x <- na - 2*(0:floor(na/2))

   px <- exp(lgamma(n+1) + lgamma(na + 1) +
       lgamma(2*n - na + 1) + x*log(2) -
       lgamma((na - x)/2 + 1) - lgamma(x+1) -
       lgamma(n - (na+x)/2 + 1) - lgamma(2*n + 1) )

   pab <- px[x==nab]
   pval <- sum(px[px <= pab])
   return(pval)

}

