hwe.stats <- function(a1,a2){

# Title: HWE Statistical Tests

# Author: Dan Schaid

   # a1 and a2 are vectors of alleles w/o missing values

   # n = number of people
   n <- length(a1)

   # rearrange alleles so that for each person, a1 <= a2

   t1 <- ifelse(a1 < a2, a1, a2)
   t2 <- ifelse(a2 > a1, a2, a1)
   avec <- c(t1,t2)
   avec <- factor(avec)

   # Observed genotype counts (upper triangular matrix,
   # because t1 <= t2)

   t1 <- avec[1:n]
   t2 <- avec[(n+1):(2*n)]
   tbl <- table(t1,t2)

   # Pull out upper triangular of matrix and convert to vector
   ob <- tbl[row(tbl) <= col(tbl)]

   # n.allele = number unique alleles
   n.allele <- nrow(tbl)
 
   # Expected genotype counts if HWE
   p <- as.vector(table(avec))
   p <- p/sum(p)
   ex <- 2*(p %o% p)
  
   # fix diagonals to be p^2
   diag(ex) <- p^2

   ex <- n*ex
   # Pull out upper triangular of matrix and convert to vector
   ex <- ex[row(ex) <= col(ex)]

   #df = number of heterozygotes
   df <- n.allele*(n.allele-1)/2
   stat.chi <- sum((ob-ex)^2/ex)
   pval.chi <- 1-pchisq(stat.chi,df)

   # Stats for simulated likelihood stat
   # log Prob(observed genotypes)
   # h = # heterozygotes
   h <- sum(tbl) - sum(diag(tbl))
   ln.pobs <-  h*log(2) - sum(lgamma(ob[ob>0] + 1))
 

   # Rare Homozygotes Stat
   ua <-1:nrow(tbl)
   u.score <- matrix(rep(-1,n.allele^2),ncol=n.allele)
   diag(u.score) <- (1-p)/p
   u.score <- u.score[row(u.score) <= col(u.score)]
   stat.rare <- sum(ob*u.score)^2/(n*(n.allele-1))
   pval.rare <- 1-pchisq(stat.rare,1)
 
   
   return(list(stat.chi=stat.chi,pval.chi=pval.chi,df=df,
              ob=ob,ex=ex,ln.pobs=ln.pobs, u.score=u.score,
               stat.rare=stat.rare, pval.rare=pval.rare,
               n=n, n.allele=n.allele))
}
