#$Author: sinnwell $
#$Date: 2011/02/25 14:13:57 $
#$Header: /projects/genetics/cvs/cvsroot/hwe/R/hwe.q,v 1.9 2011/02/25 14:13:57 sinnwell Exp $
#$Locker:  $
#$Log: hwe.q,v $
#Revision 1.9  2011/02/25 14:13:57  sinnwell
#C long to int, now works in R on linux
#
#Revision 1.8  2006/05/22 19:17:50  sinnwell
#set variable for object@x.linked because it didn't work in R, use it throughout
#
#Revision 1.7  2003/06/10 17:44:29  folie
#Subsetting operations fixed
#
#Revision 1.6  2003/06/06 17:57:36  folie
#Handles loci with only one allele code
#
#Revision 1.5  2003/02/05 17:33:53  folie
#Spurious warnings now suppressed.
#
#Revision 1.4  2003/01/17 19:26:03  folie
#Checking in version 1.4
#
hwe <- function(object, n.sim=0, sex=NULL, seed.val=NULL){

# Title: HWE tests for Locus Object
# Author: Dan Schaid
   x.linked <- attributes(object)$x.linked
   if(!inherits(object,'model.matrix'))
      { stop("Not legitimate locus object.") }

   # subset to non-missing genotypes
   valid <- !is.na(object[,1]) & !is.na(object[,2]) 

   # also subset to non-missing sex if x-linked, and 
   # create female = T/F if female/male

   # Flag that indicates if x.linked field of object was temporarily set to F
   resetX.linked=FALSE
   
   if(x.linked)
     { valid <- valid & !is.na(sex) 
       sex <- sex[valid]
       female.code=attr(object,"female.code")
       female <- sex==female.code

       if(all(female))              # Treat X-linked object as autosomal
          { x.linked=FALSE       # for HWE simulation purposes.
            resetX.linked=TRUE }
       
       if(!any(female))
          { warning("Locus is X-linked but contains no females: hwe failed")
            return(NULL)
          }
     }

   tmp                       <- object[valid,]
   attr(tmp,"chrom.label")   <- attr(object,"chrom.label")
   attr(tmp,"locus.alias")   <- attr(object,"locus.alias")
   attr(tmp,"x.linked")      <- attr(object,"x.linked")
   attr(tmp,"allele.labels") <- attr(object,"allele.labels")
   attr(tmp,"male.code")     <- attr(object,"male.code")
   attr(tmp,"female.code")   <- attr(object,"female.code")
   oldClass(tmp)             <- "model.matrix"
   object                    <- tmp
      
   # Stop if there are x.linked related errors
   if(x.linked)
      { x.sexcheck(object, sex, stop=TRUE) }

   a1 <- object[,1]
   a2 <- object[,2]

   n <- length(a1)
   
   if(n==0)
     { warning("Length of allele vector is zero: hwe failed")
       return(NULL) }

   # Check if there is only one distinct allele code present:
   sample <- a1[1]
   if(all(sample==a1) && all(sample==a2))
     {
      # If x.linked was set to F for simulation purposes, 
      # we need to reset it to avoid data corruption.
      if(resetX.linked)
        { x.linked = TRUE }
       
      hwe.obj <-
        list(gof.stat=0.0,
             gof.df=0,
             gof.pval=1.0,
             rare.stat=0.0,
             rare.df=0,
             rare.pval=1.0,
             gof.sim.pval=1.0,
             rare.sim.pval=1.0,
             like.sim.pval=1.0,
             like.exact.pval=1.0,
             n.sim=0,
             x.linked=x.linked)

      oldClass(hwe.obj) <- "hwe"

      return(hwe.obj)
     }

   
   # recode to be sure integer codes have no gaps

   tmp <- as.numeric(factor(c(a1,a2)))

   a1 <- tmp[1:n]
   a2 <- tmp[(n+1):(2*n)]
   
   n.alleles <- length(unique(c(a1,a2)))

   # observed statistics

   if(x.linked)
      { obs.stats <- hwex.stats(a1,a2,female) }
   else
      { obs.stats <- hwe.stats(a1,a2) }


   # exact p-values only for 2 unique alleles
   pval.exact <- NULL
   if(n.alleles==2)
     { if(x.linked)
          { pval.exact <- hwe.exact.bi(a1[female],a2[female]) }
       else
          { pval.exact <- hwe.exact.bi(a1,a2) }
     }

   pval.sim <- NULL
   if(n.sim > 0 &  n.alleles > 2)
     { if(x.linked)
          { pval.sim <- hwex.sim(a1,a2,female,n.sim=n.sim, iseed=seed.val) }
       else
          { pval.sim <- hwe.sim(a1,a2,n.sim=n.sim, iseed=seed.val) }
     }   

   # If x.linked was set to F for simulation purposes, we need to reset it to
   # avoid data corruption.
   if(resetX.linked)
     { x.linked = TRUE }
       
   hwe.obj <-
     list(gof.stat=obs.stats$stat.chi,
          gof.df=obs.stats$df,
          gof.pval=obs.stats$pval.chi,
          rare.stat=obs.stats$stat.rare,
          rare.df=1,
          rare.pval=obs.stats$pval.rare,
          gof.sim.pval=(if(is.null(pval.sim)) NULL else pval.sim$pval.chi),
          rare.sim.pval=(if(is.null(pval.sim)) NULL else pval.sim$pval.rare),
          like.sim.pval=(if(is.null(pval.sim)) NULL else pval.sim$pval.like),
          like.exact.pval=pval.exact,
 	  n.sim=n.sim,
          x.linked=x.linked)

   oldClass(hwe.obj) <- "hwe"

   return(hwe.obj)
 }


                     
