\name{fastlo}
\alias{fastlo}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ fastlo() - function to perform a fast cyclic loess normalization (Mayo HSR)}
\description{
fastlo() performs a fast cyclic loess normalization.
It does not produce the same results as cyclic loess but does run considerably faster.
}
\usage{
fastlo(x, subset, maxit = 3, mfun = NULL, log.it = T, verbose = T, epsilon = 0.01, MM = F, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ a matrix whose rows are the parameters measured and whose columns are the subjects. In microarray analyses the rows are the individual probes and the columns are the chips.}
  \item{subset}{ an index into a subset of the rows to be used in the process. }
  \item{maxit}{ the maximum number of iterations to use. Usually 3 iterations are more than enough. }
  \item{mfun}{ allows a function to be used to override the simple \code{yhat=mean()} estimator function used to estimate \code{yhat}. }
  \item{log.it}{ do we want to log the PM values before fitting them (default is TRUE) }
  \item{verbose}{ report processing information during process (default is TRUE) }
  \item{epsilon}{ convergence criteria (default is 0.01). }
  \item{parallel}{ boolean indicating whether loess models should be run in parallel using SNOW package (default is FALSE). }
  \item{\dots}{ allows passing through of parameters. Not used. }
}
\details{
  No additional details.
}
\value{
  A matrix containing normalized values, organized the same way as the input matrix \code{x}.
}
\references{ Ballman KV, Grill DE, Oberg AL, Therneau TM. Faster cyclic loess: normalizing RNA arrays via linear models. Bioinformatics 2004 Nov 1; 20(16):2778-86. }
\author{ Terry Therneau }
\section{Copyright}{Copyright 2004 Mayo Clinic College of Medicine.
 
This software is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.
}
 
\note{ 
 
This software is accepted by users "as is" and without warranties or
guarantees of any kind.  It may be used for research purposes or in
relation to projects with commercial applications or included in commercial
packages, but only so long as it is not relicensed as a stand-alone
program, and only so long as the first two sentences of this paragraph
(copyright notice and no warranty) are reproduced with the software.
 
This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
more details.
}
 
\seealso{ \code{\link{loess}} }
\examples{
 theNorm <- fastlo(matrix(1:2000,nrow=100)
 
## The function is currently defined as
function(x, subset, maxit=3, mfun=NULL, log.it=T,verbose=T,
                   epsilon = 0.01,MM=F,...) {
 
        lc<-loess.control(surface="interpolate",statistics="approximate",
                          trace.hat="approximate",cell=0.2,iterations=4)
             #### HAD TO ADD FOR R
        if (class(x) == 'Plob') {
                if (MM) y<-rbind(x@pm,x@mm) 
                else y<-x@pm
              }
        
        else {
             if (class(x) == 'matrix') y<-x
             else { cat("x must be a matrix or Probe Level Object","\n" )
                     return() }
           }
        
 dtemp <- dimnames(y)     #save the dimnames of y for later
 dimnames(y) <- NULL      # this speeds things up
 
 nchip <- ncol(y)
      nspot <- nrow(y)
 
        if(!missing(subset)){
  if(length(subset==1)) {   #if a subset exists take a sample      
                        subset <- sample(1:nspot, subset)
                                      }
  else {
   if(any(subset < 1 | subset > nspot))
                          stop("Invalid number of rows in subset argument")
                     }
                            }
 else {    ##when subset = missing takes all of the rows ####                   
  subset <- 1:nspot
              }
      
 if(log.it) y <- logb(y,2)
 
   # initialize matrices with same dimensions as of y but filled with zeros.
      smooth <- matrix(0., ncol=nchip, nrow=nspot)
      old.smooth<-smooth
      ichange <- smooth 
      ii <- 0
 
 change <- epsilon+1  ## predefine change so that it goes through loop
        w<-c(0,rep(1,length(subset)),0) ##weights for loess fit
        
 while((ii < maxit) && (change > epsilon))
 {
  ii <- ii + 1
            if(verbose) cat("\n")
  if(is.null(mfun))
                  {
   yhat <- rowMeans(y - smooth)  # this is faster
                  }
  else
                  {
   yhat <- apply(y - smooth, 1, mfun)
                  }
                
                index<-c(order(yhat)[1],subset, order(-yhat)[1]) 
 
            for(j in 1:nchip) {  
     temp <- loess(c(y[index,j] - yhat[index]) ~ yhat[index],
                                           degree=1,weights=w,control=lc)
     smooth[,j] <- predict(temp,yhat)
               if (verbose) cat("   ", j)               
                                  }
               if (verbose) cat("\n")
               
  ichange <- smooth-old.smooth
  old.smooth <- smooth
  change <- max(apply((ichange[subset,])^2,2,mean))
                if (verbose) cat("\n Finished iteration ",ii,";","\n","Change = ",
                       change,"\n") 
 }
 if (verbose) cat("\n")
 
 ynorm <- y - smooth    # normalized y
 dimnames(ynorm) <- dtemp
 if(log.it) ynorm<-2^ynorm
        if(MM) {
           pm<-ynorm[1:(nspot/2), ]
           mm<-ynorm[((nspot/2)+1):nspot, ]
          return(pm,mm) }
 else
  return(ynorm)
  }
}
\keyword{ normalization }% at least one, from doc/KEYWORDS
\keyword{ microarray }% __ONLY ONE__ keyword per line
\keyword{ Mayo }% __ONLY ONE__ keyword per line
