# $Id: summary.peakfit.s 1177 2006-10-17 21:53:41Z rxc13@MFAD.MFROOT.ORG $
#
# Calculate further summary information from a fit
summary.peakfit <- function(x) {

    fit <- x$fit
    p <- x$p
    cmat <- matrix(c(1,0,0,0, 0,1,0,0,  0, 1-p, p, 0, 
                     0, (1-p)^2, 2*p*(1-p), p^2),ncol=4)
    xmat <- cbind(rep(x$xmat[,1], ncol(x$y)),
                  rep(x$xmat[,2], ncol(x$y)),
                  rep(x$xmat[,3], ncol(x$y)))
    xmat <- cbind(1, xmat* x$alpha[col(x$y)])  #scaled x matrix
    xtx <- t(xmat) %*% (x$weight*xmat)
    sigma <- sum(x$weight* fit$resid^2)/(sum(x$weight)-length(fit$coef))

    beta <- fit$coef
    zeros <- (beta==0)

    # For testing, I remove the try() function.  (We want it to fail).
    #
    err <- try (bvar <- solve(t(cmat) %*% xtx %*%cmat) )
    if (class(err) == "Error") {
      #cat(err)
      return(list())
    }
    if (class(err)!="Error") {
      bvar <- solve(t(cmat) %*% xtx %*%cmat)
    }
    delta <- (cmat %*% beta) 

    err <- try(dvar <- solve(xtx)[-1,-1])
    if (class(err)=="Error") {
      #cat(err)
      return(list())
    }
    if (class(err)!="Error") {
      dvar <- solve(xtx)[-1,-1]
    }
    
    # Theta requires an estimate of s
    s <- x$p * x$pc

    if (s==0) smat <- cbind(c(1,0,0,0), c(0,1,0,0), c(0,0,1,1))
    else smat <- cbind(c(1, 0, 0, 0), 
                       c(0, 1, 0, 0), 
                       c(0, (1 - s)^2, 2 *s*(1 - s), s^2))

                  
    err <- try (tvar <- solve(t(smat) %*% xtx %*% smat))
    if (class(err) == "Error") {
      #cat(err)
      return(list())
    }
    if (class(err)!="Error") {
      tvar <- solve(t(smat) %*% xtx %*% smat)
    }
    
    theta <- x$theta
    # Note that delta[1] = theta[1] = beta[1], so some have been trimmed
    tmat <- cbind(c(beta, delta[-1], theta), 
                  sqrt(sigma)* c(sqrt(diag(bvar)), sqrt(diag(dvar)),
                                 sqrt(diag(tvar[-1,-1]))))
    dimnames(tmat) <- list(c("Intercept", "beta1", "beta2", "beta3",
                             "delta1", "delta2", "delta3", 
                             "theta1", "theta2"),
                           c("Coef", "std"))
	
    # Now do the estimate of theta2/theta1, Feiller's theorem
    #  All the notation below is straight out of the Encyclopedia of Biostat
    rho <- theta[2]/theta[1]
    f0 <- theta[2]^2 - 1.96^2 *tvar[3,3]*sigma
    f1 <- theta[1]*theta[2] - 1.96^2*tvar[3,2]*sigma
    f2 <- theta[1]^2 - 1.96^2*tvar[2,2]*sigma
    D <- f1^2 - f0*f2

    ybar <- sum(x$y * x$weight)/ sum(x$weight)
    yvar <- sum((x$y - ybar)^2 * x$weight)/ (sum(x$weight) -1)
    ##The original r2 is wrong. Basically it is mse/mstotal when it need to be sse/sstotal
    ##r2 <- 1 - sigma/yvar
    r2 <- 1 - (sigma*(sum(x$weight)-length(fit$coef)))/(yvar*(sum(x$weight) -1))
    
    zed <- list(coefficients=tmat, theta.var=tvar*sigma, rho=rho, 
                theta.ci= pmax(0,(f1 + c(-1,1)* sqrt(D))/f2), rsquare=r2,
                species=x$species, alpha=x$alpha, nmass=x$nmass,
                p=x$p, pc=x$pc, gfit=x$gfit, s=s
             )
    oldClass(zed) <- 'summary.peakfit'
    zed
    }
