# $Id: print.peakfit.s 1177 2006-10-17 21:53:41Z rxc13@MFAD.MFROOT.ORG $
print.peakfit <- function(x, s) {
    temp <- paste("Fit for species", x$species)
    if (!is.null(x$mass)) temp <- paste(temp, ", with ", x$mass[1],
                                          " <= mass <= ", x$mass[2], sep='')
    if (!is.null(x$fraction)) {
        if (length(x$fraction)==1 || diff(x$fraction)==0)
            temp <- paste(temp, "and scx fraction =", x$fraction[1])
        else temp <- paste(temp, "and", x$fraction[1], "<= scx fraction <=",
                           x$fraction[2])
        }
    cat(temp, "\n")
    cat("\t", ncol(x$y), "profiles were fit\n\t\t", format(min(x$alpha)), 
        "< alpha <", format(max(x$alpha)), 
        "\n\t\tsum(alpha) =", format(sum(x$alpha)), "\n\n")
    
    fit <- x$fit
    p <- x$p
    cmat <- matrix(c(1,0,0,0, 0,1,0,0,  0, 1-p, p, 0, 
                     0, (1-p)^2, 2*p*(1-p), p^2),ncol=4)
    xmat <- cbind(rep(x$xmat[,1], ncol(x$y)),
                  rep(x$xmat[,2], ncol(x$y)),
                  rep(x$xmat[,3], ncol(x$y)))
    xmat <- cbind(1, xmat* x$alpha[col(x$y)])  #scaled x matrix
    xtx <- t(xmat) %*% (x$weight*xmat)
    sigma <- sum(x$weight* fit$resid^2)/(sum(x$weight)-length(fit$coef))

    beta <- fit$coef
    zeros <- (beta==0)
    bvar <- solve(t(cmat) %*% xtx %*%cmat)

    delta <- (cmat %*% beta) 
    dvar <- solve(xtx)[-1,-1]

    # Theta requires an estimate of s
    if (missing(s)) s <- ifelse(beta[4]==0, 0, 2*beta[4]/(2*beta[4] + beta[3]))

    if (s==0) smat <- cbind(c(1,0,0,0), c(0,1,0,0), c(0,0,1,1))
    else      smat <- cbind(c(1,0,0,0), c(0,1,0,0), 
                            c(0, (1-s*p)^2, 2*s*p*(1-s*p), (s*p)^2))

    tvar <- solve(t(smat) %*% xtx %*% smat)
    theta <- x$theta
    tvar <- tvar[-1,-1]

    # Note that delta[1] = theta[1] = beta[1], so some have been trimmed
    tmat <- cbind(c(beta, delta[-1], theta), 
                      sqrt(sigma)* c(sqrt(diag(bvar)), sqrt(diag(dvar)),
                                     sqrt(diag(tvar))))
    dimnames(tmat) <- list(c("Intercept", "beta1", "beta2", "beta3",
                                 "delta1", "delta2", "delta3", 
                                 "theta1", "theta2"),
                               c("Coef", "std"))
#        }
    print(tmat)

    # Now do the estimate of theta2/theta1, Feiller's theorem
    #  All the notation below is straight out of the Encyclopedia of Biostat
    # The exception is that I'm doing theta2/theta1, so f0/f2 trade places
    rho <- theta[2]/theta[1]
    f0 <- theta[2]^2 - 1.96^2 *tvar[2,2]*sigma
    f1 <- theta[1]*theta[2] - 1.96^2*tvar[2,1]*sigma
    f2 <- theta[1]^2 - 1.96^2*tvar[1,1]*sigma
    D <- f1^2 - f0*f2

    cat("\np=", format(p), " Estimated s =", format(s*p), 
        " p_c=", format(s), "\n")
    if (D>=0 && f2 >=0)
        cat("theta2/theta1=", format(rho), "    95% CI=", 
            format(max(0,(f1-sqrt(D))/f2)), format((f1+sqrt(D))/f2),
            "\n")
    
    ybar <- sum(x$y * x$weight)/sum(x$weight)
    yvar <- sum((x$y - ybar)^2 * x$weight)/sum(x$weight)
    r2 <- 1 - sigma/yvar
    cat("Neutral mass=", format(x$nmass), ", R^2=", round(r2,3), "\n")
#   cat("Relative errors for other alignments:\n")
#   print(x$gfit/min(x$gfit) )
    invisible(x)
    }
