plot.peakfit <- function(fit, cols, ...) {
    bfit <- fit$fit
    y <- fit$y
    if (missing(cols)) cols=1:ncol(y)
    
    yhat <- y - bfit$residuals
    if (is.null(fit$iso)) xx <- 1:nrow(y) -1
    else xx <- fit$iso -1
    plot(rep(xx, 2*length(cols)), c(y[,cols], yhat[,cols]), type='n', ...,
            xlab="Isotope number (0=monoisotopic)", ylab="Intensity")

    matpoints(xx, y[,cols], 
            ..., col=1:10, pch='o')

    # add an NA into the data, to make the lines break at the Monoisotope
    if (any(xx== -1)) {
        indx <- which(xx== -1)
        temp <- 1:indx
        xx2 <- c(xx[temp], NA, xx[-temp])
        yhat2 <- rbind(yhat[temp,cols], NA, yhat[-temp,cols])
        matlines(xx2, yhat2, lty=1, col=1:10)
        }
    else matlines(xx, yhat[,cols], lty=1, col=1:10)

    temp <- paste("Species", fit$species)
    if (!is.null(fit$mass)) temp <- paste(temp, ", with ", fit$mass[1],
                                          " <= mass <= ", fit$mass[2], sep='')
    if (!is.null(fit$fraction)) {
        if (length(fit$fraction)==1 || diff(fit$fraction)==0)
            temp <- paste(temp, "and scx=", fit$fraction[1])
        else temp <- paste(temp, "and", fit$fraction[1], "<= scx fraction <=",
                           fit$fraction[2])
        }
    title(temp)
    }
