#
# This is a version of nnls.fit, modified for our use.
# The function variables are equivalent to those in nnls.fit
# The change: if the fit is singular, instead of a "stop" failure,
#   return a fit of just the intercept term.
#
nnls.fit2 <- function(x, y, weights, rank.tol, zero.tol) {
    if(is(x, "series"))
        x <- as.matrix(x@data)
    if(is(y, "series"))
        y <- as.matrix(y@data)
    if(missing(rank.tol))
        rank.tol <- sqrt(.Machine$double.eps)
    if(missing(zero.tol))
        zero.tol <- sqrt(.Machine$double.eps)
    #
    ####
    if(anyMissing(x) || anyMissing(y)) 
        stop("NAs not allowed in response or data")
    x <- as.matrix(x)
    nams <- dimnames(x)
    m <- nrow(x)
    n <- ncol(x)
    if(length(y) < m)
        stop("length of response must equal the number of rows in\n data")

    #
    ####
    weighted <- !missing(weights)
    if(weighted) {
        if(anyMissing(weights))
            stop("NAs not allowed in weights")
        if(!is.numeric(weights))
            stop("weights must be numeric")
        if(min(weights) < 0)
            stop("weights must be nonnegative")
        else if(length(weights) < m) {
            warning("length of weights is less than length of response")
            w <- rep(weights, length = m)
            }
        else if(length(weights) > m) {
            warning("length of weights is greater than length of respons\ne")
            w <- weights[1:m]
            }
        l <- weights != 0
        if(any(!l)) {
            warning("rows with zero weights removed")
            x <- x[l,  ]
            y <- y[l]
            m <- length(l)
            }
        w <- weights[l]
	}
    #
    ############
    ans <- .Fortran("nnls",
                    as.integer(m),
                    as.integer(n),
                    as.double(x),
                    as.integer(m),
                    as.double(y),
                    double(m * n),
                    as.integer(m),
                    double(min(m, n)),
                    coefficients = double(n),
                    residuals = double(m),
                    dual = as.double(if(weighted) {
			if(m >= 3 * n)
                            w
			else c(w, rep(0, 3 * n - m))
                        }
                    else rep(0, 3 * n)),
                    as.integer(if(weighted) max(m, 3 * n) else 3 * n),
                    integer(n),
                    integer(n),
                    rkappa = c(rank.tol, zero.tol),
                    info = integer(1))[c("coef", "res", "dual", "rkappa", 
                                         "info")]
    #
    ###############
    if(ans$info == 1) {
        # it sees a singularity
        ans$coef <- rep(0., ncol(x))
        ans$coef[1] <- mean(y)
        ans$resid <- y - mean(y)
        }

    ans$info <- NULL
    ans$dual <- ans$dual[1:n]
    if(length(nams[[2]]))
        names(ans$dual) <- names(ans$coefficients) <- nams[[2]]
    if(length(names(y)))
        names(ans$residuals) <- names(y)
    else if(length(nams[[1]]))
        names(ans$residuals) <- nams[[1]]
    names(ans$rkappa) <- c("final", "minimum")
    c(ans, list(call = match.call()))
    }
