# bilinear fitting
# needs to be done is S
#
# Fit all of the species found in a data set
# peaks = data set containing the peaks
#     assumed to contain the following variables
#       species : a unique species id; specie(sample)(cluster)
#       cluster/sample: define the peak sets within a species
#       m.z: mass/charge ratio for the peak
#         z: charge
#         y: the data value
#       iso: variable defining suggested isotopic alignment for the peak
#
# sample: optional -- only do the analysis for one of the groups (samples)
#   For the "known" data, for instance, we want to run each ratio separately
#
# nmax = max # of peak sets to fit (used for debugging the code)
# trace: print out messages every 1/100th of the way through
#   ... = args to pass to peakfit.  The most common would be "slim=.70"
#   slim: minimum Sc
#
bilinear <- function(peaks, sample, nmax, trace=T, ...) {
    Call <- match.call()
    
    dfun <- function(pool) {
        theta1 <- pool$coef[,8]
        theta2 <- pool$coef[,9]
        derv <- cbind(0, -theta2/theta1/theta1, 1/theta1)
        var.theta <- pool$theta.var
        ratio <- theta2/theta1
        var.ratio <- 0*ratio
        for (i in 1:length(ratio)) {
            var.ratio[i] <- t(derv[i,]) %*% var.theta[i,,] %*% derv[i,]
            }
        sqrt(var.ratio)
        }

    if (!missing(sample)) {
        indx <- which(!is.na(match(peaks$sample, sample)))
        if (length(indx) ==0) stop("No samples match the subset selected")
        peaks <- peaks[indx,]
        }

    # Generate an overall cluster variable (unique within species),
    #  
    tmp <- sort(unique(peaks$sample))
    pclust <- peaks$cluster + max(peaks$cluster +1)*match(peaks$sample, tmp)
    peaks$cluster <- pclust  #this is what fitpeak() expects
    
    species.list <- sort(unique(peaks$species))
    nspecies <- length(species.list)
    if (!missing(nmax) && (nmax < nspecies)) {
	nspecies <- nmax
	species.list <- species.list[1:nmax]
      }
    
    beta <- matrix(0., nrow=nspecies, ncol=9)
    theta.var <- array(0., dim=c(nspecies,3,3))
    theta.ci <- matrix(0., nrow=nspecies,ncol=2)
    delta.method.se <- double(nspecies)
    s <- double(nspecies)
    std  <- beta

    # The fitting routine adds in some zeros, so we don't know
    #  the final lengths of y, yhat, and weight until we get them
    # However, we do know that there will be one "set" per species
    alpha <- vector(mode='list', length=nspecies)
    yvec <- vector(mode='list', length=nspecies)
    resid <- vector(mode='list', length=nspecies)
    nmass <- double(nspecies)
    error <- matrix(0., nspecies, 7)
    rsquare <- double(nspecies)
    best <- double(nspecies)
    
    if (trace) cat("Species to fit = ", nspecies, "\n")

    # fit per specie
    for (i in 1:nspecies) {
        # print message every 1/100th of way through
	if (trace && i%%(ceiling(nspecies/100)) ==0) cat(" ", i);
        keep <- which(peaks$species==species.list[i])
        fit <- try(
                   peakfit(list(data=peaks[keep,],
					species=species.list[i]), ...)
		)
        if (class(fit) == "Error") {
            if (length(grep("Interrupt", fit)) != 0) stop(fit)
            cat (paste("\nProblem fitting species # ", i, ": ", fit, "\n"));
            }
        else {
          if (class(summary(fit))=="summary.peakfit") {
            temp <- summary(fit)
            beta[i,] <- temp$coef[,1]
            std[i,]  <- temp$coef[,2]
            best[i] <- fit$best.state
            theta.var[i,,] <- temp$theta.var
            theta.ci[i,] <- temp$theta.ci
            delta.method.se[i] <- temp$delta.method.se
            s[i] <- temp$s
            alpha[[i]] <- as.vector(fit$alpha)
            nmass[i] <- fit$nmass
            yvec[[i]] <- as.vector(fit$y)
            resid[[i]] <- as.vector(fit$residuals)
            rsquare[i] <- temp$rsquare
            gname <-  as.numeric(names(fit$gfit))+4
            itemp <- seq(max(min(gname),1), min(max(gname),7))
            error[i, itemp] <- fit$gfit[match(gname, itemp, nomatch=0)]
          }
          if (class(summary(fit))!="summary.peakfit") {
            temp <- summary(fit)
            beta[i,] <- NA
            std[i,]  <- NA
            best[i] <- NA
            theta.var[i,,] <- NA
            theta.ci[i,] <- NA
            delta.method.se[i] <- NA
            s[i] <- NA
            alpha[[i]] <- NA
            nmass[i] <- NA
            yvec[[i]] <- NA
            resid[[i]] <- NA
            rsquare[i] <- NA
            gname <-  NA
            itemp <- NA
            error[i, itemp] <- NA
          }
        }
      }
    if (trace) cat("\n")
    dimnames(beta) <- list(NULL, c("Intercept", 
                                           "beta1", "beta2", "beta3",
                                 "delta1", "delta2", "delta3", 
                                 "theta1", "theta2"))
    foo <- list(species=species.list, coef=beta, std=std, alpha=alpha,
                nmass=nmass, best.state=best, residuals=resid,y=yvec,
                error=error, rsquare=rsquare,
                theta.var=theta.var, theta.ci = theta.ci, s=s,
                call=Call)
    foo$delta.method.se <- dfun(foo)
    foo
    }

	
