print.summary.peakfit <- function(x) {
    cat("Fit for species ", x$species, "\n")
    cat("Neutral mass=", format(x$nmass), ", R^2=", round(x$rsquare,3),"\n")
    cat("   ", length(x$alpha), "profiles were fit\n\t", 
        format(min(x$alpha)), 
        "< alpha <", format(max(x$alpha)), 
        "\n\tsum(alpha) =", format(sum(x$alpha)), "\n\n")
    
    print(x$coefficients)

    cat("\np=", format(x$p), " Estimated s =", format(x$p*x$pc), "\n")
    cat("theta2/theta1=", format(x$rho), "    95% CI=", 
         format(pmax(0, x$theta.ci)), "\n")

    cat("\nRelative errors for other alignments:\n")
    print(x$gfit/min(x$gfit) )
    invisible(x)
    }
